/*
 * Decompiled with CFR 0.152.
 */
package lotus.notes.internal;

import java.lang.reflect.Modifier;
import java.util.Enumeration;
import lotus.domino.JavaString;
import lotus.notes.internal.InfoPaneException;
import lotus.notes.internal.InfoPaneItem;
import lotus.notes.internal.InfoPaneMemberItem;
import lotus.notes.internal.InfoPaneVector;

class InfoPaneFieldSubItem
implements InfoPaneItem {
    private InfoPaneVector vector;
    private String name;

    InfoPaneFieldSubItem(String string) {
        this.name = JavaString.getString(string);
        this.vector = new InfoPaneVector();
    }

    InfoPaneFieldSubItem(int n) throws InfoPaneException {
        this("InfoPane_Field_Modifiers");
        if (Modifier.isFinal(n) && !Modifier.isStatic(n)) {
            this.AddMember("final");
        } else if (Modifier.isStatic(n) && !Modifier.isFinal(n)) {
            this.AddMember("static");
        }
        if (Modifier.isTransient(n)) {
            this.AddMember("transient");
        }
        if (Modifier.isVolatile(n)) {
            this.AddMember("volatile");
        }
    }

    InfoPaneFieldSubItem(Class clazz) throws InfoPaneException {
        this("InfoPane_Type");
        String string = "";
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
            string = String.valueOf(string) + "[]";
        }
        this.AddMember(String.valueOf(clazz.getName()) + string, String.valueOf(clazz.toString()) + string);
    }

    InfoPaneFieldSubItem(Object object) throws InfoPaneException {
        this("InfoPane_Value");
        this.AddMember(object.toString());
    }

    InfoPaneMemberItem AddMember(String string) throws InfoPaneException {
        return (InfoPaneMemberItem)this.vector.Insert(new InfoPaneMemberItem(string));
    }

    InfoPaneMemberItem AddMember(String string, String string2) throws InfoPaneException {
        return (InfoPaneMemberItem)this.vector.Insert(new InfoPaneMemberItem(string, string2));
    }

    InfoPaneMemberItem FindMember(String string) {
        return (InfoPaneMemberItem)this.vector.Find(string);
    }

    public boolean HasSubCategory() {
        return this.vector != null && this.vector.size() > 0;
    }

    public Enumeration GetEnumeration() {
        if (this.vector == null) {
            return null;
        }
        return this.vector.elements();
    }

    public String GetName() {
        return this.name;
    }

    public String GetLongName() {
        return this.name;
    }

    public boolean HasLongName() {
        return false;
    }

    public boolean CanPaste() {
        return false;
    }

    public void Print(String string, boolean bl) {
        if (bl && this.HasLongName() && this.CanPaste()) {
            System.out.println(String.valueOf(string) + this.GetLongName());
        } else {
            System.out.println(String.valueOf(string) + this.GetName());
        }
        if (this.HasSubCategory()) {
            Enumeration enumeration = this.GetEnumeration();
            while (enumeration.hasMoreElements()) {
                ((InfoPaneItem)enumeration.nextElement()).Print(String.valueOf(string) + "  ", bl);
            }
        }
    }
}

