/*
 * Decompiled with CFR 0.152.
 */
package lotus.notes.internal;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import lotus.notes.internal.InfoPaneException;
import lotus.notes.internal.InfoPaneItem;
import lotus.notes.internal.InfoPaneMemberItem;
import lotus.notes.internal.InfoPaneMethodSubItem;
import lotus.notes.internal.InfoPaneVector;

class InfoPaneMethodItem
extends InfoPaneMemberItem {
    protected String name;
    protected String longName;
    protected InfoPaneVector vector;

    InfoPaneMethodItem() {
    }

    InfoPaneMethodItem(Method method, boolean bl) {
        this.longName = method.toString();
        this.name = method.getName();
        this.AddParams(method.getParameterTypes());
        if (!Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
            this.longName = this.name;
        }
        this.vector = new InfoPaneVector();
        try {
            this.AddModifiers(method, bl);
            this.AddReturnType(method);
            this.AddThrows(method);
            return;
        }
        catch (InfoPaneException infoPaneException) {
            System.out.println("InfoPaneMethodItem constructor: " + infoPaneException);
            return;
        }
    }

    void AddParams(Class[] classArray) {
        this.name = String.valueOf(this.name) + "(";
        if (classArray != null) {
            try {
                this.AddParam(classArray[0]);
                int n = 1;
                while (classArray[n] != null) {
                    this.name = String.valueOf(this.name) + ",";
                    this.AddParam(classArray[n]);
                    ++n;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        }
        this.name = String.valueOf(this.name) + ")";
    }

    void AddParam(Class clazz) {
        String string = "";
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
            string = String.valueOf(string) + "[]";
        }
        this.name = String.valueOf(this.name) + InfoPaneMemberItem.StripPack(clazz.getName()) + string;
    }

    void AddModifiers(Method method, boolean bl) throws InfoPaneException {
        InfoPaneMethodSubItem infoPaneMethodSubItem = new InfoPaneMethodSubItem(method.getModifiers(), bl);
        if (infoPaneMethodSubItem.HasSubCategory()) {
            this.vector.Insert(infoPaneMethodSubItem);
        }
    }

    void AddReturnType(Method method) throws InfoPaneException {
        InfoPaneMethodSubItem infoPaneMethodSubItem = new InfoPaneMethodSubItem(method.getReturnType());
        this.vector.Insert(infoPaneMethodSubItem);
    }

    void AddThrows(Method method) throws InfoPaneException {
        InfoPaneMethodSubItem infoPaneMethodSubItem = new InfoPaneMethodSubItem(method.getExceptionTypes());
        if (infoPaneMethodSubItem.HasSubCategory()) {
            this.vector.Insert(infoPaneMethodSubItem);
        }
    }

    public boolean HasSubCategory() {
        return this.vector != null && this.vector.size() > 0;
    }

    public Enumeration GetEnumeration() {
        if (this.vector == null) {
            return null;
        }
        return this.vector.elements();
    }

    public String GetName() {
        return this.name;
    }

    public String GetLongName() {
        return this.longName;
    }

    public boolean HasLongName() {
        return this.longName != null && this.name != null && this.longName.length() > this.name.length();
    }

    public boolean CanPaste() {
        return true;
    }

    public void Print(String string, boolean bl) {
        if (bl && this.HasLongName() && this.CanPaste()) {
            System.out.println(String.valueOf(string) + this.GetLongName());
        } else {
            System.out.println(String.valueOf(string) + this.GetName());
        }
        if (this.HasSubCategory()) {
            Enumeration enumeration = this.GetEnumeration();
            while (enumeration.hasMoreElements()) {
                ((InfoPaneItem)enumeration.nextElement()).Print(String.valueOf(string) + "  ", bl);
            }
        }
    }
}

