/*
 * Decompiled with CFR 0.152.
 */
package lotus.notes.internal;

import java.lang.reflect.Modifier;
import java.util.Enumeration;
import lotus.domino.JavaString;
import lotus.notes.internal.InfoPaneException;
import lotus.notes.internal.InfoPaneItem;
import lotus.notes.internal.InfoPaneMemberItem;
import lotus.notes.internal.InfoPaneVector;

class InfoPaneMethodSubItem
implements InfoPaneItem {
    private InfoPaneVector vector;
    private String name;

    InfoPaneMethodSubItem(String string) {
        this.name = JavaString.getString(string);
        this.vector = new InfoPaneVector();
    }

    InfoPaneMethodSubItem(int n, boolean bl) throws InfoPaneException {
        this("InfoPane_Method_Modifiers");
        if (!bl && Modifier.isAbstract(n)) {
            this.AddMember("abstract");
        }
        if (Modifier.isFinal(n)) {
            this.AddMember("final");
        }
        if (Modifier.isNative(n)) {
            this.AddMember("native");
        }
        if (Modifier.isSynchronized(n)) {
            this.AddMember("synchronized");
        }
    }

    InfoPaneMethodSubItem(Class[] classArray) throws InfoPaneException {
        this("InfoPane_Throws");
        try {
            int n = 0;
            while (classArray[n] != null) {
                Class clazz = classArray[n];
                if (Modifier.isPublic(clazz.getModifiers())) {
                    this.AddMember(clazz.getName(), clazz.toString());
                }
                ++n;
            }
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
    }

    InfoPaneMethodSubItem(Class clazz) throws InfoPaneException {
        this("InfoPane_Return_Type");
        String string = "";
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
            string = String.valueOf(string) + "[]";
        }
        this.AddMember(String.valueOf(clazz.getName()) + string, String.valueOf(clazz.toString()) + string);
    }

    InfoPaneMemberItem AddMember(String string) throws InfoPaneException {
        return (InfoPaneMemberItem)this.vector.Insert(new InfoPaneMemberItem(string));
    }

    InfoPaneMemberItem AddMember(String string, String string2) throws InfoPaneException {
        return (InfoPaneMemberItem)this.vector.Insert(new InfoPaneMemberItem(string, string2));
    }

    InfoPaneMemberItem FindMember(String string) {
        return (InfoPaneMemberItem)this.vector.Find(string);
    }

    public boolean HasSubCategory() {
        return this.vector != null && this.vector.size() > 0;
    }

    public Enumeration GetEnumeration() {
        if (this.vector == null) {
            return null;
        }
        return this.vector.elements();
    }

    public String GetName() {
        return this.name;
    }

    public String GetLongName() {
        return this.name;
    }

    public boolean HasLongName() {
        return false;
    }

    public boolean CanPaste() {
        return false;
    }

    public void Print(String string, boolean bl) {
        if (bl && this.HasLongName() && this.CanPaste()) {
            System.out.println(String.valueOf(string) + this.GetLongName());
        } else {
            System.out.println(String.valueOf(string) + this.GetName());
        }
        if (this.HasSubCategory()) {
            Enumeration enumeration = this.GetEnumeration();
            while (enumeration.hasMoreElements()) {
                ((InfoPaneItem)enumeration.nextElement()).Print(String.valueOf(string) + "  ", bl);
            }
        }
    }
}

