/*
 * Decompiled with CFR 0.152.
 */
package lotus.notes.internal;

import java.util.Enumeration;
import lotus.domino.JavaString;
import lotus.notes.internal.InfoPaneClassItem;
import lotus.notes.internal.InfoPaneException;
import lotus.notes.internal.InfoPaneItem;
import lotus.notes.internal.InfoPanePackageSubItem;
import lotus.notes.internal.InfoPaneVector;

class InfoPanePackageItem
implements InfoPaneItem {
    private InfoPaneVector vector;
    private String name;

    InfoPanePackageItem(String string) {
        this.name = string;
        this.vector = new InfoPaneVector();
    }

    InfoPanePackageSubItem FindPackageSub(String string) {
        return (InfoPanePackageSubItem)this.vector.Find(JavaString.getString("InfoPane_" + string));
    }

    InfoPaneClassItem FindClass(String string) {
        return this.FindClassOrInterface("Classes", string);
    }

    InfoPaneClassItem FindInterface(String string) {
        return this.FindClassOrInterface("Interfaces", string);
    }

    InfoPaneClassItem FindClassOrInterface(String string, String string2) {
        InfoPanePackageSubItem infoPanePackageSubItem = this.FindPackageSub(string);
        if (infoPanePackageSubItem == null) {
            return null;
        }
        return infoPanePackageSubItem.FindClass(string2);
    }

    InfoPanePackageSubItem AddPackageSub(String string) throws InfoPaneException {
        return (InfoPanePackageSubItem)this.vector.Insert(new InfoPanePackageSubItem(string));
    }

    InfoPaneClassItem AddClass(String string, String string2) throws InfoPaneException {
        return this.AddClassOrInterface("Classes", string, string2);
    }

    InfoPaneClassItem AddInterface(String string, String string2) throws InfoPaneException {
        return this.AddClassOrInterface("Interfaces", string, string2);
    }

    InfoPaneClassItem AddClassOrInterface(String string, String string2, String string3) throws InfoPaneException {
        InfoPanePackageSubItem infoPanePackageSubItem = this.FindPackageSub(string);
        if (infoPanePackageSubItem == null) {
            infoPanePackageSubItem = this.AddPackageSub(string);
        }
        return infoPanePackageSubItem.AddClass(string2, string3);
    }

    public boolean HasSubCategory() {
        return this.vector != null && this.vector.size() > 0;
    }

    public Enumeration GetEnumeration() {
        if (this.vector == null) {
            return null;
        }
        try {
            this.vector.Sort();
        }
        catch (InfoPaneException infoPaneException) {
            System.out.println("InfoPanePackageItem.GetEnumeration: " + infoPaneException + " -- could not sort vector in " + this.name);
            infoPaneException.printStackTrace();
        }
        return this.vector.elements();
    }

    public String GetName() {
        return this.name;
    }

    public String GetLongName() {
        return "import " + this.name + ".*;";
    }

    public boolean HasLongName() {
        return true;
    }

    public boolean CanPaste() {
        return true;
    }

    public void Print(String string, boolean bl) {
        if (bl && this.HasLongName() && this.CanPaste()) {
            System.out.println(String.valueOf(string) + this.GetLongName());
        } else {
            System.out.println(String.valueOf(string) + this.GetName());
        }
        if (this.HasSubCategory()) {
            Enumeration enumeration = this.GetEnumeration();
            while (enumeration.hasMoreElements()) {
                ((InfoPaneItem)enumeration.nextElement()).Print(String.valueOf(string) + "  ", bl);
            }
        }
    }
}

