/*
 * Decompiled with CFR 0.152.
 */
package lotus.notes.internal;

import java.util.Enumeration;
import lotus.domino.JavaString;
import lotus.notes.internal.InfoPaneException;
import lotus.notes.internal.InfoPaneItem;
import lotus.notes.internal.InfoPanePackageItem;
import lotus.notes.internal.InfoPaneVector;

class InfoPaneTopItem
implements InfoPaneItem {
    private InfoPaneVector vector;
    String name;

    InfoPaneTopItem(String string) {
        this.name = string;
        this.vector = new InfoPaneVector();
    }

    InfoPanePackageItem FindPackage(String string) {
        return (InfoPanePackageItem)this.vector.Find(string);
    }

    InfoPanePackageItem AddPackage(String string) throws InfoPaneException {
        return this.AddPackage(new InfoPanePackageItem(string));
    }

    InfoPanePackageItem AddPackage(InfoPanePackageItem infoPanePackageItem) throws InfoPaneException {
        return (InfoPanePackageItem)this.vector.Insert(infoPanePackageItem);
    }

    public boolean HasSubCategory() {
        return this.vector != null && this.vector.size() > 0;
    }

    public Enumeration GetEnumeration() {
        if (this.vector == null) {
            return null;
        }
        return this.vector.elements();
    }

    public String GetName() {
        if (this.name.equals("Core") || this.name.equals("Notes")) {
            return JavaString.getString("InfoPane_" + this.name + "_Java");
        }
        return JavaString.getFormattedString("InfoPane_Java", this.name);
    }

    public String GetLongName() {
        return this.GetName();
    }

    public boolean HasLongName() {
        return false;
    }

    public boolean CanPaste() {
        return false;
    }

    public void Print(String string, boolean bl) {
        if (bl && this.HasLongName() && this.CanPaste()) {
            System.out.println(String.valueOf(string) + this.GetLongName());
        } else {
            System.out.println(String.valueOf(string) + this.GetName());
        }
        if (this.HasSubCategory()) {
            Enumeration enumeration = this.GetEnumeration();
            while (enumeration.hasMoreElements()) {
                ((InfoPaneItem)enumeration.nextElement()).Print(String.valueOf(string) + "  ", bl);
            }
        }
    }
}

