/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.dom;

import com.ibm.xml.dom.DeferredAttrImpl;
import com.ibm.xml.dom.DeferredCDATASectionImpl;
import com.ibm.xml.dom.DeferredCommentImpl;
import com.ibm.xml.dom.DeferredDocumentTypeImpl;
import com.ibm.xml.dom.DeferredElementDefinitionImpl;
import com.ibm.xml.dom.DeferredElementImpl;
import com.ibm.xml.dom.DeferredEntityImpl;
import com.ibm.xml.dom.DeferredEntityReferenceImpl;
import com.ibm.xml.dom.DeferredNode;
import com.ibm.xml.dom.DeferredNotationImpl;
import com.ibm.xml.dom.DeferredProcessingInstructionImpl;
import com.ibm.xml.dom.DeferredTextImpl;
import com.ibm.xml.dom.DocumentImpl;
import com.ibm.xml.dom.DocumentTypeImpl;
import com.ibm.xml.dom.ElementImpl;
import com.ibm.xml.dom.NodeImpl;
import com.ibm.xml.framework.AttrPool;
import com.ibm.xml.framework.EntityPool;
import com.ibm.xml.framework.ParserState;
import com.ibm.xml.framework.StringPool;
import java.util.Hashtable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DeferredDocumentImpl
extends DocumentImpl {
    static final long serialVersionUID = 5186323580749626857L;
    private static final boolean DEBUG_PRINT_TABLES = false;
    private static final boolean DEBUG_IDS = false;
    protected static final int CHUNK_SHIFT = 11;
    protected static final int CHUNK_SIZE = 2048;
    protected static final int CHUNK_MASK = 2047;
    protected static final int INITIAL_CHUNK_COUNT = 32;
    protected transient int fNodeCount;
    protected transient byte[][] fNodeType;
    protected transient int[][] fNodeName;
    protected transient int[][] fNodeValue;
    protected transient int[][] fNodeParent;
    protected transient int[][] fNodeFirstChild;
    protected transient int[][] fNodeLastChild;
    protected transient int[][] fNodePrevSib;
    protected transient int[][] fNodeNextSib;
    protected transient int fIdCount;
    protected transient int[] fIdName;
    protected transient int[] fIdElement;
    protected transient ParserState fParserState;
    protected transient StringPool fStringPool;

    public DeferredDocumentImpl(ParserState parserState) {
        this.fParserState = parserState;
        this.fStringPool = parserState.getStringPool();
        this.syncData = true;
        this.syncChildren = true;
    }

    public int createDocument() {
        int n = this.createNode((short)9);
        return n;
    }

    public int createDocumentType(int n) {
        int n2 = this.createNode((short)10);
        int n3 = n2 >> 11;
        int n4 = n2 & 0x7FF;
        this.fNodeName[n3][n4] = n;
        return n2;
    }

    public int createNotation(int n) {
        int n2 = this.createNode((short)12);
        int n3 = n2 >> 11;
        int n4 = n2 & 0x7FF;
        int n5 = this.createNode((short)3);
        int n6 = n5 >> 11;
        int n7 = n5 & 0x7FF;
        this.fNodeValue[n3][n4] = n5;
        EntityPool entityPool = this.fParserState.getEntityPool();
        this.fNodeName[n3][n4] = entityPool.getNotationName(n);
        this.fNodeFirstChild[n6][n7] = entityPool.getPublicId(n);
        this.fNodeLastChild[n6][n7] = entityPool.getSystemId(n);
        return n2;
    }

    public int createEntity(int n) {
        int n2 = this.createNode((short)6);
        int n3 = n2 >> 11;
        int n4 = n2 & 0x7FF;
        int n5 = this.createNode((short)3);
        int n6 = n5 >> 11;
        int n7 = n5 & 0x7FF;
        this.fNodeValue[n3][n4] = n5;
        EntityPool entityPool = this.fParserState.getEntityPool();
        this.fNodeName[n3][n4] = entityPool.getEntityName(n);
        this.fNodeFirstChild[n6][n7] = entityPool.getPublicId(n);
        this.fNodeLastChild[n6][n7] = entityPool.getSystemId(n);
        this.fNodePrevSib[n6][n7] = entityPool.getNotationName(n);
        return n2;
    }

    public int createEntityReference(int n) {
        int n2;
        int n3 = this.createNode((short)5);
        int n4 = n3 >> 11;
        int n5 = n3 & 0x7FF;
        this.fNodeName[n4][n5] = n2 = this.fParserState.getEntityPool().getEntityName(n);
        return n3;
    }

    public int createElement(int n, int n2) {
        int n3 = this.createNode((short)1);
        int n4 = n3 >> 11;
        int n5 = n3 & 0x7FF;
        this.fNodeName[n4][n5] = n;
        if (n2 != -1) {
            AttrPool attrPool = this.fParserState.getAttrPool();
            int n6 = attrPool.getFirstAttr(n2);
            int n7 = -1;
            int n8 = -1;
            int n9 = -1;
            int n10 = n6;
            while (n10 != -1) {
                int n11 = this.createNode((short)2);
                int n12 = n11 >> 11;
                int n13 = n11 & 0x7FF;
                this.fNodeParent[n12][n13] = n3;
                this.fNodeName[n12][n13] = attrPool.getAttrName(n10);
                this.fNodeValue[n12][n13] = attrPool.isSpecified(n10) ? 1 : 0;
                int n14 = this.createNode((short)3);
                int n15 = n14 >> 11;
                int n16 = n14 & 0x7FF;
                this.fNodeValue[n15][n16] = attrPool.getAttValue(n10);
                this.appendChild(n11, n14);
                if (n10 == n6) {
                    this.fNodeValue[n4][n5] = n11;
                } else {
                    this.fNodeNextSib[n8][n9] = n11;
                    this.fNodePrevSib[n12][n13] = n7;
                }
                n7 = n11;
                n8 = n12;
                n9 = n13;
                n10 = attrPool.getNextAttr(n10);
            }
        }
        return n3;
    }

    public int createAttribute(int n, int n2, boolean bl) {
        int n3 = this.createNode((short)2);
        int n4 = n3 >> 11;
        int n5 = n3 & 0x7FF;
        this.fNodeName[n4][n5] = n;
        this.fNodeValue[n4][n5] = bl ? 1 : 0;
        int n6 = this.createTextNode(n2, false);
        this.appendChild(n3, n6);
        return n3;
    }

    public int createElementDefinition(int n) {
        int n2 = this.createNode((short)-1);
        int n3 = n2 >> 11;
        int n4 = n2 & 0x7FF;
        this.fNodeName[n3][n4] = n;
        return n2;
    }

    public int createTextNode(int n, boolean bl) {
        int n2 = this.createNode((short)3);
        int n3 = n2 >> 11;
        int n4 = n2 & 0x7FF;
        this.fNodeValue[n3][n4] = n;
        this.fNodeFirstChild[n3][n4] = bl ? 1 : 0;
        return n2;
    }

    public int createCDATASection(int n) {
        int n2 = this.createNode((short)4);
        int n3 = n2 >> 11;
        int n4 = n2 & 0x7FF;
        this.fNodeValue[n3][n4] = n;
        return n2;
    }

    public int createProcessingInstruction(int n, int n2) {
        int n3 = this.createNode((short)7);
        int n4 = n3 >> 11;
        int n5 = n3 & 0x7FF;
        this.fNodeName[n4][n5] = n;
        this.fNodeValue[n4][n5] = n2;
        return n3;
    }

    public int createComment(int n) {
        int n2 = this.createNode((short)8);
        int n3 = n2 >> 11;
        int n4 = n2 & 0x7FF;
        this.fNodeValue[n3][n4] = n;
        return n2;
    }

    public void appendChild(int n, int n2) {
        int n3;
        int n4 = n >> 11;
        int n5 = n & 0x7FF;
        int n6 = n2 >> 11;
        int n7 = n2 & 0x7FF;
        this.fNodeParent[n6][n7] = n;
        this.fNodePrevSib[n6][n7] = n3 = this.fNodeLastChild[n4][n5];
        if (n3 == -1) {
            this.fNodeFirstChild[n4][n5] = n2;
        } else {
            int n8 = n3 >> 11;
            int n9 = n3 & 0x7FF;
            this.fNodeNextSib[n8][n9] = n2;
        }
        this.fNodeLastChild[n4][n5] = n2;
    }

    public void setAsFirstChild(int n, int n2) {
        int n3 = n >> 11;
        int n4 = n & 0x7FF;
        int n5 = n2 >> 11;
        int n6 = n2 & 0x7FF;
        this.fNodeFirstChild[n3][n4] = n2;
        int n7 = n2;
        while (n7 != -1) {
            n2 = n7;
            n7 = this.fNodeNextSib[n5][n6];
            n5 = n7 >> 11;
            n6 = n7 & 0x7FF;
        }
        this.fNodeLastChild[n3][n4] = n2;
    }

    public int getParentNode(int n) {
        if (n == -1) {
            return -1;
        }
        int n2 = n >> 11;
        int n3 = n & 0x7FF;
        return this.fNodeParent[n2][n3];
    }

    public int getFirstChild(int n) {
        if (n == -1) {
            return -1;
        }
        int n2 = n >> 11;
        int n3 = n & 0x7FF;
        return this.fNodeFirstChild[n2][n3];
    }

    public int getLastChild(int n) {
        if (n == -1) {
            return -1;
        }
        int n2 = n >> 11;
        int n3 = n & 0x7FF;
        int n4 = this.fNodeLastChild[n2][n3];
        if (n4 != -1 && this.fNodeType[n2][n3] == 3) {
            int n5 = this.fNodePrevSib[n2][n3];
            n2 = n5 >> 11;
            n3 = n5 & 0x7FF;
            if (n5 != -1 && this.fNodeType[n2][n3] == 3) {
                while (n5 != -1 && this.fNodeType[n2][n3] == 3) {
                    n = n5;
                    n5 = this.fNodePrevSib[n2][n3];
                    n2 = n5 >> 11;
                    n3 = n5 & 0x7FF;
                }
                return n;
            }
        }
        return n4;
    }

    public int getPreviousSibling(int n) {
        if (n == -1) {
            return -1;
        }
        int n2 = n >> 11;
        int n3 = n & 0x7FF;
        int n4 = this.fNodePrevSib[n2][n3];
        if (n4 != -1 && this.fNodeType[n2][n3] != 3 && this.fNodeType[n2 = n4 >> 11][n3 = n4 & 0x7FF] == 3) {
            while (n4 != -1 && this.fNodeType[n2][n3] == 3) {
                n = n4;
                n4 = this.fNodePrevSib[n2][n3];
                n2 = n4 >> 11;
                n3 = n4 & 0x7FF;
            }
            return n;
        }
        return n4;
    }

    public int getNextSibling(int n) {
        if (n == -1) {
            return -1;
        }
        int n2 = n >> 11;
        int n3 = n & 0x7FF;
        n = this.fNodeNextSib[n2][n3];
        while (n != -1 && this.fNodeType[n2][n3] == 3) {
            n = this.fNodeNextSib[n2][n3];
            n2 = n >> 11;
            n3 = n & 0x7FF;
        }
        return n;
    }

    public int getRealNextSibling(int n) {
        if (n == -1) {
            return -1;
        }
        int n2 = n >> 11;
        int n3 = n & 0x7FF;
        return this.fNodeNextSib[n2][n3];
    }

    public int lookupElementDefinition(int n) {
        if (this.fNodeCount > 1) {
            int n2 = -1;
            int n3 = this.getFirstChild(0);
            while (n3 != -1) {
                if (this.getNodeType(n3) == 10) {
                    n2 = n3;
                    break;
                }
                n3 = this.getNextSibling(n3);
            }
            int n4 = this.getFirstChild(n2);
            while (n4 != -1) {
                if (this.getNodeName(n4) == n) {
                    return n4;
                }
                n4 = this.getNextSibling(n4);
            }
        }
        return -1;
    }

    public int getAttributeList(int n) {
        if (n == -1) {
            return -1;
        }
        int n2 = n >> 11;
        int n3 = n & 0x7FF;
        return this.fNodeValue[n2][n3];
    }

    public DeferredNode getNodeObject(int n) {
        if (n == -1) {
            return null;
        }
        int n2 = n >> 11;
        int n3 = n & 0x7FF;
        byte by = this.fNodeType[n2][n3];
        NodeImpl nodeImpl = null;
        switch (by) {
            case 2: {
                nodeImpl = new DeferredAttrImpl(this, n);
                break;
            }
            case 4: {
                nodeImpl = new DeferredCDATASectionImpl(this, n);
                break;
            }
            case 8: {
                nodeImpl = new DeferredCommentImpl(this, n);
                break;
            }
            case 10: {
                nodeImpl = new DeferredDocumentTypeImpl(this, n);
                this.docType = (DocumentTypeImpl)nodeImpl;
                break;
            }
            case 1: {
                nodeImpl = new DeferredElementImpl(this, n);
                if (this.docElement == null) {
                    this.docElement = (ElementImpl)nodeImpl;
                }
                if (this.fIdElement == null) break;
                int n4 = DeferredDocumentImpl.binarySearch(this.fIdElement, 0, this.fIdCount, n);
                while (n4 != -1) {
                    int n5 = this.fIdName[n4];
                    if (n5 != -1) {
                        String string = this.fStringPool.toString(n5);
                        this.putIdentifier0(string, (Element)((Object)nodeImpl));
                        this.fIdName[n4] = -1;
                    }
                    if (n4 < this.fIdCount && this.fIdElement[n4 + 1] == n) {
                        ++n4;
                        continue;
                    }
                    n4 = -1;
                }
                break;
            }
            case 6: {
                nodeImpl = new DeferredEntityImpl(this, n);
                break;
            }
            case 5: {
                nodeImpl = new DeferredEntityReferenceImpl(this, n);
                break;
            }
            case 12: {
                nodeImpl = new DeferredNotationImpl(this, n);
                break;
            }
            case 7: {
                nodeImpl = new DeferredProcessingInstructionImpl(this, n);
                break;
            }
            case 3: {
                nodeImpl = new DeferredTextImpl(this, n);
                break;
            }
            case -1: {
                nodeImpl = new DeferredElementDefinitionImpl(this, n);
                break;
            }
        }
        if (nodeImpl != null) {
            return nodeImpl;
        }
        throw new IllegalArgumentException();
    }

    public String getNodeNameString(int n) {
        if (n == -1) {
            return null;
        }
        int n2 = n >> 11;
        int n3 = n & 0x7FF;
        int n4 = this.fNodeName[n2][n3];
        if (n4 == -1) {
            return null;
        }
        return this.fStringPool.toString(n4);
    }

    public String getNodeValueString(int n) {
        if (n == -1) {
            return null;
        }
        int n2 = n >> 11;
        int n3 = n & 0x7FF;
        int n4 = this.fNodeValue[n2][n3];
        if (n4 == -1) {
            return null;
        }
        return this.fStringPool.toString(n4);
    }

    public int getNodeName(int n) {
        if (n == -1) {
            return -1;
        }
        int n2 = n >> 11;
        int n3 = n & 0x7FF;
        return this.fNodeName[n2][n3];
    }

    public int getNodeValue(int n) {
        if (n == -1) {
            return -1;
        }
        int n2 = n >> 11;
        int n3 = n & 0x7FF;
        return this.fNodeValue[n2][n3];
    }

    public short getNodeType(int n) {
        if (n == -1) {
            return -1;
        }
        int n2 = n >> 11;
        int n3 = n & 0x7FF;
        return this.fNodeType[n2][n3];
    }

    public void putIdentifier(int n, int n2) {
        if (this.fIdName == null) {
            this.fIdName = new int[64];
            this.fIdElement = new int[64];
        }
        if (this.fIdCount == this.fIdName.length) {
            int[] nArray = new int[this.fIdCount * 2];
            System.arraycopy(this.fIdName, 0, nArray, 0, this.fIdCount);
            this.fIdName = nArray;
            int[] nArray2 = new int[nArray.length];
            System.arraycopy(this.fIdElement, 0, nArray2, 0, this.fIdCount);
            this.fIdElement = nArray2;
        }
        this.fIdName[this.fIdCount] = n;
        this.fIdElement[this.fIdCount] = n2;
        ++this.fIdCount;
    }

    public void print() {
    }

    protected void synchronizeData() {
        this.syncData = false;
        if (this.fIdElement != null) {
            IntVector intVector = new IntVector();
            int n = 0;
            while (n < this.fIdCount) {
                int n2 = this.fIdElement[n];
                int n3 = this.fIdName[n];
                if (n3 != -1) {
                    Node node;
                    intVector.removeAllElements();
                    int n4 = n2;
                    do {
                        intVector.addElement(n4);
                    } while ((n4 = this.getParentNode(n4)) != -1);
                    Node node2 = this;
                    int n5 = intVector.size() - 2;
                    while (n5 >= 0) {
                        n4 = intVector.elementAt(n5);
                        node = node2.getFirstChild();
                        while (node != null) {
                            int n6;
                            if (node instanceof DeferredNode && (n6 = ((DeferredNode)node).getNodeIndex()) == n4) {
                                node2 = node;
                                break;
                            }
                            node = node.getNextSibling();
                        }
                        --n5;
                    }
                    node = (Element)node2;
                    String string = this.fStringPool.toString(n3);
                    this.putIdentifier0(string, (Element)node);
                    this.fIdName[n] = -1;
                    while (this.fIdElement[n + 1] == n2) {
                        string = this.fStringPool.toString(this.fIdName[++n]);
                        this.putIdentifier0(string, (Element)node);
                    }
                }
                ++n;
            }
        }
    }

    protected void synchronizeChildren() {
        this.syncChildren = false;
        NodeImpl nodeImpl = null;
        int n = this.getFirstChild(0);
        while (n != -1) {
            NodeImpl nodeImpl2 = (NodeImpl)((Object)this.getNodeObject(n));
            if (nodeImpl == null) {
                this.firstChild = nodeImpl2;
            } else {
                nodeImpl.nextSibling = nodeImpl2;
            }
            nodeImpl2.parentNode = this;
            nodeImpl2.previousSibling = nodeImpl;
            nodeImpl = nodeImpl2;
            short s = nodeImpl2.getNodeType();
            if (s == 1) {
                this.docElement = (ElementImpl)nodeImpl2;
            } else if (s == 10) {
                this.docType = (DocumentTypeImpl)nodeImpl2;
            }
            n = this.getNextSibling(n);
        }
        if (nodeImpl != null) {
            this.lastChild = nodeImpl;
        }
    }

    protected boolean ensureCapacity(int n, int n2) {
        if (this.fNodeType == null) {
            this.fNodeType = new byte[32][];
            this.fNodeName = new int[32][];
            this.fNodeValue = new int[32][];
            this.fNodeParent = new int[32][];
            this.fNodeFirstChild = new int[32][];
            this.fNodeLastChild = new int[32][];
            this.fNodePrevSib = new int[32][];
            this.fNodeNextSib = new int[32][];
        }
        try {
            return this.fNodeType[n][n2] != 0;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            int n3 = n * 2;
            byte[][] byArray = new byte[n3][];
            System.arraycopy(this.fNodeType, 0, byArray, 0, n);
            this.fNodeType = byArray;
            int[][] nArray = new int[n3][];
            System.arraycopy(this.fNodeName, 0, nArray, 0, n);
            this.fNodeName = nArray;
            nArray = new int[n3][];
            System.arraycopy(this.fNodeValue, 0, nArray, 0, n);
            this.fNodeValue = nArray;
            nArray = new int[n3][];
            System.arraycopy(this.fNodeParent, 0, nArray, 0, n);
            this.fNodeParent = nArray;
            nArray = new int[n3][];
            System.arraycopy(this.fNodeFirstChild, 0, nArray, 0, n);
            this.fNodeFirstChild = nArray;
            nArray = new int[n3][];
            System.arraycopy(this.fNodeLastChild, 0, nArray, 0, n);
            this.fNodeLastChild = nArray;
            nArray = new int[n3][];
            System.arraycopy(this.fNodePrevSib, 0, nArray, 0, n);
            this.fNodePrevSib = nArray;
            nArray = new int[n3][];
            System.arraycopy(this.fNodeNextSib, 0, nArray, 0, n);
            this.fNodeNextSib = nArray;
        }
        catch (NullPointerException nullPointerException) {}
        this.fNodeType[n] = new byte[2048];
        this.fNodeName[n] = new int[2048];
        this.fNodeValue[n] = new int[2048];
        this.fNodeParent[n] = new int[2048];
        this.fNodeFirstChild[n] = new int[2048];
        this.fNodeLastChild[n] = new int[2048];
        this.fNodePrevSib[n] = new int[2048];
        this.fNodeNextSib[n] = new int[2048];
        return true;
    }

    protected int createNode(short s) {
        int n = this.fNodeCount >> 11;
        int n2 = this.fNodeCount & 0x7FF;
        this.ensureCapacity(n, n2);
        this.fNodeType[n][n2] = (byte)s;
        this.fNodeName[n][n2] = -1;
        this.fNodeValue[n][n2] = -1;
        this.fNodeParent[n][n2] = -1;
        this.fNodeFirstChild[n][n2] = -1;
        this.fNodeLastChild[n][n2] = -1;
        this.fNodePrevSib[n][n2] = -1;
        this.fNodeNextSib[n][n2] = -1;
        return this.fNodeCount++;
    }

    protected static int binarySearch(int[] nArray, int n, int n2, int n3) {
        while (n <= n2) {
            int n4 = (n + n2) / 2;
            int n5 = nArray[n4];
            if (n5 == n3) {
                while (n4 > 0 && nArray[n4 - 1] == n3) {
                    --n4;
                }
                return n4;
            }
            if (n5 > n3) {
                n2 = n4 - 1;
                continue;
            }
            n = n4 + 1;
        }
        return -1;
    }

    private void putIdentifier0(String string, Element element) {
        if (this.identifiers == null) {
            this.identifiers = new Hashtable();
        }
        this.identifiers.put(string, element);
    }

    private static void print(int[] nArray, int n, int n2, int n3, int n4) {
    }

    static class IntVector {
        private int[] data;
        private int size;

        public int size() {
            return this.size;
        }

        public int elementAt(int n) {
            return this.data[n];
        }

        public void addElement(int n) {
            this.ensureCapacity(this.size + 1);
            this.data[this.size++] = n;
        }

        public void removeAllElements() {
            this.size = 0;
        }

        private void ensureCapacity(int n) {
            if (this.data == null) {
                this.data = new int[n + 15];
                return;
            }
            if (n > this.data.length) {
                int[] nArray = new int[n + 15];
                System.arraycopy(this.data, 0, nArray, 0, this.data.length);
                this.data = nArray;
            }
        }

        IntVector() {
        }
    }
}

