/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.dom;

import com.ibm.xml.dom.AttrImpl;
import com.ibm.xml.dom.CDATASectionImpl;
import com.ibm.xml.dom.CommentImpl;
import com.ibm.xml.dom.DOMExceptionImpl;
import com.ibm.xml.dom.DOMImplementationImpl;
import com.ibm.xml.dom.DeepNodeListImpl;
import com.ibm.xml.dom.DocumentFragmentImpl;
import com.ibm.xml.dom.DocumentTypeImpl;
import com.ibm.xml.dom.ElementDefinitionImpl;
import com.ibm.xml.dom.ElementImpl;
import com.ibm.xml.dom.EntityImpl;
import com.ibm.xml.dom.EntityReferenceImpl;
import com.ibm.xml.dom.NodeImpl;
import com.ibm.xml.dom.NotationImpl;
import com.ibm.xml.dom.ProcessingInstructionImpl;
import com.ibm.xml.dom.TextImpl;
import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DocumentImpl
extends NodeImpl
implements Document {
    static final long serialVersionUID = 515687835542616694L;
    protected DocumentTypeImpl docType;
    protected ElementImpl docElement;
    protected Hashtable identifiers;

    public DocumentImpl() {
        super(null, null, null);
        this.ownerDocument = this;
    }

    public short getNodeType() {
        return 9;
    }

    public String getNodeName() {
        return "#document";
    }

    public String getNodeValue() {
        return null;
    }

    public Node cloneNode(boolean bl) {
        DocumentImpl documentImpl = new DocumentImpl();
        if (bl) {
            NodeImpl nodeImpl = (NodeImpl)this.getFirstChild();
            while (nodeImpl != null) {
                documentImpl.appendChild(documentImpl.importNode(nodeImpl, true));
                nodeImpl = nodeImpl.nextSibling;
            }
        }
        return documentImpl;
    }

    public Node insertBefore(Node node, Node node2) throws DOMException {
        short s = node.getNodeType();
        if (s == 1 && this.docElement != null || s == 10 && this.docType != null) {
            throw new DOMExceptionImpl(3, null);
        }
        super.insertBefore(node, node2);
        if (s == 1) {
            this.docElement = (ElementImpl)node;
        } else if (s == 10) {
            this.docType = (DocumentTypeImpl)node;
        }
        return node;
    }

    public Node removeChild(Node node) throws DOMException {
        super.removeChild(node);
        short s = node.getNodeType();
        if (s == 1) {
            this.docElement = null;
        } else if (s == 10) {
            this.docType = null;
        }
        return node;
    }

    public void setNodeValue(String string) throws DOMException {
        throw new DOMExceptionImpl(7, null);
    }

    public Attr createAttribute(String string) throws DOMException {
        if (!DocumentImpl.isXMLName(string)) {
            throw new DOMExceptionImpl(5, null);
        }
        return new AttrImpl(this, string);
    }

    public CDATASection createCDATASection(String string) throws DOMException {
        return new CDATASectionImpl(this, string);
    }

    public Comment createComment(String string) {
        return new CommentImpl(this, string);
    }

    public DocumentFragment createDocumentFragment() {
        return new DocumentFragmentImpl(this);
    }

    public Element createElement(String string) throws DOMException {
        if (!DocumentImpl.isXMLName(string)) {
            throw new DOMExceptionImpl(5, null);
        }
        return new ElementImpl(this, string);
    }

    public EntityReference createEntityReference(String string) throws DOMException {
        if (!DocumentImpl.isXMLName(string)) {
            throw new DOMExceptionImpl(5, null);
        }
        return new EntityReferenceImpl(this, string);
    }

    public ProcessingInstruction createProcessingInstruction(String string, String string2) throws DOMException {
        if (!DocumentImpl.isXMLName(string)) {
            throw new DOMExceptionImpl(5, null);
        }
        return new ProcessingInstructionImpl(this, string, string2);
    }

    public Text createTextNode(String string) {
        return new TextImpl(this, string);
    }

    public DocumentType getDoctype() {
        if (this.syncChildren) {
            this.synchronizeChildren();
        }
        return this.docType;
    }

    public Element getDocumentElement() {
        if (this.syncChildren) {
            this.synchronizeChildren();
        }
        return this.docElement;
    }

    public NodeList getElementsByTagName(String string) {
        return new DeepNodeListImpl(this, string);
    }

    public DOMImplementation getImplementation() {
        return DOMImplementationImpl.getDOMImplementation();
    }

    public DocumentType createDocumentType(String string) throws DOMException {
        if (!DocumentImpl.isXMLName(string)) {
            throw new DOMExceptionImpl(5, null);
        }
        return new DocumentTypeImpl(this, string);
    }

    public Entity createEntity(String string) throws DOMException {
        return new EntityImpl(this, string);
    }

    public Notation createNotation(String string) throws DOMException {
        return new NotationImpl(this, string);
    }

    public ElementDefinitionImpl createElementDefinition(String string) throws DOMException {
        return new ElementDefinitionImpl(this, string);
    }

    public Node importNode(Node node, boolean bl) throws DOMException {
        Node node2;
        Object object = null;
        short s = node.getNodeType();
        switch (s) {
            case 1: {
                node2 = this.createElement(node.getNodeName());
                Object object2 = node.getAttributes();
                if (object2 != null) {
                    int n = 0;
                    while (n < object2.getLength()) {
                        node2.setAttributeNode((AttrImpl)this.importNode(object2.item(n), true));
                        ++n;
                    }
                }
                object = (NodeImpl)node2;
                break;
            }
            case 2: {
                object = (NodeImpl)((Object)this.createAttribute(node.getNodeName()));
                break;
            }
            case 3: {
                object = (NodeImpl)((Object)this.createTextNode(node.getNodeValue()));
                break;
            }
            case 4: {
                object = (NodeImpl)((Object)this.createCDATASection(node.getNodeValue()));
                break;
            }
            case 5: {
                object = (NodeImpl)((Object)this.createEntityReference(node.getNodeName()));
                bl = false;
                break;
            }
            case 6: {
                node2 = (Entity)node;
                Object object2 = (EntityImpl)this.createEntity(node.getNodeName());
                ((EntityImpl)object2).setPublicId(node2.getPublicId());
                ((EntityImpl)object2).setSystemId(node2.getSystemId());
                ((EntityImpl)object2).setNotationName(node2.getNotationName());
                object = object2;
                break;
            }
            case 7: {
                object = (ProcessingInstructionImpl)this.createProcessingInstruction(node.getNodeName(), node.getNodeValue());
                break;
            }
            case 8: {
                object = (NodeImpl)((Object)this.createComment(node.getNodeValue()));
                break;
            }
            case 10: {
                int n;
                node2 = (DocumentTypeImpl)this.createDocumentType(node.getNodeName());
                Object object2 = ((DocumentType)node).getEntities();
                NamedNodeMap namedNodeMap = ((DocumentTypeImpl)node2).getEntities();
                if (object2 != null) {
                    n = 0;
                    while (n < object2.getLength()) {
                        namedNodeMap.setNamedItem((EntityImpl)this.importNode(object2.item(n), true));
                        ++n;
                    }
                }
                object2 = ((DocumentType)node).getNotations();
                namedNodeMap = ((DocumentTypeImpl)node2).getNotations();
                if (object2 != null) {
                    n = 0;
                    while (n < object2.getLength()) {
                        namedNodeMap.setNamedItem((NotationImpl)this.importNode(object2.item(n), true));
                        ++n;
                    }
                }
                object = node2;
                break;
            }
            case 11: {
                object = (NodeImpl)((Object)this.createDocumentFragment());
                break;
            }
            case 12: {
                node2 = (Notation)node;
                Object object2 = (NotationImpl)this.createNotation(node.getNodeName());
                ((NotationImpl)object2).setPublicId(node2.getPublicId());
                ((NotationImpl)object2).setSystemId(node2.getSystemId());
                object = object2;
                break;
            }
            default: {
                throw new DOMExceptionImpl(3, null);
            }
        }
        if (bl) {
            node2 = node.getFirstChild();
            while (node2 != null) {
                ((NodeImpl)object).appendChild(this.importNode(node2, true));
                node2 = node2.getNextSibling();
            }
        }
        return object;
    }

    public void putIdentifier(String string, Element element) {
        if (element == null) {
            this.removeIdentifier(string);
        }
        if (this.syncData) {
            this.synchronizeData();
        }
        if (this.identifiers == null) {
            this.identifiers = new Hashtable();
        }
        this.identifiers.put(string, element);
    }

    public Element getIdentifier(String string) {
        if (this.syncData) {
            this.synchronizeData();
        }
        if (this.identifiers == null) {
            return null;
        }
        return (Element)this.identifiers.get(string);
    }

    public void removeIdentifier(String string) {
        if (this.syncData) {
            this.synchronizeData();
        }
        if (this.identifiers == null) {
            return;
        }
        this.identifiers.remove(string);
    }

    public Enumeration getIdentifiers() {
        if (this.syncData) {
            this.synchronizeData();
        }
        if (this.identifiers == null) {
            this.identifiers = new Hashtable();
        }
        return this.identifiers.keys();
    }

    public static boolean isXMLName(String string) {
        char[] cArray = new char[string.length()];
        string.getChars(0, string.length(), cArray, 0);
        if (!Character.isLetter(cArray[0]) && "_:".indexOf(cArray[0]) == -1) {
            return false;
        }
        int n = 1;
        while (n < string.length()) {
            char c = cArray[n];
            int n2 = Character.getType(c);
            if (!Character.isLetterOrDigit(c) && ".-_:".indexOf(c) == -1 && (n2 < 6 || n2 > 8 || c >= '\u06dd' && c <= '\u06de' || c >= '\u20dd' && c <= '\u20e0' || c >= '\u309b') && (n2 != 4 || c >= '\u02d0' && c <= '\u0559' || c >= '\u06e5' && c <= '\u06e6' || c >= '\u309b' && c <= '\u309c') && c != '\u00b7' && c != '\u0387') {
                return false;
            }
            ++n;
        }
        return true;
    }
}

