/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.framework;

import com.ibm.xml.framework.StringPool;
import com.ibm.xml.framework.StringProducer;
import com.ibm.xml.internal.StringHasher;

public final class ChunkyCharArray {
    protected static final int INITIAL_CHUNK_SHIFT = 7;
    protected static final int INITIAL_CHUNK_SIZE = 128;
    protected static final int CHUNK_SHIFT = 14;
    protected static final int CHUNK_SIZE = 16384;
    protected static final int CHUNK_MASK = 16383;
    protected CharArrayChunk fCurrentChunk;
    protected int fLength;

    public ChunkyCharArray(StringPool stringPool) {
        this.fCurrentChunk = new CharArrayChunk(stringPool, null);
    }

    public int length() {
        return this.fLength;
    }

    public void setLength(int n) {
        this.fCurrentChunk.setLength(n);
    }

    public void append(char c) {
        this.fCurrentChunk.append(c);
    }

    public void append(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            this.fCurrentChunk.append(string.charAt(n2));
            ++n2;
        }
    }

    public void append(char[] cArray, int n, int n2) {
        while (n2-- > 0) {
            this.fCurrentChunk.append(cArray[n++]);
        }
    }

    public void append(ChunkyCharArray chunkyCharArray, int n, int n2) {
        this.fCurrentChunk.append(chunkyCharArray, n, n2);
    }

    public int addString(int n, int n2) {
        if (n2 == 0) {
            return 0;
        }
        return this.fCurrentChunk.addString(n, n2);
    }

    public int addSymbol(int n, int n2) {
        if (n2 == 0) {
            return 0;
        }
        return this.fCurrentChunk.addSymbol(n, n2);
    }

    protected final class CharArrayChunk
    implements StringProducer {
        protected StringPool fStringPool;
        protected int fChunk = -1;
        protected int fCurrentIndex;
        protected char[] fData;
        protected CharArrayChunk fPreviousChunk;
        protected CharArrayChunk fNextChunk;

        public CharArrayChunk(StringPool stringPool, CharArrayChunk charArrayChunk) {
            ChunkyCharArray.this = ChunkyCharArray.this;
            this.fStringPool = stringPool;
            this.fChunk = charArrayChunk == null ? 0 : charArrayChunk.fChunk + 1;
            this.fPreviousChunk = charArrayChunk;
            if (charArrayChunk != null) {
                charArrayChunk.fNextChunk = this;
            }
        }

        protected CharArrayChunk(CharArrayChunk charArrayChunk) {
            ChunkyCharArray.this = ChunkyCharArray.this;
            this.fStringPool = charArrayChunk.fStringPool;
            this.fChunk = charArrayChunk.fChunk;
            this.fData = charArrayChunk.fData;
            this.fPreviousChunk = null;
            this.fNextChunk = null;
        }

        protected CharArrayChunk chunkFor(int n) {
            int n2 = n >> 14;
            CharArrayChunk charArrayChunk = this;
            while (n2 != charArrayChunk.fChunk) {
                charArrayChunk = charArrayChunk.fPreviousChunk;
            }
            return charArrayChunk;
        }

        public void setLength(int n) {
            ChunkyCharArray.this.fLength = n;
            ChunkyCharArray.this.fCurrentChunk = this.chunkFor(n);
            this.fCurrentIndex = n & 0x3FFF;
        }

        public void append(char c) {
            try {
                this.fData[this.fCurrentIndex] = c;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (this.fCurrentIndex == 16384) {
                    ChunkyCharArray.this.fCurrentChunk = new CharArrayChunk(this.fStringPool, this);
                    ChunkyCharArray.this.fCurrentChunk.append(c);
                    return;
                }
                char[] cArray = new char[this.fCurrentIndex * 2];
                System.arraycopy(this.fData, 0, cArray, 0, this.fCurrentIndex);
                this.fData = cArray;
                this.fData[this.fCurrentIndex] = c;
            }
            catch (NullPointerException nullPointerException) {
                this.fData = new char[128];
                this.fData[this.fCurrentIndex] = c;
            }
            ++ChunkyCharArray.this.fLength;
            ++this.fCurrentIndex;
        }

        public void append(ChunkyCharArray chunkyCharArray, int n, int n2) {
            CharArrayChunk charArrayChunk = this.chunkFor(n);
            int n3 = n & 0x3FFF;
            if (n3 + n2 <= 16384) {
                chunkyCharArray.append(charArrayChunk.fData, n3, n2);
                return;
            }
            int n4 = 16384 - n3;
            chunkyCharArray.append(charArrayChunk.fData, n3, n4);
            n2 -= n4;
            do {
                charArrayChunk = charArrayChunk.fNextChunk;
                n4 = n2 <= 16384 ? n2 : 16384;
                chunkyCharArray.append(charArrayChunk.fData, 0, n4);
            } while ((n2 -= n4) > 0);
        }

        protected CharArrayChunk createClump(int n) {
            CharArrayChunk charArrayChunk = new CharArrayChunk(this);
            CharArrayChunk charArrayChunk2 = this.fNextChunk;
            CharArrayChunk charArrayChunk3 = charArrayChunk;
            do {
                CharArrayChunk charArrayChunk4;
                charArrayChunk3.fNextChunk = charArrayChunk4 = new CharArrayChunk(charArrayChunk2);
                charArrayChunk2 = charArrayChunk2.fNextChunk;
                charArrayChunk3 = charArrayChunk4;
            } while (charArrayChunk3.fChunk != n);
            return charArrayChunk;
        }

        public int addString(int n, int n2) {
            int n3 = n >> 14;
            if (n3 != this.fChunk) {
                if (this.fPreviousChunk != null) {
                    return this.fPreviousChunk.addString(n, n2);
                }
                System.out.println("fPreviousChunk == null");
                return -1;
            }
            int n4 = n + n2 - 1 >> 14;
            if (n3 == n4) {
                return this.fStringPool.addString(this, n & 0x3FFF, n2);
            }
            if (this.fNextChunk == null) {
                System.out.println("fNextChunk == null");
            }
            return this.fStringPool.addString(this.createClump(n4), n & 0x3FFF, n2);
        }

        public int addSymbol(int n, int n2) {
            int n3 = n >> 14;
            if (n3 != this.fChunk) {
                if (this.fPreviousChunk != null) {
                    return this.fPreviousChunk.addSymbol(n, n2);
                }
                System.out.println("fPreviousChunk == null");
                return -1;
            }
            int n4 = n + n2 - 1 >> 14;
            int n5 = n & 0x3FFF;
            if (n3 == n4) {
                int n6 = 0;
                int n7 = 0;
                while (n7 < n2) {
                    n6 = StringHasher.hashChar(n6, n7, this.fData[n5++] & 0xFFFF);
                    ++n7;
                }
                n6 = StringHasher.finishHash(n6);
                return this.fStringPool.addSymbol(this, n & 0x3FFF, n2, n6);
            }
            int n8 = 0;
            int n9 = 0;
            int n10 = n2;
            int n11 = 16384 - n5;
            while (n5 < 16384) {
                n8 = StringHasher.hashChar(n8, n9++, this.fData[n5++] & 0xFFFF);
            }
            n10 -= n11;
            CharArrayChunk charArrayChunk = this.fNextChunk;
            do {
                n5 = 0;
                n11 = n10 <= 16384 ? n10 : 16384;
                while (n5 < n11) {
                    n8 = StringHasher.hashChar(n8, n9++, charArrayChunk.fData[n5++] & 0xFFFF);
                }
                charArrayChunk = charArrayChunk.fNextChunk;
            } while ((n10 -= n11) > 0);
            n8 = StringHasher.finishHash(n8);
            return this.fStringPool.addSymbol(this.createClump(n4), n & 0x3FFF, n2, n8);
        }

        public String toString(int n, int n2) {
            if (n + n2 <= 16384) {
                return new String(this.fData, n, n2);
            }
            StringBuffer stringBuffer = new StringBuffer(n2);
            int n3 = 16384 - n;
            stringBuffer.append(this.fData, n, n3);
            n2 -= n3;
            CharArrayChunk charArrayChunk = this.fNextChunk;
            do {
                n3 = n2 <= 16384 ? n2 : 16384;
                stringBuffer.append(charArrayChunk.fData, 0, n3);
                charArrayChunk = charArrayChunk.fNextChunk;
            } while ((n2 -= n3) > 0);
            String string = stringBuffer.toString();
            stringBuffer = null;
            return string;
        }

        public boolean equalsString(int n, int n2, String string, int n3) {
            if (n2 != n3) {
                return false;
            }
            if (n + n2 <= 16384) {
                int n4 = 0;
                while (n4 < n2) {
                    if (this.fData[n++] != string.charAt(n4)) {
                        return false;
                    }
                    ++n4;
                }
                return true;
            }
            int n5 = 16384 - n;
            int n6 = 0;
            while (n6 < n5) {
                if (this.fData[n++] == string.charAt(n6++)) continue;
                return false;
            }
            n2 -= n5;
            CharArrayChunk charArrayChunk = this.fNextChunk;
            do {
                n = 0;
                n5 = n2 <= 16384 ? n2 : 16384;
                n2 -= n5;
                while (n5-- > 0) {
                    if (charArrayChunk.fData[n++] == string.charAt(n6++)) continue;
                    return false;
                }
                charArrayChunk = charArrayChunk.fNextChunk;
            } while (n2 > 0);
            return true;
        }
    }
}

