/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.framework;

import com.ibm.xml.framework.Catalog;
import com.ibm.xml.framework.ParserState;
import com.ibm.xml.framework.XMLDocumentHandler;
import com.ibm.xml.framework.XMLDocumentTypeHandler;
import com.ibm.xml.framework.XMLEntityHandler;
import com.ibm.xml.framework.XMLErrorHandler;
import com.ibm.xml.framework.XMLScanner;
import com.ibm.xml.framework.XMLValidationHandler;
import com.ibm.xml.internal.DefaultEntityHandler;
import com.ibm.xml.internal.DefaultScanner;
import com.ibm.xml.internal.DefaultValidationHandler;
import com.ibm.xml.internal.ErrorCode;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class XMLParser
implements Parser,
XMLDocumentTypeHandler,
XMLDocumentHandler,
XMLErrorHandler {
    private ParserState fParserState = new ParserState(this);
    protected XMLScanner fScanner = new DefaultScanner(this.fParserState);
    private XMLEntityHandler fEntityHandler = new DefaultEntityHandler(this.fParserState);
    private ErrorHandler fSAXErrorHandler;
    protected Locale fLocale;
    protected ResourceBundle fResourceBundle;
    private boolean fAllowJavaEncodingName = false;
    private boolean fWarningOnDuplicateAttDef = false;
    private boolean fCheckNamespace = false;
    private boolean fContinueAfterFatalError = false;
    protected boolean fParseInProgress = false;
    protected boolean fNeedReset = false;
    private XMLDocumentHandler fDocHandler;
    private XMLDocumentTypeHandler fDocTypeHandler;
    private XMLValidationHandler fValidationHandler;

    protected XMLParser() {
    }

    public void reset() {
        this.fParserState.reset();
        this.fScanner.reset(this.fParserState);
        this.fEntityHandler.reset(this.fParserState);
        this.fNeedReset = false;
    }

    protected void resetOrCopy() {
        this.fParserState = this.fParserState.resetOrCopy();
        this.fScanner.reset(this.fParserState);
        this.fEntityHandler.reset(this.fParserState);
        this.fNeedReset = false;
    }

    protected void checkHandlers() throws Exception {
    }

    public ParserState getParserState() {
        return this.fParserState;
    }

    public XMLScanner getScanner() {
        return this.fScanner;
    }

    protected Locator getLocator() {
        return this.fScanner.getLocator();
    }

    public void setAllowJavaEncodingName(boolean bl) {
        this.fAllowJavaEncodingName = bl;
    }

    public boolean getAllowJavaEncodingName() {
        return this.fAllowJavaEncodingName;
    }

    public void setWarningOnDuplicateAttDef(boolean bl) {
        this.fWarningOnDuplicateAttDef = bl;
    }

    public boolean getWarningOnDuplicateAttDef() {
        return this.fWarningOnDuplicateAttDef;
    }

    public void setCheckNamespace(boolean bl) {
        this.fCheckNamespace = bl;
    }

    public boolean getCheckNamespace() {
        return this.fCheckNamespace;
    }

    public void setContinueAfterFatalError(boolean bl) {
        this.fContinueAfterFatalError = bl;
    }

    public boolean getContinueAfterFatalError() {
        return this.fContinueAfterFatalError;
    }

    protected void setDocumentHandler(XMLDocumentHandler xMLDocumentHandler) {
        this.fDocHandler = xMLDocumentHandler;
    }

    public XMLDocumentHandler getDocumentHandler() {
        return this.fDocHandler;
    }

    protected void setDocumentTypeHandler(XMLDocumentTypeHandler xMLDocumentTypeHandler) {
        this.fDocTypeHandler = xMLDocumentTypeHandler;
    }

    public XMLDocumentTypeHandler getDocumentTypeHandler() {
        return this.fDocTypeHandler;
    }

    protected void setEntityHandler(XMLEntityHandler xMLEntityHandler) {
        this.fEntityHandler = xMLEntityHandler;
    }

    public XMLEntityHandler getEntityHandler() {
        return this.fEntityHandler;
    }

    public XMLErrorHandler getErrorHandler() {
        return this;
    }

    protected void setValidationHandler(XMLValidationHandler xMLValidationHandler) {
        this.fValidationHandler = xMLValidationHandler;
    }

    public XMLValidationHandler getValidationHandler() {
        return this.fValidationHandler;
    }

    protected void useDefaultValidationHandler() {
        this.fValidationHandler = new DefaultValidationHandler(this.fParserState);
    }

    public void loadCatalog(InputSource inputSource) throws Exception {
        XMLEntityHandler xMLEntityHandler = this.getEntityHandler();
        if (xMLEntityHandler != null) {
            EntityResolver entityResolver = xMLEntityHandler.getEntityResolver();
            if (entityResolver != null) {
                if (entityResolver instanceof Catalog) {
                    ((Catalog)entityResolver).loadCatalog(inputSource);
                    return;
                }
                throw new Exception("EntityResolver is not a Catalog");
            }
            throw new Exception("Catalog not installed");
        }
        throw new Exception("XMLEntityHandler not installed");
    }

    public final void setLocale(Locale locale) throws SAXException {
        if (this.fParseInProgress) {
            throw new SAXException("setLocale may not be called while parsing");
        }
        if (this.fLocale != locale) {
            this.fLocale = locale;
            this.fResourceBundle = null;
        }
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        if (this.fEntityHandler != null) {
            this.fEntityHandler.setEntityResolver(entityResolver);
        }
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
    }

    public void setDocumentHandler(DocumentHandler documentHandler) {
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.fSAXErrorHandler = errorHandler;
    }

    public void parse(InputSource inputSource) throws SAXException, IOException {
        if (this.fParseInProgress) {
            throw new SAXException("parse may not be called while parsing");
        }
        if (this.fNeedReset) {
            this.resetOrCopy();
        }
        try {
            this.checkHandlers();
            this.fParseInProgress = true;
            this.fNeedReset = true;
            this.fScanner.scanDocument(inputSource);
            this.fParseInProgress = false;
            return;
        }
        catch (SAXException sAXException) {
            this.fParseInProgress = false;
            throw sAXException;
        }
        catch (IOException iOException) {
            this.fParseInProgress = false;
            throw iOException;
        }
        catch (Exception exception) {
            this.fParseInProgress = false;
            throw new SAXException(exception);
        }
    }

    public void parse(String string) throws SAXException, IOException {
        InputSource inputSource = new InputSource(string);
        this.parse(inputSource);
        try {
            Reader reader = inputSource.getCharacterStream();
            if (reader != null) {
                reader.close();
                return;
            }
            InputStream inputStream = inputSource.getByteStream();
            if (inputStream != null) {
                inputStream.close();
                return;
            }
        }
        catch (IOException iOException) {}
    }

    public boolean sendCharDataAsCharArray() {
        return false;
    }

    protected boolean errorHandlingEnabled() {
        return this.fSAXErrorHandler != null;
    }

    protected void handleError(String string, String string2) throws Exception {
        SAXParseException sAXParseException = new SAXParseException(string2, this.getLocator());
        if (this.fSAXErrorHandler == null) {
            if (this.isFatal(string)) {
                throw sAXParseException;
            }
            return;
        }
        if (this.isWarning(string)) {
            this.fSAXErrorHandler.warning(sAXParseException);
            return;
        }
        if (this.isFatal(string)) {
            this.fSAXErrorHandler.fatalError(sAXParseException);
            return;
        }
        this.fSAXErrorHandler.error(sAXParseException);
    }

    protected final String getErrorMsgString(String string, Object[] objectArray) {
        String string2;
        block3: {
            if (this.fResourceBundle == null) {
                this.fResourceBundle = this.fLocale == null ? ResourceBundle.getBundle("com.ibm.xml.internal.msg.Message") : ResourceBundle.getBundle("com.ibm.xml.internal.msg.Message", this.fLocale);
            }
            string2 = this.fResourceBundle.getString(string);
            if (objectArray == null) break block3;
            try {
                string2 = MessageFormat.format(string2, objectArray);
            }
            catch (Exception exception) {
                string2 = this.fResourceBundle.getString(string);
                String string3 = ErrorCode.getErrorKey(172);
                string2 = String.valueOf(string2) + this.fResourceBundle.getString(string3);
            }
        }
        return string2;
    }

    protected final boolean isWarning(String string) {
        boolean bl = string.startsWith("W_");
        return bl;
    }

    protected final boolean isFatal(String string) {
        boolean bl = string.startsWith("E_");
        return bl;
    }

    public final void error(int n) throws Exception {
        if (!this.errorHandlingEnabled()) {
            return;
        }
        String string = ErrorCode.getErrorKey(n);
        String string2 = this.getErrorMsgString(string, null);
        this.handleError(string, string2);
    }

    public final void error1(int n, int n2) throws Exception {
        String string = ErrorCode.getErrorKey(n);
        if (!this.errorHandlingEnabled() && !this.isFatal(string)) {
            this.fParserState.getStringPool().releaseString(n2);
            return;
        }
        Object[] objectArray = new String[]{this.fParserState.getStringPool().orphanString(n2)};
        String string2 = this.getErrorMsgString(string, objectArray);
        this.handleError(string, string2);
    }

    public final void error2(int n, int n2, int n3) throws Exception {
        String string = ErrorCode.getErrorKey(n);
        if (!this.errorHandlingEnabled() && !this.isFatal(string)) {
            this.fParserState.getStringPool().releaseString(n2);
            this.fParserState.getStringPool().releaseString(n3);
            return;
        }
        Object[] objectArray = new String[]{this.fParserState.getStringPool().orphanString(n2), this.fParserState.getStringPool().orphanString(n3)};
        String string2 = this.getErrorMsgString(string, objectArray);
        this.handleError(string, string2);
    }

    public final void error3(int n, int n2, int n3, int n4) throws Exception {
        String string = ErrorCode.getErrorKey(n);
        if (!this.errorHandlingEnabled() && !this.isFatal(string)) {
            this.fParserState.getStringPool().releaseString(n2);
            this.fParserState.getStringPool().releaseString(n3);
            this.fParserState.getStringPool().releaseString(n4);
            return;
        }
        Object[] objectArray = new String[]{this.fParserState.getStringPool().orphanString(n2), this.fParserState.getStringPool().orphanString(n3), this.fParserState.getStringPool().orphanString(n4)};
        String string2 = this.getErrorMsgString(string, objectArray);
        this.handleError(string, string2);
    }

    public final void error4(int n, int n2, int n3, int n4, int n5) throws Exception {
        String string = ErrorCode.getErrorKey(n);
        if (!(this.errorHandlingEnabled() || !this.getContinueAfterFatalError() && this.isFatal(string))) {
            this.fParserState.getStringPool().releaseString(n2);
            this.fParserState.getStringPool().releaseString(n3);
            this.fParserState.getStringPool().releaseString(n4);
            this.fParserState.getStringPool().releaseString(n5);
            return;
        }
        Object[] objectArray = new String[]{this.fParserState.getStringPool().orphanString(n2), this.fParserState.getStringPool().orphanString(n3), this.fParserState.getStringPool().orphanString(n4), this.fParserState.getStringPool().orphanString(n5)};
        String string2 = this.getErrorMsgString(string, objectArray);
        this.handleError(string, string2);
    }

    public abstract void doctypeDecl(int var1) throws Exception;

    public abstract void startInternalSubset() throws Exception;

    public abstract void endInternalSubset() throws Exception;

    public abstract void startExternalSubset(int var1, int var2) throws Exception;

    public abstract void endExternalSubset() throws Exception;

    public abstract void elementDecl(int var1) throws Exception;

    public abstract void attlistDecl(int var1, int var2) throws Exception;

    public abstract void internalEntityDecl(int var1) throws Exception;

    public abstract void externalEntityDecl(int var1) throws Exception;

    public abstract void unparsedEntityDecl(int var1) throws Exception;

    public abstract void parameterEntityDecl(int var1) throws Exception;

    public abstract void notationDecl(int var1) throws Exception;

    public abstract void startDocument(int var1, int var2, int var3) throws Exception;

    public abstract void endDocument() throws Exception;

    public abstract void startElement(int var1, int var2) throws Exception;

    public abstract void endElement(int var1) throws Exception;

    public abstract void startEntityReference(int var1) throws Exception;

    public abstract void endEntityReference(int var1) throws Exception;

    public abstract void characters(int var1, boolean var2) throws Exception;

    public abstract void ignorableWhitespace(int var1, boolean var2) throws Exception;

    public abstract void processingInstruction(int var1, int var2) throws Exception;

    public abstract void comment(int var1) throws Exception;

    public abstract void characters(char[] var1, int var2, int var3, boolean var4) throws Exception;

    public abstract void ignorableWhitespace(char[] var1, int var2, int var3, boolean var4) throws Exception;
}

