/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.internal;

import com.ibm.xml.framework.ChunkyCharArray;
import com.ibm.xml.framework.ParserState;
import com.ibm.xml.framework.ScanContentState;
import com.ibm.xml.framework.StringPool;
import com.ibm.xml.framework.StringProducer;
import com.ibm.xml.framework.XMLDocumentHandler;
import com.ibm.xml.framework.XMLErrorHandler;
import com.ibm.xml.framework.XMLReader;
import com.ibm.xml.framework.XMLScanner;
import com.ibm.xml.internal.StringHasher;
import java.io.Reader;

final class CharReader
extends XMLReader {
    protected static final int CHUNK_SHIFT = 14;
    protected static final int CHUNK_SIZE = 16384;
    protected static final int CHUNK_MASK = 16383;
    protected XMLScanner fScanner;
    protected XMLDocumentHandler fDocumentHandler;
    protected XMLErrorHandler fErrorHandler;
    protected StringPool fStringPool;
    protected Reader fReader;
    protected CharDataChunk fCurrentChunk;
    protected int fCurrentIndex;
    protected char[] fMostRecentData;
    protected int fMostRecentChar;
    protected int fLength;
    protected boolean fCheckOverflow = false;
    protected char[] fOverflow;
    protected int fOverflowOffset;
    protected int fOverflowEnd;
    protected int fOutputOffset;
    protected boolean fSkipLinefeed = false;

    CharReader(ParserState parserState, String string, String string2, Reader reader) throws Exception {
        super(parserState, string, string2);
        this.fReader = reader;
        this.fScanner = parserState.getScanner();
        this.fStringPool = parserState.cacheStringPool();
        this.fDocumentHandler = parserState.getDocumentHandler();
        this.fErrorHandler = parserState.getErrorHandler();
        this.fCurrentChunk = new CharDataChunk(this.fStringPool, null);
        this.fillCurrentChunk();
    }

    public int addString(int n, int n2) {
        if (n2 == 0) {
            return 0;
        }
        return this.fCurrentChunk.addString(n, n2);
    }

    public int addSymbol(int n, int n2) {
        if (n2 == 0) {
            return 0;
        }
        return this.fCurrentChunk.addSymbol(n, n2, 0);
    }

    protected int addSymbol(int n, int n2, int n3) {
        if (n2 == 0) {
            return 0;
        }
        return this.fCurrentChunk.addSymbol(n, n2, n3);
    }

    public void append(ChunkyCharArray chunkyCharArray, int n, int n2) {
        this.fCurrentChunk.append(chunkyCharArray, n, n2);
    }

    protected int slowLoadNextChar() throws Exception {
        if (this.fCurrentChunk.nextChunk() != null) {
            this.fCurrentChunk = this.fCurrentChunk.nextChunk();
            this.fCurrentIndex = 0;
            this.fMostRecentData = this.fCurrentChunk.toCharArray();
            this.fMostRecentChar = this.fMostRecentData[this.fCurrentIndex] & 0xFFFF;
            return this.fMostRecentChar;
        }
        this.fCurrentChunk = new CharDataChunk(this.fStringPool, this.fCurrentChunk);
        return this.fillCurrentChunk();
    }

    protected int loadNextChar() throws Exception {
        ++this.fCurrentOffset;
        if (++this.fCurrentIndex == 16384) {
            return this.slowLoadNextChar();
        }
        this.fMostRecentChar = this.fMostRecentData[this.fCurrentIndex] & 0xFFFF;
        return this.fMostRecentChar;
    }

    protected void checkEOF(int n) {
        if (n > this.fLength) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public int skipOneChar() throws Exception {
        int n = this.fMostRecentChar;
        if (n == 0) {
            this.checkEOF(this.fCurrentOffset + 1);
            ++this.fCharacterCounter;
        } else if (n == 10) {
            ++this.fLinefeedCounter;
            this.fCharacterCounter = 1;
        } else if (n >= 55296 && n < 56320) {
            ++this.fCharacterCounter;
            n = this.loadNextChar();
            if (n < 56320 || n >= 57344) {
                return this.fCurrentOffset;
            }
        } else {
            ++this.fCharacterCounter;
        }
        this.loadNextChar();
        return this.fCurrentOffset;
    }

    public int skipAsciiChar() throws Exception {
        ++this.fCharacterCounter;
        this.loadNextChar();
        return this.fCurrentOffset;
    }

    public int skipToChar(char c) throws Exception {
        int n = this.fMostRecentChar;
        while (n != c) {
            if (n == 0) {
                this.checkEOF(this.fCurrentOffset + 1);
                ++this.fCharacterCounter;
            } else if (n == 10) {
                ++this.fLinefeedCounter;
                this.fCharacterCounter = 1;
            } else if (n >= 55296 && n < 56320) {
                ++this.fCharacterCounter;
                n = this.loadNextChar();
                if (n < 56320 || n >= 57344) {
                    continue;
                }
            } else {
                ++this.fCharacterCounter;
            }
            n = this.loadNextChar();
        }
        return this.fCurrentOffset;
    }

    public int skipPastChar(char c) throws Exception {
        int n = this.fMostRecentChar;
        while (true) {
            if (n == c) {
                ++this.fCharacterCounter;
                this.loadNextChar();
                return this.fCurrentOffset;
            }
            if (n == 0) {
                this.checkEOF(this.fCurrentOffset + 1);
                ++this.fCharacterCounter;
            } else if (n == 10) {
                ++this.fLinefeedCounter;
                this.fCharacterCounter = 1;
            } else if (n >= 55296 && n < 56320) {
                ++this.fCharacterCounter;
                n = this.loadNextChar();
                if (n < 56320 || n >= 57344) {
                    continue;
                }
            } else {
                ++this.fCharacterCounter;
            }
            n = this.loadNextChar();
        }
    }

    public boolean skippedValidChar() throws Exception {
        int n = this.fMostRecentChar;
        if (n < 55296) {
            if (n >= 32 || n == 9) {
                ++this.fCharacterCounter;
                this.loadNextChar();
                return true;
            }
            if (n == 10) {
                ++this.fLinefeedCounter;
                this.fCharacterCounter = 1;
                this.loadNextChar();
                return true;
            }
            if (n == 0) {
                this.checkEOF(this.fCurrentOffset + 1);
            }
            return false;
        }
        if (n > 65533) {
            return false;
        }
        if (n < 56320 ? (n = this.loadNextChar()) < 56320 || n >= 57344 : n < 57344) {
            return false;
        }
        ++this.fCharacterCounter;
        this.loadNextChar();
        return true;
    }

    public boolean lookingAtValidChar() throws Exception {
        int n = this.fMostRecentChar;
        if (n < 32) {
            if (n == 0) {
                this.checkEOF(this.fCurrentOffset + 1);
            }
            return n == 9 || n == 10;
        }
        return n <= 65533;
    }

    public int skipInvalidChar(int n) throws Exception {
        int n2 = this.fMostRecentChar;
        if (n2 == 10) {
            ++this.fLinefeedCounter;
            this.fCharacterCounter = 1;
            this.loadNextChar();
        } else {
            ++this.fCharacterCounter;
            if (n2 >= 55296 && n2 < 56320) {
                int n3 = this.loadNextChar();
                if (n3 >= 56320 && n3 < 57344) {
                    n2 = (n2 - 55296 << 10) + (n3 - 56320) + 65536;
                    this.loadNextChar();
                }
            } else {
                this.loadNextChar();
            }
        }
        switch (n) {
            case 63: 
            case 85: {
                String string = Integer.toHexString(n2);
                this.fErrorHandler.error1(n, this.fStringPool.addString(string));
                break;
            }
            case 80: 
            case 82: 
            case 110: {
                String string = n2 < 65536 ? new Character((char)n2).toString() : Integer.toHexString(n2);
                this.fErrorHandler.error1(n, this.fStringPool.addString(string));
                break;
            }
            case 43: {
                String string = n2 < 65536 ? new Character((char)n2).toString() : Integer.toHexString(n2);
                String string2 = Integer.toHexString(n2);
                this.fErrorHandler.error2(n, this.fStringPool.addString(string), this.fStringPool.addString(string2));
                break;
            }
        }
        return this.fCurrentOffset;
    }

    public boolean skippedChar(char c) throws Exception {
        int n = this.fMostRecentChar;
        if (n != c) {
            return false;
        }
        ++this.fCharacterCounter;
        ++this.fCurrentOffset;
        if (++this.fCurrentIndex == 16384) {
            this.slowLoadNextChar();
        } else {
            this.fMostRecentChar = this.fMostRecentData[this.fCurrentIndex] & 0xFFFF;
        }
        return true;
    }

    public boolean lookingAtChar(char c) throws Exception {
        int n = this.fMostRecentChar;
        return n == c;
    }

    public boolean skippedSpace() throws Exception {
        int n = this.fMostRecentChar;
        if (n > 32) {
            return false;
        }
        if (n == 32 || n == 9) {
            ++this.fCharacterCounter;
        } else if (n == 10) {
            ++this.fLinefeedCounter;
            this.fCharacterCounter = 1;
        } else {
            return false;
        }
        ++this.fCurrentOffset;
        if (++this.fCurrentIndex == 16384) {
            this.slowLoadNextChar();
        } else {
            this.fMostRecentChar = this.fMostRecentData[this.fCurrentIndex] & 0xFFFF;
        }
        return true;
    }

    public boolean lookingAtSpace() {
        int n = this.fMostRecentChar;
        return n == 32 || n == 9 || n == 10;
    }

    public int skipPastSpaces() throws Exception {
        int n = this.fMostRecentChar;
        while (true) {
            if (n == 32 || n == 9) {
                ++this.fCharacterCounter;
            } else if (n == 10) {
                ++this.fLinefeedCounter;
                this.fCharacterCounter = 1;
            } else {
                return this.fCurrentOffset;
            }
            n = this.loadNextChar();
        }
    }

    public int skipDecimalDigit() throws Exception {
        int n = this.fMostRecentChar;
        if (n < 48 || n > 57) {
            return -1;
        }
        ++this.fCharacterCounter;
        this.loadNextChar();
        return n - 48;
    }

    public int skipHexDigit() throws Exception {
        int n = this.fMostRecentChar;
        if (n > 102 || XMLReader.fgAsciiXDigitChar[n] == 0) {
            return -1;
        }
        ++this.fCharacterCounter;
        this.loadNextChar();
        return n - (n < 65 ? 48 : (n < 97 ? 65 : 97) - 10);
    }

    public boolean skippedAlpha() throws Exception {
        int n = this.fMostRecentChar;
        if (n > 122 || XMLReader.fgAsciiAlphaChar[n] == 0) {
            return false;
        }
        ++this.fCharacterCounter;
        this.loadNextChar();
        return true;
    }

    protected boolean skippedAsciiCharWithFlag(byte by) throws Exception {
        int n = this.fMostRecentChar;
        if (n >= 128 || (XMLReader.fgCharFlags[n] & by) == 0) {
            return false;
        }
        ++this.fCharacterCounter;
        this.loadNextChar();
        return true;
    }

    public boolean skippedVersionNum() throws Exception {
        return this.skippedAsciiCharWithFlag((byte)1);
    }

    public boolean skippedEncName() throws Exception {
        return this.skippedAsciiCharWithFlag((byte)2);
    }

    public boolean skippedPubidChar() throws Exception {
        int n = this.fMostRecentChar;
        if (n >= 128) {
            return false;
        }
        if ((XMLReader.fgCharFlags[n] & 4) != 0) {
            ++this.fCharacterCounter;
            this.loadNextChar();
            return true;
        }
        if (n == 10) {
            ++this.fLinefeedCounter;
            this.fCharacterCounter = 1;
            this.loadNextChar();
            return true;
        }
        return false;
    }

    public boolean skippedString(char[] cArray) throws Exception {
        int n = cArray.length;
        char[] cArray2 = this.fMostRecentData;
        int n2 = this.fCurrentIndex;
        if (n2 + n <= 16384) {
            int n3 = 0;
            while (n3 < n) {
                if (cArray2[n2++] != cArray[n3]) {
                    return false;
                }
                ++n3;
            }
            this.fCharacterCounter += n;
            this.fCurrentOffset += n;
            this.fCurrentIndex = n2;
            if (n2 == 16384) {
                this.slowLoadNextChar();
            } else {
                this.fMostRecentChar = cArray2[n2] & 0xFFFF;
            }
            return true;
        }
        CharDataChunk charDataChunk = this.fCurrentChunk;
        int n4 = this.fCurrentOffset;
        int n5 = n2;
        int n6 = 0;
        while (n2 < 16384) {
            if (cArray2[n2++] == cArray[n6++]) continue;
            return false;
        }
        this.slowLoadNextChar();
        cArray2 = this.fMostRecentData;
        n2 = 0;
        while (n6 < n) {
            if (cArray2[n2++] == cArray[n6++]) continue;
            this.fCurrentChunk = charDataChunk;
            this.fCurrentIndex = n5;
            this.fCurrentOffset = n4;
            this.fMostRecentData = charDataChunk.toCharArray();
            this.fMostRecentChar = this.fMostRecentData[n5] & 0xFFFF;
            return false;
        }
        this.fCharacterCounter += n;
        this.fCurrentOffset += n;
        this.fCurrentIndex = n2;
        if (n2 == 16384) {
            this.slowLoadNextChar();
        } else {
            this.fMostRecentChar = cArray2[n2] & 0xFFFF;
        }
        return true;
    }

    public int scanName(char c, int n) throws Exception {
        int n2 = this.fMostRecentChar;
        if (n2 < 128 ? XMLReader.fgAsciiInitialNameChar[n2] == 0 : (XMLReader.fgCharFlags[n2] & 0x10) == 0) {
            return -1;
        }
        int n3 = this.fCurrentOffset;
        int n4 = this.fCurrentIndex;
        char[] cArray = this.fMostRecentData;
        if (++n4 == 16384) {
            this.fCurrentChunk = new CharDataChunk(this.fStringPool, this.fCurrentChunk);
            this.fillCurrentChunk();
            n4 = 0;
            cArray = this.fMostRecentData;
        }
        ++this.fCharacterCounter;
        ++this.fCurrentOffset;
        int n5 = 0;
        int n6 = 0;
        while (true) {
            n5 = StringHasher.hashChar(n5, n6++, n2);
            n2 = cArray[n4] & 0xFFFF;
            if (c == n2 || (n2 >= 128 ? (XMLReader.fgCharFlags[n2] & 0x20) == 0 : XMLReader.fgAsciiNameChar[n2] == 0)) break;
            if (++n4 == 16384) {
                this.fCurrentChunk = new CharDataChunk(this.fStringPool, this.fCurrentChunk);
                this.fillCurrentChunk();
                n4 = 0;
                cArray = this.fMostRecentData;
            }
            ++this.fCharacterCounter;
            ++this.fCurrentOffset;
        }
        this.fCurrentIndex = n4;
        this.fMostRecentChar = n2;
        n5 = StringHasher.finishHash(n5);
        int n7 = this.fCurrentOffset - n3;
        int n8 = this.addSymbol(n3, n7, n5);
        if (n == -1 || n == n8) {
            return n8;
        }
        return -1;
    }

    public int skipPastName(char c) throws Exception {
        int n = this.fMostRecentChar;
        if (n < 128 ? XMLReader.fgAsciiInitialNameChar[n] == 0 : (XMLReader.fgCharFlags[n] & 0x10) == 0) {
            return this.fCurrentOffset;
        }
        do {
            ++this.fCharacterCounter;
            n = this.loadNextChar();
            if (c != n) continue;
            return this.fCurrentOffset;
        } while (!(n < 128 ? XMLReader.fgAsciiNameChar[n] == 0 : (XMLReader.fgCharFlags[n] & 0x20) == 0));
        return this.fCurrentOffset;
    }

    public int skipPastNmtoken(char c) throws Exception {
        int n = this.fMostRecentChar;
        while (c != n) {
            if (n < 128 ? XMLReader.fgAsciiNameChar[n] == 0 : (XMLReader.fgCharFlags[n] & 0x20) == 0) {
                return this.fCurrentOffset;
            }
            ++this.fCharacterCounter;
            n = this.loadNextChar();
        }
        return this.fCurrentOffset;
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    public int scanContent(ScanContentState var1_1) throws Exception {
        block60: {
            this.fCurrentChunk.clearPreviousChunk();
            var2_2 = this.fCurrentOffset++;
            var3_3 = this.fMostRecentChar;
            if (var3_3 >= 128) ** GOTO lbl63
            switch (XMLReader.fgAsciiWSCharData[var3_3]) {
                case 0: {
                    ++this.fCharacterCounter;
                    if (++this.fCurrentIndex == 16384) {
                        this.slowLoadNextChar();
                        ** break;
                    }
                    this.fMostRecentChar = this.fMostRecentData[this.fCurrentIndex] & 65535;
                    ** break;
                }
                case 1: {
                    ++this.fCharacterCounter;
                    ++this.fCurrentOffset;
                    if (++this.fCurrentIndex == 16384) {
                        this.slowLoadNextChar();
                    } else {
                        this.fMostRecentChar = this.fMostRecentData[this.fCurrentIndex] & 65535;
                    }
                    if (var1_1.inCDSect) ** break;
                    return 1;
                }
                case 2: {
                    ++this.fCharacterCounter;
                    ++this.fCurrentOffset;
                    if (++this.fCurrentIndex == 16384) {
                        this.slowLoadNextChar();
                    } else {
                        this.fMostRecentChar = this.fMostRecentData[this.fCurrentIndex] & 65535;
                    }
                    if (var1_1.inCDSect) ** break;
                    return 2;
                }
                case 3: {
                    ++this.fCharacterCounter;
                    var3_3 = this.loadNextChar();
                    if (var3_3 != 93) ** break;
                    if (this.fCurrentIndex + 1 == 16384) {
                        var4_4 = this.fCurrentChunk;
                        var5_7 = this.fCurrentIndex;
                        var6_10 = this.fCurrentOffset;
                        if (this.loadNextChar() != 62) {
                            this.fCurrentChunk = var4_4;
                            this.fCurrentIndex = var5_7;
                            this.fCurrentOffset = var6_10;
                            this.fMostRecentData = var4_4.toCharArray();
                            this.fMostRecentChar = 93;
                            ** break;
                        }
                    } else {
                        if (this.fMostRecentData[this.fCurrentIndex + 1] != '>') ** break;
                        ++this.fCurrentIndex;
                        ++this.fCurrentOffset;
                    }
                    this.loadNextChar();
                    this.fCharacterCounter += 2;
                    if (var1_1.inCDSect == false) return 3;
                    var1_1.inCDSect = false;
                    return this.scanContent(var1_1);
                }
                case 4: {
                    return 4;
                }
                case 5: {
                    break;
                }
lbl63:
                // 1 sources

                if (this.skipMultiByteCharData(var3_3)) ** break;
                return 4;
                default: {
                    break block60;
                }
            }
            do {
                if (var3_3 == 10) {
                    ++this.fLinefeedCounter;
                    this.fCharacterCounter = 1;
                } else {
                    ++this.fCharacterCounter;
                }
                ++this.fCurrentOffset;
            } while ((var3_3 = ++this.fCurrentIndex == 16384 ? this.slowLoadNextChar() : (this.fMostRecentChar = this.fMostRecentData[this.fCurrentIndex] & 65535)) == 32 || var3_3 == 9 || var3_3 == 10);
            if (var3_3 >= 128) ** GOTO lbl149
            switch (XMLReader.fgAsciiCharData[var3_3]) {
                case 0: {
                    ++this.fCharacterCounter;
                    ++this.fCurrentOffset;
                    if (++this.fCurrentIndex == 16384) {
                        this.slowLoadNextChar();
                        break;
                    }
                    this.fMostRecentChar = this.fMostRecentData[this.fCurrentIndex] & 65535;
                    break;
                }
                case 1: {
                    if (!var1_1.inCDSect) {
                        if (this.fDocumentHandler != null) {
                            this.callWSCharDataHandler(var2_2, this.fCurrentOffset, false);
                        }
                        ++this.fCharacterCounter;
                        this.loadNextChar();
                        return 25;
                    }
                    ++this.fCharacterCounter;
                    ++this.fCurrentOffset;
                    if (++this.fCurrentIndex == 16384) {
                        this.slowLoadNextChar();
                        break;
                    }
                    this.fMostRecentChar = this.fMostRecentData[this.fCurrentIndex] & 65535;
                    break;
                }
                case 2: {
                    if (!var1_1.inCDSect) {
                        if (this.fDocumentHandler != null) {
                            this.callWSCharDataHandler(var2_2, this.fCurrentOffset, false);
                        }
                        ++this.fCharacterCounter;
                        this.loadNextChar();
                        return 26;
                    }
                    ++this.fCharacterCounter;
                    this.loadNextChar();
                    break;
                }
                case 3: {
                    var4_5 = this.fCurrentOffset++;
                    var3_3 = this.loadNextChar();
                    if (var3_3 != 93) {
                        ++this.fCharacterCounter;
                        break;
                    }
                    if (this.fCurrentIndex + 1 == 16384) {
                        var5_8 = this.fCurrentChunk;
                        var6_10 = this.fCurrentIndex;
                        var7_11 = this.fCurrentOffset;
                        if (this.loadNextChar() != 62) {
                            this.fCurrentChunk = var5_8;
                            this.fCurrentIndex = var6_10;
                            this.fCurrentOffset = var7_11;
                            this.fMostRecentData = var5_8.toCharArray();
                            this.fMostRecentChar = 93;
                            ++this.fCharacterCounter;
                            break;
                        }
                    } else {
                        if (this.fMostRecentData[this.fCurrentIndex + 1] != '>') {
                            ++this.fCharacterCounter;
                            break;
                        }
                        ++this.fCurrentIndex;
                    }
                    this.loadNextChar();
                    if (this.fDocumentHandler != null) {
                        this.callWSCharDataHandler(var2_2, var4_5, var1_1.inCDSect);
                    }
                    this.fCharacterCounter += 3;
                    if (var1_1.inCDSect == false) return 27;
                    var1_1.inCDSect = false;
                    return this.scanContent(var1_1);
                }
                case 4: {
                    if (this.fDocumentHandler == null) return 28;
                    this.callWSCharDataHandler(var2_2, this.fCurrentOffset, var1_1.inCDSect);
                    return 28;
                }
lbl149:
                // 1 sources

                if (this.skipMultiByteCharData(var3_3)) break;
                if (this.fDocumentHandler == null) return 28;
                this.callWSCharDataHandler(var2_2, this.fCurrentOffset, var1_1.inCDSect);
                return 28;
            }
        }
        var3_3 = this.skipAsciiCharData();
        while (true) {
            if (var3_3 < 128) {
                switch (XMLReader.fgAsciiCharData[var3_3]) {
                    case 0: {
                        ++this.fCharacterCounter;
                        var3_3 = this.loadNextChar();
                        break;
                    }
                    case 1: {
                        if (!var1_1.inCDSect) {
                            if (this.fDocumentHandler != null) {
                                this.callCharDataHandler(var2_2, this.fCurrentOffset, false);
                            }
                            ++this.fCharacterCounter;
                            ++this.fCurrentOffset;
                            if (++this.fCurrentIndex == 16384) {
                                this.slowLoadNextChar();
                                return 9;
                            }
                            this.fMostRecentChar = this.fMostRecentData[this.fCurrentIndex] & 65535;
                            return 9;
                        }
                        ++this.fCharacterCounter;
                        var3_3 = this.loadNextChar();
                        break;
                    }
                    case 2: {
                        if (!var1_1.inCDSect) {
                            if (this.fDocumentHandler != null) {
                                this.callCharDataHandler(var2_2, this.fCurrentOffset, false);
                            }
                            ++this.fCharacterCounter;
                            this.loadNextChar();
                            return 10;
                        }
                        ++this.fCharacterCounter;
                        var3_3 = this.loadNextChar();
                        break;
                    }
                    case 3: {
                        var4_6 = this.fCurrentOffset++;
                        var3_3 = this.loadNextChar();
                        if (var3_3 != 93) {
                            ++this.fCharacterCounter;
                            break;
                        }
                        if (this.fCurrentIndex + 1 == 16384) {
                            var5_9 = this.fCurrentChunk;
                            var6_10 = this.fCurrentIndex;
                            var7_11 = this.fCurrentOffset;
                            if (this.loadNextChar() != 62) {
                                this.fCurrentChunk = var5_9;
                                this.fCurrentIndex = var6_10;
                                this.fCurrentOffset = var7_11;
                                this.fMostRecentData = var5_9.toCharArray();
                                this.fMostRecentChar = 93;
                                ++this.fCharacterCounter;
                                break;
                            }
                        } else {
                            if (this.fMostRecentData[this.fCurrentIndex + 1] != '>') {
                                ++this.fCharacterCounter;
                                break;
                            }
                            ++this.fCurrentIndex;
                        }
                        this.loadNextChar();
                        if (this.fDocumentHandler != null) {
                            this.callCharDataHandler(var2_2, var4_6, var1_1.inCDSect);
                        }
                        this.fCharacterCounter += 3;
                        if (var1_1.inCDSect == false) return 11;
                        var1_1.inCDSect = false;
                        return this.scanContent(var1_1);
                    }
                    case 4: {
                        if (var3_3 != 10) {
                            if (this.fDocumentHandler == null) return 12;
                            this.callCharDataHandler(var2_2, this.fCurrentOffset, var1_1.inCDSect);
                            return 12;
                        }
                        ++this.fLinefeedCounter;
                        this.fCharacterCounter = 1;
                        var3_3 = this.loadNextChar();
                        break;
                    }
                }
                continue;
            }
            if (!this.skipMultiByteCharData(var3_3)) {
                if (this.fDocumentHandler == null) return 12;
                this.callCharDataHandler(var2_2, this.fCurrentOffset, var1_1.inCDSect);
                return 12;
            }
            var3_3 = this.fMostRecentChar;
        }
    }

    protected boolean skipMultiByteCharData(int n) throws Exception {
        if (n > 65533) {
            return false;
        }
        if (n >= 901120 && n < 57344) {
            return false;
        }
        if (n >= 884736 && n < 56320 && ((n = this.loadNextChar()) < 901120 || n >= 57344)) {
            return false;
        }
        this.loadNextChar();
        return true;
    }

    protected int skipAsciiCharData() throws Exception {
        int n = this.fCurrentIndex;
        int n2 = this.fCurrentOffset - n;
        while (true) {
            char[] cArray = this.fMostRecentData;
            while (n < 16384) {
                int n3 = cArray[n] & 0xFFFF;
                if (n3 >= 128) {
                    this.fCurrentOffset = n2 + n;
                    this.fCurrentIndex = n;
                    this.fMostRecentChar = n3;
                    return n3;
                }
                if (XMLReader.fgAsciiCharData[n3] != 0) {
                    if (n3 != 10) {
                        this.fCurrentOffset = n2 + n;
                        this.fCurrentIndex = n;
                        this.fMostRecentChar = n3;
                        return n3;
                    }
                    ++this.fLinefeedCounter;
                    this.fCharacterCounter = 1;
                } else {
                    ++this.fCharacterCounter;
                }
                ++n;
            }
            n2 += n;
            this.fCurrentChunk = new CharDataChunk(this.fStringPool, this.fCurrentChunk);
            this.fillCurrentChunk();
            n = 0;
        }
    }

    public void callCharDataHandler(int n, int n2, boolean bl) throws Exception {
        int n3 = n2 - n;
        if (!this.fDocumentHandler.sendCharDataAsCharArray()) {
            int n4 = this.addString(n, n3);
            this.fDocumentHandler.characters(n4, bl);
            return;
        }
        CharDataChunk charDataChunk = this.fCurrentChunk.chunkFor(n);
        int n5 = n & 0x3FFF;
        if (n5 + n3 <= 16384) {
            if (n3 != 0) {
                this.fDocumentHandler.characters(charDataChunk.toCharArray(), n5, n3, bl);
            }
            return;
        }
        int n6 = n3;
        int n7 = 16384 - n5;
        this.fDocumentHandler.characters(charDataChunk.toCharArray(), n5, n7, bl);
        n6 -= n7;
        do {
            if ((charDataChunk = charDataChunk.nextChunk()) == null) {
                this.fErrorHandler.error(167);
            }
            n7 = n6 <= 16384 ? n6 : 16384;
            this.fDocumentHandler.characters(charDataChunk.toCharArray(), 0, n7, bl);
        } while ((n6 -= n7) > 0);
    }

    public void callWSCharDataHandler(int n, int n2, boolean bl) throws Exception {
        int n3 = this.fScanner.getCurrentContentSpecType();
        if (n3 != 4) {
            this.callCharDataHandler(n, n2, bl);
            return;
        }
        int n4 = n2 - n;
        if (!this.fDocumentHandler.sendCharDataAsCharArray()) {
            int n5 = this.addString(n, n4);
            this.fDocumentHandler.ignorableWhitespace(n5, bl);
            return;
        }
        CharDataChunk charDataChunk = this.fCurrentChunk.chunkFor(n);
        int n6 = n & 0x3FFF;
        if (n6 + n4 <= 16384) {
            if (n4 != 0) {
                this.fDocumentHandler.ignorableWhitespace(charDataChunk.toCharArray(), n6, n4, bl);
            }
            return;
        }
        int n7 = n4;
        int n8 = 16384 - n6;
        this.fDocumentHandler.ignorableWhitespace(charDataChunk.toCharArray(), n6, n8, bl);
        n7 -= n8;
        do {
            charDataChunk = charDataChunk.nextChunk();
            n8 = n7 <= 16384 ? n7 : 16384;
            this.fDocumentHandler.ignorableWhitespace(charDataChunk.toCharArray(), 0, n8, bl);
        } while ((n7 -= n8) > 0);
    }

    /*
     * Unable to fully structure code
     */
    protected int fillCurrentChunk() throws Exception {
        this.fOutputOffset = 0;
        if (this.fCheckOverflow) {
            if (this.fOverflowEnd < 16384) {
                if (this.fOverflowEnd > 0) {
                    this.fMostRecentData = new char[1 + this.fOverflowEnd - this.fOverflowOffset];
                    this.copyNormalize(this.fOverflow, this.fOverflowOffset, this.fMostRecentData, this.fOutputOffset);
                } else {
                    this.fMostRecentData = new char[1];
                }
                this.fMostRecentData[this.fOutputOffset] = '\u0000';
                this.fOverflow = null;
                this.fLength += this.fOutputOffset;
                this.fCurrentIndex = 0;
                this.fCurrentChunk.setCharArray(this.fMostRecentData);
                this.fMostRecentChar = this.fMostRecentData[0];
                return this.fMostRecentChar;
            }
            this.fMostRecentData = new char[16384];
            this.copyNormalize(this.fOverflow, this.fOverflowOffset, this.fMostRecentData, this.fOutputOffset);
            this.fCheckOverflow = false;
        } else {
            if (this.fOverflow == null) {
                this.fOverflow = new char[16384];
            }
            this.fMostRecentData = null;
        }
        do lbl-1000:
        // 3 sources

        {
            block12: {
                this.fOverflowOffset = 0;
                this.fOverflowEnd = 0;
                var1_1 = 16384;
                var2_2 = 0;
                do {
                    if ((var2_2 = this.fReader.read(this.fOverflow, this.fOverflowEnd, var1_1)) == -1) {
                        this.fReader.close();
                        this.fReader = null;
                        if (this.fMostRecentData == null) {
                            this.fMostRecentData = new char[1 + this.fOverflowEnd];
                            this.copyNormalize(this.fOverflow, this.fOverflowOffset, this.fMostRecentData, this.fOutputOffset);
                            this.fOverflow = null;
                            this.fMostRecentData[this.fOutputOffset] = '\u0000';
                            break;
                        }
                        var3_3 = this.copyNormalize(this.fOverflow, this.fOverflowOffset, this.fMostRecentData, this.fOutputOffset);
                        if (var3_3) {
                            if (this.fOverflowEnd == 16384) {
                                this.fCheckOverflow = true;
                                this.fOverflowOffset = 0;
                                this.fOverflowEnd = 0;
                                break;
                            }
                            this.fOverflow = null;
                            this.fMostRecentData[this.fOutputOffset] = '\u0000';
                            break;
                        }
                        this.fCheckOverflow = true;
                        break;
                    }
                    if (var2_2 <= 0) continue;
                    this.fOverflowEnd += var2_2;
                    var1_1 -= var2_2;
                } while (var1_1 > 0);
                if (var2_2 == -1) break;
                if (this.fMostRecentData == null) break block12;
                var3_3 = this.copyNormalize(this.fOverflow, this.fOverflowOffset, this.fMostRecentData, this.fOutputOffset);
                if (this.fOutputOffset != 16384) ** GOTO lbl-1000
                if (var3_3) break;
                this.fCheckOverflow = true;
                break;
            }
            this.fMostRecentData = new char[16384];
            this.copyNormalize(this.fOverflow, this.fOverflowOffset, this.fMostRecentData, this.fOutputOffset);
        } while (this.fOutputOffset != 16384);
        this.fLength += this.fOutputOffset;
        this.fCurrentIndex = 0;
        this.fCurrentChunk.setCharArray(this.fMostRecentData);
        this.fMostRecentChar = this.fMostRecentData[0];
        return this.fMostRecentChar;
    }

    protected boolean copyNormalize(char[] cArray, int n, char[] cArray2, int n2) throws Exception {
        int n3 = this.fOverflowEnd;
        int n4 = cArray2.length;
        if (n == n3) {
            return true;
        }
        char c = cArray[n];
        if (this.fSkipLinefeed) {
            this.fSkipLinefeed = false;
            if (c == '\n') {
                if (++n == n3) {
                    return this.exitNormalize(n, n2, true);
                }
                c = cArray[n];
            }
        }
        while (n2 < n4) {
            int n5 = n3 - n;
            int n6 = n4 - n2;
            if (n5 > n6) {
                n5 = n6;
            }
            ++n;
            while (true) {
                if (c == '\r') {
                    cArray2[n2++] = 10;
                    if (n == n3) {
                        this.fSkipLinefeed = true;
                        return this.exitNormalize(n, n2, true);
                    }
                    c = cArray[n];
                    if (c == '\n') {
                        if (++n == n3) {
                            return this.exitNormalize(n, n2, true);
                        }
                        c = cArray[n];
                    }
                    if (n2 == n4) {
                        return this.exitNormalize(n, n2, false);
                    }
                    n5 = n3 - n;
                    n6 = n4 - n2;
                    if (n5 > n6) {
                        n5 = n6;
                    }
                    ++n;
                    continue;
                }
                do {
                    cArray2[n2++] = c;
                } while (--n5 != 0 && (c = cArray[n++]) != '\r');
                if (n5 == 0) break;
            }
            if (n == n3) break;
        }
        return this.exitNormalize(n, n2, n == n3);
    }

    protected boolean exitNormalize(int n, int n2, boolean bl) {
        this.fOverflowOffset = n;
        this.fOutputOffset = n2;
        return bl;
    }

    protected final class CharDataChunk
    implements StringProducer {
        protected StringPool fInnerStringPool;
        protected int fChunk;
        protected char[] fData;
        protected CharDataChunk fPreviousChunk;
        protected CharDataChunk fNextChunk;

        public CharDataChunk(StringPool stringPool, CharDataChunk charDataChunk) throws Exception {
            CharReader.this = CharReader.this;
            this.fInnerStringPool = stringPool;
            this.fChunk = charDataChunk == null ? 0 : charDataChunk.fChunk + 1;
            this.fPreviousChunk = charDataChunk;
            if (charDataChunk != null) {
                charDataChunk.fNextChunk = this;
            }
        }

        protected CharDataChunk(CharDataChunk charDataChunk) {
            CharReader.this = CharReader.this;
            this.fInnerStringPool = charDataChunk.fInnerStringPool;
            this.fChunk = charDataChunk.fChunk;
            this.fData = charDataChunk.fData;
            this.fPreviousChunk = null;
            this.fNextChunk = null;
        }

        public CharDataChunk chunkFor(int n) {
            int n2 = n >> 14;
            CharDataChunk charDataChunk = this;
            while (n2 != charDataChunk.fChunk) {
                charDataChunk = charDataChunk.fPreviousChunk;
            }
            return charDataChunk;
        }

        public char[] toCharArray() {
            return this.fData;
        }

        public void setCharArray(char[] cArray) {
            this.fData = cArray;
        }

        public CharDataChunk nextChunk() {
            return this.fNextChunk;
        }

        public void clearPreviousChunk() {
            if (this.fPreviousChunk != null) {
                this.fPreviousChunk.fNextChunk = null;
                this.fPreviousChunk = null;
            }
        }

        public String toString(int n, int n2) {
            if (n + n2 <= 16384) {
                return new String(this.fData, n, n2);
            }
            StringBuffer stringBuffer = new StringBuffer(n2);
            int n3 = 16384 - n;
            stringBuffer.append(this.fData, n, n3);
            n2 -= n3;
            CharDataChunk charDataChunk = this.fNextChunk;
            do {
                n3 = n2 <= 16384 ? n2 : 16384;
                stringBuffer.append(charDataChunk.fData, 0, n3);
                charDataChunk = charDataChunk.fNextChunk;
            } while ((n2 -= n3) > 0);
            String string = stringBuffer.toString();
            stringBuffer = null;
            return string;
        }

        public boolean equalsString(int n, int n2, String string, int n3) {
            if (n2 != n3) {
                return false;
            }
            if (n + n2 <= 16384) {
                int n4 = 0;
                while (n4 < n2) {
                    if (this.fData[n++] != string.charAt(n4)) {
                        return false;
                    }
                    ++n4;
                }
                return true;
            }
            int n5 = 16384 - n;
            int n6 = 0;
            while (n6 < n5) {
                if (this.fData[n++] == string.charAt(n6++)) continue;
                return false;
            }
            n2 -= n5;
            CharDataChunk charDataChunk = this.fNextChunk;
            do {
                n = 0;
                n5 = n2 <= 16384 ? n2 : 16384;
                n2 -= n5;
                while (n5-- > 0) {
                    if (charDataChunk.fData[n++] == string.charAt(n6++)) continue;
                    return false;
                }
                charDataChunk = charDataChunk.fNextChunk;
            } while (n2 > 0);
            return true;
        }

        protected CharDataChunk createClump(int n) {
            CharDataChunk charDataChunk = new CharDataChunk(this);
            CharDataChunk charDataChunk2 = this.fNextChunk;
            CharDataChunk charDataChunk3 = charDataChunk;
            do {
                CharDataChunk charDataChunk4;
                charDataChunk3.fNextChunk = charDataChunk4 = new CharDataChunk(charDataChunk2);
                charDataChunk2 = charDataChunk2.fNextChunk;
                charDataChunk3 = charDataChunk4;
            } while (charDataChunk3.fChunk != n);
            return charDataChunk;
        }

        public int addString(int n, int n2) {
            int n3 = n >> 14;
            if (n3 != this.fChunk) {
                if (this.fPreviousChunk != null) {
                    return this.fPreviousChunk.addString(n, n2);
                }
                try {
                    CharReader.this.fErrorHandler.error(168);
                }
                catch (Exception exception) {}
                return -1;
            }
            int n4 = n + n2 - 1 >> 14;
            if (n3 == n4) {
                return this.fInnerStringPool.addString(this, n & 0x3FFF, n2);
            }
            return this.fInnerStringPool.addString(this.createClump(n4), n & 0x3FFF, n2);
        }

        public int addSymbol(int n, int n2, int n3) {
            int n4 = n >> 14;
            if (n4 != this.fChunk) {
                if (this.fPreviousChunk != null) {
                    return this.fPreviousChunk.addSymbol(n, n2, n3);
                }
                try {
                    CharReader.this.fErrorHandler.error(168);
                }
                catch (Exception exception) {}
                return -1;
            }
            int n5 = n + n2 - 1 >> 14;
            int n6 = n & 0x3FFF;
            if (n4 == n5) {
                if (n3 == 0) {
                    int n7 = 0;
                    while (n7 < n2) {
                        n3 = StringHasher.hashChar(n3, n7, this.fData[n6++] & 0xFFFF);
                        ++n7;
                    }
                    n3 = StringHasher.finishHash(n3);
                }
                return this.fInnerStringPool.addSymbol(this, n & 0x3FFF, n2, n3);
            }
            if (n3 == 0) {
                int n8 = 0;
                int n9 = n2;
                int n10 = 16384 - n6;
                while (n6 < 16384) {
                    n3 = StringHasher.hashChar(n3, n8++, this.fData[n6++] & 0xFFFF);
                }
                n9 -= n10;
                CharDataChunk charDataChunk = this.fNextChunk;
                do {
                    n6 = 0;
                    n10 = n9 <= 16384 ? n9 : 16384;
                    while (n6 < n10) {
                        n3 = StringHasher.hashChar(n3, n8++, charDataChunk.fData[n6++] & 0xFFFF);
                    }
                    charDataChunk = charDataChunk.fNextChunk;
                } while ((n9 -= n10) > 0);
                n3 = StringHasher.finishHash(n3);
            }
            return this.fInnerStringPool.addSymbol(this.createClump(n5), n & 0x3FFF, n2, n3);
        }

        public void append(ChunkyCharArray chunkyCharArray, int n, int n2) {
            CharDataChunk charDataChunk = this.chunkFor(n);
            int n3 = n & 0x3FFF;
            int n4 = n3 + n2 <= 16384 ? n2 : 16384 - n3;
            while (true) {
                chunkyCharArray.append(charDataChunk.fData, n3, n4);
                if ((n2 -= n4) == 0) break;
                charDataChunk = charDataChunk.fNextChunk;
                n3 = 0;
                n4 = n2 <= 16384 ? n2 : 16384;
            }
        }
    }
}

