/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.parser;

import com.ibm.xml.parser.Attlist;
import com.ibm.xml.parser.Child;
import com.ibm.xml.parser.DTD;
import com.ibm.xml.parser.ElementDecl;
import com.ibm.xml.parser.EntityDecl;
import com.ibm.xml.parser.TXComment;
import com.ibm.xml.parser.TXDocument;
import com.ibm.xml.parser.TXElement;
import com.ibm.xml.parser.TXNotation;
import com.ibm.xml.parser.TXPI;
import com.ibm.xml.parser.TXText;
import com.ibm.xml.parser.ToNextSiblingTraversalException;
import com.ibm.xml.parser.ToXMLStringVisitor;
import com.ibm.xml.parser.Util;
import com.ibm.xml.parser.Visitor;
import java.io.Writer;
import java.util.Stack;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Node;

public class FormatPrintVisitor
extends ToXMLStringVisitor
implements Visitor {
    protected int currentIndent;
    protected int indent = 2;
    protected boolean ispreserve = false;
    protected Stack preserves = new Stack();
    protected boolean isprevtext = false;

    public FormatPrintVisitor(Writer writer, String string, int n) {
        super(writer, string);
        this.indent = n;
    }

    public FormatPrintVisitor(Writer writer, String string) {
        this(writer, string, 2);
    }

    public FormatPrintVisitor(Writer writer) {
        this(writer, null, 2);
    }

    public void visitDocumentPost(TXDocument tXDocument) throws Exception {
        this.writer.write(10);
        super.visitDocumentPost(tXDocument);
    }

    public void visitElementPre(TXElement tXElement) throws Exception {
        if (!this.ispreserve && !this.isprevtext) {
            Util.indent(this.writer, this.currentIndent);
        }
        super.visitElementPre(tXElement);
        this.currentIndent += this.indent;
        if (tXElement.hasChildNodes()) {
            Child child = (Child)tXElement.getFirstChild();
            this.preserves.push(new Boolean(this.ispreserve));
            this.ispreserve = tXElement.children.getLength() == 1 && child.getNodeType() == 3 ? true : tXElement.isPreserveSpace();
        }
        this.isprevtext = false;
    }

    public void visitElementPost(TXElement tXElement) throws Exception {
        this.currentIndent -= this.indent;
        if (tXElement.hasChildNodes()) {
            if (!this.ispreserve && !this.isprevtext) {
                Util.indent(this.writer, this.currentIndent);
            }
            this.writer.write("</");
            this.writer.write(tXElement.getTagName());
            this.writer.write(">");
            this.ispreserve = (Boolean)this.preserves.pop();
        }
        this.isprevtext = false;
    }

    public void visitPIPre(TXPI tXPI) throws Exception {
        if (!this.ispreserve && !this.isprevtext) {
            Util.indent(this.writer, this.currentIndent);
        }
        super.visitPIPre(tXPI);
    }

    public void visitCommentPre(TXComment tXComment) throws Exception {
        if (!this.ispreserve && !this.isprevtext) {
            Util.indent(this.writer, this.currentIndent);
        }
        super.visitCommentPre(tXComment);
    }

    public void visitTextPre(TXText tXText) throws Exception {
        if (!this.ispreserve && tXText.getIsIgnorableWhitespace()) {
            this.isprevtext = false;
            return;
        }
        if (tXText instanceof CDATASection) {
            if (!this.ispreserve && !this.isprevtext) {
                Util.indent(this.writer, this.currentIndent);
            }
            this.writer.write("<![CDATA[");
            this.writer.write(tXText.getData());
            this.writer.write("]]>");
            return;
        }
        this.writer.write(Util.backReference(tXText.getData(), this.encoding));
        this.isprevtext = true;
    }

    public void visitDTDPre(DTD dTD) throws Exception {
        Util.indent(this.writer, this.currentIndent);
        this.writer.write("<!DOCTYPE ");
        this.writer.write(dTD.getName());
        this.writer.write(" ");
        if (dTD.getExternalID() != null) {
            this.writer.write(dTD.getExternalID().toString());
            this.writer.write(" ");
        }
        this.currentIndent += this.indent;
        if (dTD.isPrintInternalDTD() && dTD.getInternalSize() > 0) {
            this.writer.write("[\n");
            Node node = dTD.getFirstChild();
            while (node != null) {
                if (node.getNodeType() != 3) {
                    try {
                        ((Child)node).acceptPre(this);
                    }
                    catch (ToNextSiblingTraversalException toNextSiblingTraversalException) {}
                }
                node = node.getNextSibling();
            }
        }
        throw new ToNextSiblingTraversalException();
    }

    public void visitDTDPost(DTD dTD) throws Exception {
        this.currentIndent -= this.indent;
        if (dTD.isPrintInternalDTD() && dTD.getInternalSize() > 0) {
            Util.printSpace(this.writer, this.currentIndent);
            this.writer.write("]");
        }
        this.writer.write(">");
    }

    public void visitElementDeclPre(ElementDecl elementDecl) throws Exception {
        Util.printSpace(this.writer, this.currentIndent);
        super.visitElementDeclPre(elementDecl);
        this.writer.write(10);
    }

    public void visitAttlistPre(Attlist attlist) throws Exception {
        Util.printSpace(this.writer, this.currentIndent);
        super.visitAttlistPre(attlist);
        this.writer.write(10);
    }

    public void visitEntityDeclPre(EntityDecl entityDecl) throws Exception {
        Util.printSpace(this.writer, this.currentIndent);
        try {
            super.visitEntityDeclPre(entityDecl);
        }
        catch (ToNextSiblingTraversalException toNextSiblingTraversalException) {}
        this.writer.write(10);
        throw new ToNextSiblingTraversalException();
    }

    public void visitNotationPre(TXNotation tXNotation) throws Exception {
        Util.printSpace(this.writer, this.currentIndent);
        super.visitNotationPre(tXNotation);
        this.writer.write(10);
    }
}

