/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.parser;

import com.ibm.xml.framework.AttrPool;
import com.ibm.xml.framework.EntityPool;
import com.ibm.xml.framework.ParserState;
import com.ibm.xml.framework.StringPool;
import com.ibm.xml.framework.XMLDocumentHandler;
import com.ibm.xml.framework.XMLDocumentTypeHandler;
import com.ibm.xml.internal.DefaultScanner;
import com.ibm.xml.internal.ErrorCode;
import com.ibm.xml.parser.DTD;
import com.ibm.xml.parser.ElementHandler;
import com.ibm.xml.parser.ErrorListener;
import com.ibm.xml.parser.NoRequiredAttributeHandler;
import com.ibm.xml.parser.PIHandler;
import com.ibm.xml.parser.Parent;
import com.ibm.xml.parser.PreRootHandler;
import com.ibm.xml.parser.ReferenceHandler;
import com.ibm.xml.parser.SAXDriver;
import com.ibm.xml.parser.Source;
import com.ibm.xml.parser.Stderr;
import com.ibm.xml.parser.StreamProducer;
import com.ibm.xml.parser.TXAttribute;
import com.ibm.xml.parser.TXDocument;
import com.ibm.xml.parser.TXElement;
import com.ibm.xml.parser.TagHandler;
import com.ibm.xml.parsers.TXDOMParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Parser
extends TXDOMParser {
    private static final String ALL_TAG_NAMES = " ALL ";
    private static final boolean DEBUG = false;
    StreamProducer streamProducer;
    ErrorListener errorListener;
    int errorCount;
    int validityFailureCount;
    int warnCount;
    boolean isKeepComment;
    boolean isEndBy1stError;
    boolean isProcessNamespace;
    boolean isProcessExternalDTD;
    boolean isWarningRedefinedEntity;
    boolean isWarningNoXMLDecl;
    boolean isWarningNoDoctypeDecl;
    ReferenceHandler referenceHandler;
    TagHandler tagHandler;
    Vector preRootHandlers;
    Vector piHandlers;
    Hashtable elementHandlerHash;
    SAXDriver saxdriver;

    public Parser(String string) {
        this(string, null, null);
    }

    public Parser(String string, ErrorListener errorListener, StreamProducer streamProducer) {
        Stderr stderr = errorListener == null || streamProducer == null ? new Stderr(string) : null;
        this.errorListener = errorListener != null ? errorListener : stderr;
        this.streamProducer = streamProducer != null ? streamProducer : stderr;
        this.initParser();
    }

    private void initParser() {
        this.setAllowJavaEncodingName(false);
        this.setEndBy1stError(true);
        this.setExpandEntityReferences(false);
        this.setKeepComment(true);
        this.setProcessExternalDTD(true);
        this.setProcessNamespace(false);
        this.setWarningNoDoctypeDecl(false);
        this.setWarningNoXMLDecl(true);
        this.setWarningRedefinedEntity(true);
        Handler handler = new Handler();
        this.setDocumentHandler(handler);
        this.setDocumentTypeHandler(handler);
        this.setErrorHandler(handler);
        this.getEntityHandler().setEntityResolver(handler);
    }

    public void setElementFactory(TXDocument tXDocument) {
        this.fDocument = tXDocument;
    }

    public Source getInputStream(String string, String string2, String string3) throws IOException {
        return this.streamProducer.getInputStream(string, string2, string3);
    }

    public void closeInputStream(Source source) {
        this.streamProducer.closeInputStream(source);
    }

    public void loadCatalog(Reader reader) throws IOException {
        this.streamProducer.loadCatalog(reader);
    }

    public void setTagHandler(TagHandler tagHandler) {
        this.tagHandler = tagHandler;
    }

    public void setReferenceHandler(ReferenceHandler referenceHandler) {
        this.referenceHandler = referenceHandler;
    }

    public void addPreRootHandler(PreRootHandler preRootHandler) {
        if (this.preRootHandlers == null) {
            this.preRootHandlers = new Vector();
        }
        this.preRootHandlers.addElement(preRootHandler);
    }

    public void addPIHandler(PIHandler pIHandler) {
        if (this.piHandlers == null) {
            this.piHandlers = new Vector();
        }
        this.piHandlers.addElement(pIHandler);
    }

    public void addElementHandler(ElementHandler elementHandler) {
        this.addElementHandler(elementHandler, ALL_TAG_NAMES);
    }

    public void addElementHandler(ElementHandler elementHandler, String string) {
        Vector<ElementHandler> vector;
        if (this.elementHandlerHash == null) {
            this.elementHandlerHash = new Hashtable();
        }
        if ((vector = (Vector<ElementHandler>)this.elementHandlerHash.get(string)) == null) {
            vector = new Vector<ElementHandler>();
            this.elementHandlerHash.put(string, vector);
        }
        vector.addElement(elementHandler);
    }

    void setSAXDriver(SAXDriver sAXDriver) {
        this.saxdriver = sAXDriver;
        if (sAXDriver != null) {
            this.setNormalizeTextNodes(false);
        }
    }

    public int getNumberOfErrors() {
        return this.errorCount + this.validityFailureCount;
    }

    public int getNumberOfWarnings() {
        return this.warnCount;
    }

    public void setKeepComment(boolean bl) {
        this.isKeepComment = bl;
    }

    public void setExpandEntityReferences(boolean bl) {
        super.setExpandEntityReferences(bl);
    }

    public void setProcessExternalDTD(boolean bl) {
        this.isProcessExternalDTD = bl;
    }

    public void setProcessNamespace(boolean bl) {
        this.isProcessNamespace = bl;
        if (bl) {
            this.setValidationHandler(null);
            return;
        }
        this.useDefaultValidationHandler();
    }

    public void setAllowJavaEncodingName(boolean bl) {
        super.setAllowJavaEncodingName(bl);
    }

    public void setPreserveSpace(boolean bl) {
        throw new IllegalArgumentException("setPreserveSpace not supported");
    }

    public void setEndBy1stError(boolean bl) {
        this.isEndBy1stError = bl;
        super.setContinueAfterFatalError(!bl);
    }

    public TXDocument readStream(InputStream inputStream) {
        return this.readStream(new Source(inputStream));
    }

    public TXDocument readStream(Reader reader) {
        return this.readStream(new Source(reader));
    }

    public TXDocument readStream(Source source) {
        try {
            try {
                InputSource inputSource = new InputSource();
                inputSource.setByteStream(source.getInputStream());
                inputSource.setCharacterStream(source.getReader());
                inputSource.setEncoding(source.getEncoding());
                if (this.streamProducer instanceof Stderr) {
                    Stderr stderr = (Stderr)this.streamProducer;
                    inputSource.setPublicId(stderr.getPublicId());
                    inputSource.setSystemId(stderr.getSystemId());
                }
                this.parse(inputSource);
            }
            catch (Exception exception) {}
        }
        catch (Throwable throwable) {}
        return (TXDocument)this.getDocument();
    }

    public DTD readDTDStream(InputStream inputStream) throws IOException {
        return this.readDTDStream(new Source(inputStream));
    }

    public DTD readDTDStream(Reader reader) throws IOException {
        return this.readDTDStream(new Source(reader));
    }

    public DTD readDTDStream(Source source) throws IOException {
        Object object;
        TXDocument tXDocument = this.fDocument;
        try {
            try {
                this.fDocument = this.fDocument == null ? new TXDocument() : (TXDocument)this.fDocument.cloneNode(false);
                object = new InputSource();
                ((InputSource)object).setByteStream(source.getInputStream());
                ((InputSource)object).setCharacterStream(source.getReader());
                ((InputSource)object).setEncoding(source.getEncoding());
                this.parseDTD((InputSource)object);
            }
            catch (IOException iOException) {
                this.errorString1(88, iOException.getMessage());
            }
            catch (Exception exception) {}
        }
        catch (Throwable throwable) {}
        object = this.fDocument.getDTD();
        this.fDocument = tXDocument;
        return object;
    }

    public final void parseDTD(InputSource inputSource) throws SAXException, IOException {
        if (this.fParseInProgress) {
            throw new SAXException("parse may not be called while parsing");
        }
        if (this.fNeedReset) {
            this.resetOrCopy();
        }
        try {
            this.checkHandlers();
            this.fParseInProgress = true;
            this.fNeedReset = true;
            ((DefaultScanner)this.fScanner).scanDTD(inputSource);
            this.fParseInProgress = false;
            return;
        }
        catch (SAXException sAXException) {
            this.fParseInProgress = false;
            throw sAXException;
        }
        catch (IOException iOException) {
            this.fParseInProgress = false;
            throw iOException;
        }
        catch (Exception exception) {
            this.fParseInProgress = false;
            throw new SAXException(exception);
        }
    }

    public void addNoRequiredAttributeHandler(NoRequiredAttributeHandler noRequiredAttributeHandler) {
        throw new IllegalArgumentException("addNoRequiredAttributeHandler is not supported");
    }

    public void setErrorNoByteMark(boolean bl) {
        throw new IllegalArgumentException("setErrorNoByteMark not supported");
    }

    public int getReaderBufferSize() {
        throw new IllegalArgumentException("setReaderBufferSize is not supported");
    }

    public void setReaderBufferSize(int n) {
        throw new IllegalArgumentException("setReaderBufferSize is not supported");
    }

    public void setWarningRedefinedEntity(boolean bl) {
        this.isWarningRedefinedEntity = bl;
    }

    public void setWarningNoXMLDecl(boolean bl) {
        this.isWarningNoXMLDecl = bl;
    }

    public void setWarningNoDoctypeDecl(boolean bl) {
        this.isWarningNoDoctypeDecl = bl;
    }

    public void stop() {
        this.getParserState().getScanner().stop();
    }

    protected void handleError(String string, String string2) throws Exception {
        Locator locator = this.getLocator();
        this.errorListener.error(locator.getSystemId(), locator.getLineNumber(), locator.getColumnNumber(), string, string2);
        super.handleError(string, string2);
    }

    public void reset() {
        super.reset();
        this.warnCount = 0;
        this.validityFailureCount = 0;
        this.errorCount = 0;
        this.errorListener = null;
        this.streamProducer = null;
        this.tagHandler = null;
        this.preRootHandlers = null;
        this.piHandlers = null;
        this.elementHandlerHash = null;
        this.referenceHandler = null;
    }

    Node getCurrentNode() {
        return this.fCurrentNode;
    }

    void setRealParent(Node node) {
        Node node2 = (Node)this.fNodeStack.peek();
        node2.removeChild(node2.getLastChild());
        node2.appendChild(node);
    }

    TXElement getCurrentParent() {
        return (TXElement)this.fCurrentParent;
    }

    private final void errorString1(int n, String string) throws Exception {
        String string2 = ErrorCode.getErrorKey(n);
        if (!this.errorHandlingEnabled() && !this.isFatal(string2)) {
            return;
        }
        Object[] objectArray = new String[]{string};
        String string3 = this.getErrorMsgString(string2, objectArray);
        this.handleError(string2, string3);
    }

    private final void errorString4(int n, String string, String string2, String string3, String string4) throws Exception {
        String string5 = ErrorCode.getErrorKey(n);
        if (!(this.errorHandlingEnabled() || !this.getContinueAfterFatalError() && this.isFatal(string5))) {
            return;
        }
        Object[] objectArray = new String[]{string, string2, string3, string4};
        String string6 = this.getErrorMsgString(string5, objectArray);
        this.handleError(string5, string6);
    }

    void TXNamespaceCode(TXElement tXElement, int n, int n2) {
        TXAttribute[] tXAttributeArray = tXElement.getAttributeArray();
        if (this.isProcessNamespace) {
            try {
                String[] stringArray = new String[tXAttributeArray.length];
                AttrPool attrPool = this.getParserState().getAttrPool();
                attrPool.getAttributeList(n2);
                int n3 = 0;
                while (n3 < tXAttributeArray.length) {
                    String string = tXAttributeArray[n3].getNodeName();
                    int n4 = this.checkNamespace(tXElement, string);
                    if (n4 != -1) {
                        this.errorString1(n4, string);
                    }
                    if (tXAttributeArray[n3].getValue().length() == 0 && string.startsWith("xmlns:")) {
                        this.errorString1(142, string);
                    }
                    stringArray[n3] = tXAttributeArray[n3].getNSLocalName();
                    String string2 = tXAttributeArray[n3].getNSName();
                    if (string2 != null) {
                        int n5 = 0;
                        while (n5 < n3) {
                            String string3;
                            if (stringArray[n5].equals(stringArray[n3]) && (string3 = tXAttributeArray[n5].getNSName()) != null && string3.equals(string2)) {
                                this.errorString4(144, tXAttributeArray[n3].getNodeName(), string2, stringArray[n3], tXAttributeArray[n5].getNodeName());
                            }
                            ++n5;
                        }
                    }
                    ++n3;
                }
                int n6 = this.checkNamespace(tXElement, tXElement.getName());
                if (n6 != -1) {
                    this.error1(n6, n);
                    return;
                }
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    int checkNamespace(TXElement tXElement, String string) {
        int n = string.indexOf(58);
        if (n < 0) {
            return -1;
        }
        if (tXElement.getNamespaceForPrefix(string.substring(0, n)) == null) {
            return 136;
        }
        if (string.indexOf(58, n + 1) >= 0) {
            return 135;
        }
        return -1;
    }

    static /* synthetic */ boolean access$0() {
        return false;
    }

    class Handler
    implements XMLDocumentTypeHandler,
    XMLDocumentHandler,
    ErrorHandler,
    EntityResolver {
        public void doctypeDecl(int n) throws Exception {
            Enumeration enumeration;
            Vector vector;
            if (Parser.access$0()) {
                System.out.println("doctypeDecl(\"" + Parser.this.getParserState().getStringPool().toString(n) + "\")");
            }
            if ((vector = Parser.this.preRootHandlers) != null && (enumeration = vector.elements()).hasMoreElements()) {
                TXDocument tXDocument = (TXDocument)Parser.this.getDocument();
                String string = Parser.this.getParserState().getStringPool().toString(n);
                do {
                    PreRootHandler preRootHandler = (PreRootHandler)enumeration.nextElement();
                    preRootHandler.handlePreRoot(tXDocument, string);
                } while (enumeration.hasMoreElements());
            }
            Parser.this.doctypeDecl(n);
        }

        public void startInternalSubset() throws Exception {
            Parser.this.startInternalSubset();
        }

        public void endInternalSubset() throws Exception {
            Parser.this.endInternalSubset();
        }

        public void startExternalSubset(int n, int n2) throws Exception {
            Parser.this.startExternalSubset(n, n2);
        }

        public void endExternalSubset() throws Exception {
            Parser.this.endExternalSubset();
        }

        public void elementDecl(int n) throws Exception {
            Parser.this.elementDecl(n);
        }

        public void unparsedEntityDecl(int n) throws Exception {
            Parser.this.unparsedEntityDecl(n);
        }

        public void attlistDecl(int n, int n2) throws Exception {
            Parser.this.attlistDecl(n, n2);
        }

        public void internalEntityDecl(int n) throws Exception {
            Parser.this.internalEntityDecl(n);
        }

        public void externalEntityDecl(int n) throws Exception {
            Parser.this.externalEntityDecl(n);
        }

        public void notationDecl(int n) throws Exception {
            Parser.this.notationDecl(n);
        }

        public void parameterEntityDecl(int n) throws Exception {
            Parser.this.parameterEntityDecl(n);
        }

        public boolean sendCharDataAsCharArray() {
            return Parser.this.sendCharDataAsCharArray();
        }

        public void endDocument() throws Exception {
            Parser.this.endDocument();
        }

        public void characters(int n, boolean bl) throws Exception {
            Parser.this.characters(n, bl);
        }

        public void ignorableWhitespace(int n, boolean bl) throws Exception {
            Parser.this.ignorableWhitespace(n, bl);
        }

        public void comment(int n) throws Exception {
            if (Parser.this.isKeepComment) {
                Parser.this.comment(n);
                return;
            }
            Parser.this.getParserState().getStringPool().releaseString(n);
        }

        public void characters(char[] cArray, int n, int n2, boolean bl) throws Exception {
            Parser.this.characters(cArray, n, n2, bl);
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2, boolean bl) throws Exception {
            Parser.this.ignorableWhitespace(cArray, n, n2, bl);
        }

        public void startDocument(int n, int n2, int n3) throws Exception {
            Parser.this.startDocument(n, n2, n3);
        }

        public void startEntityReference(int n) throws Exception {
            if (Parser.access$0()) {
                System.out.println("startEntityReference(\"" + Parser.this.getParserState().getStringPool().toString(Parser.this.getParserState().getEntityPool().getEntityName(n)) + "\")");
            }
            Parser.this.startEntityReference(n);
            ReferenceHandler referenceHandler = Parser.this.referenceHandler;
            if (referenceHandler != null) {
                ParserState parserState = Parser.this.getParserState();
                EntityPool entityPool = parserState.getEntityPool();
                StringPool stringPool = parserState.getStringPool();
                String string = stringPool.toString(entityPool.getEntityName(n));
                referenceHandler.startReference(string);
            }
        }

        public void endEntityReference(int n) throws Exception {
            if (Parser.access$0()) {
                System.out.println("endEntityReference(\"" + Parser.this.getParserState().getStringPool().toString(Parser.this.getParserState().getEntityPool().getEntityName(n)) + "\")");
            }
            Parser.this.endEntityReference(n);
            ReferenceHandler referenceHandler = Parser.this.referenceHandler;
            if (referenceHandler != null) {
                ParserState parserState = Parser.this.getParserState();
                EntityPool entityPool = parserState.getEntityPool();
                StringPool stringPool = parserState.getStringPool();
                String string = stringPool.toString(entityPool.getEntityName(n));
                referenceHandler.endReference(string);
            }
        }

        public void processingInstruction(int n, int n2) throws Exception {
            Enumeration enumeration;
            if (Parser.this.piHandlers != null && (enumeration = Parser.this.piHandlers.elements()).hasMoreElements()) {
                StringPool stringPool = Parser.this.getParserState().getStringPool();
                String string = stringPool.toString(n);
                String string2 = stringPool.toString(n2);
                do {
                    PIHandler pIHandler = (PIHandler)enumeration.nextElement();
                    pIHandler.handlePI(string, string2);
                } while (enumeration.hasMoreElements());
            }
            Parser.this.processingInstruction(n, n2);
        }

        public void startElement(int n, int n2) throws Exception {
            if (Parser.access$0()) {
                System.out.println("startElement(\"" + Parser.this.getParserState().getStringPool().toString(n) + "\")");
            }
            Parser.this.startElement(n, n2);
            TagHandler tagHandler = Parser.this.tagHandler;
            if (tagHandler != null) {
                TXElement tXElement = Parser.this.getCurrentParent();
                tagHandler.handleStartTag(tXElement, tXElement.hasChildNodes());
            }
            Parser.this.TXNamespaceCode(Parser.this.getCurrentParent(), n, n2);
        }

        public void endElement(int n) throws Exception {
            Object object;
            TagHandler tagHandler = Parser.this.tagHandler;
            if (tagHandler != null) {
                object = Parser.this.getCurrentParent();
                tagHandler.handleEndTag((TXElement)object, ((Parent)object).hasChildNodes());
            }
            object = Parser.this.getParserState().getStringPool();
            String string = object.toString(n);
            String[] stringArray = new String[]{string, ALL_TAG_NAMES};
            Hashtable hashtable = Parser.this.elementHandlerHash;
            if (hashtable != null) {
                int n2 = 0;
                while (n2 < stringArray.length) {
                    Vector vector = (Vector)hashtable.get(stringArray[n2]);
                    if (vector != null) {
                        TXElement tXElement = Parser.this.getCurrentParent();
                        Enumeration enumeration = vector.elements();
                        while (enumeration.hasMoreElements()) {
                            ElementHandler elementHandler = (ElementHandler)enumeration.nextElement();
                            Parser.this.setRealParent(elementHandler.handleElement(tXElement));
                        }
                    }
                    ++n2;
                }
            }
            Parser.this.endElement(n);
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            ++Parser.this.warnCount;
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            ++Parser.this.validityFailureCount;
            if (Parser.this.isEndBy1stError) {
                throw sAXParseException;
            }
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            ++Parser.this.errorCount;
        }

        public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
            Source source = Parser.this.streamProducer.getInputStream("", string, string2);
            InputSource inputSource = new InputSource();
            inputSource.setByteStream(source.getInputStream());
            inputSource.setCharacterStream(source.getReader());
            inputSource.setEncoding(source.getEncoding());
            inputSource.setPublicId(string);
            inputSource.setSystemId(string2);
            return inputSource;
        }

        Handler() {
            Parser.this = Parser.this;
        }
    }
}

