/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.parser;

import com.ibm.xml.parser.ErrorListener;
import com.ibm.xml.parser.LibraryException;
import com.ibm.xml.parser.Source;
import com.ibm.xml.parser.StreamProducer;
import com.ibm.xml.parser.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;

public class Stderr
implements ErrorListener,
StreamProducer {
    private static final boolean DEBUG_ENTITY_RESOLUTION = false;
    public static PrintWriter printer = new PrintWriter(System.err);
    protected String name;
    protected URL url;
    protected Stack stack = new Stack();
    protected Hashtable catalog;
    protected boolean isPrintWarning = true;
    protected String publicId;
    protected String systemId;

    public Stderr(String string) {
        this.name = string;
        try {
            this.url = new URL(this.name);
            this.systemId = this.url.toString();
            return;
        }
        catch (MalformedURLException malformedURLException) {
            try {
                this.url = Stderr.file2URL(string);
                this.systemId = this.url.toString();
                return;
            }
            catch (MalformedURLException malformedURLException2) {
                throw new LibraryException("Stderr#Stderr(): Internal Error: " + malformedURLException);
            }
            catch (SecurityException securityException) {
                printer.println("Specify a complete URL");
                return;
            }
        }
    }

    public void setPrintWarning(boolean bl) {
        this.isPrintWarning = bl;
    }

    public static URL file2URL(String string) throws MalformedURLException {
        char c;
        string = string.replace(File.separatorChar, '/');
        String string2 = String.valueOf(System.getProperty("user.dir").replace(File.separatorChar, '/')) + "/";
        if (string2.charAt(0) != '/') {
            string2 = "/" + string2;
        }
        URL uRL = new URL("file", "", string2);
        if (string.length() >= 2 && string.charAt(1) == ':' && (c = Character.toUpperCase(string.charAt(0))) >= 'A' && c <= 'Z') {
            string = "file:///" + string;
        }
        return new URL(uRL, string);
    }

    public int error(String string, int n, int n2, Object object, String string2) {
        if (string == null) {
            string = this.name;
        }
        if (n2 > 0) {
            --n2;
        }
        if (this.isPrintWarning || !(object instanceof String) || !((String)object).startsWith("W_")) {
            printer.println(String.valueOf(string) + ": " + n + ", " + n2 + ": " + string2);
        }
        printer.flush();
        return 1;
    }

    private String URI2URL(String string) throws IOException {
        if (Util.isURN(string)) {
            String string2 = Util.normalizeURN(string);
            if (this.catalog != null && this.catalog.containsKey(string2)) {
                string = (String)this.catalog.get(string2);
            } else {
                throw new IOException("Can't resolve URN: " + string);
            }
        }
        return string;
    }

    public Source getInputStream(String string, String string2, String string3) throws IOException {
        Object object;
        this.publicId = string2;
        if (string2 != null && this.catalog != null && this.catalog.containsKey(string2)) {
            object = (String)this.catalog.get(string2);
            object = this.URI2URL((String)object);
            URL uRL = new URL(this.url, (String)object);
            try {
                Source source = new Source(uRL.openStream());
                this.stack.push(this.url);
                this.url = uRL;
                this.systemId = object;
                return source;
            }
            catch (IOException iOException) {}
        }
        string3 = this.URI2URL(string3);
        object = new URL(this.url, string3);
        this.stack.push(this.url);
        this.url = object;
        this.systemId = string3;
        return new Source(((URL)object).openStream());
    }

    public void closeInputStream(Source source) {
        if (!this.stack.empty()) {
            this.url = (URL)this.stack.pop();
        }
    }

    public void loadCatalog(Reader reader) throws IOException {
        String string;
        if (this.catalog == null) {
            this.catalog = new Hashtable();
        }
        BufferedReader bufferedReader = new BufferedReader(reader);
        while ((string = bufferedReader.readLine()) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
            if (!stringTokenizer.hasMoreTokens()) continue;
            String string2 = stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens()) continue;
            String string3 = stringTokenizer.nextToken();
            if (Util.isURN(string2)) {
                this.catalog.put(Util.normalizeURN(string2), string3);
                continue;
            }
            this.catalog.put(string2, string3);
        }
    }

    public String getPublicId() {
        return this.publicId;
    }

    public String getSystemId() {
        return this.systemId;
    }
}

