/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xpointer;

import com.ibm.xml.parser.XMLChar;
import com.ibm.xml.xpointer.AbsTerm;
import com.ibm.xml.xpointer.AttrTerm;
import com.ibm.xml.xpointer.OtherTerm;
import com.ibm.xml.xpointer.RelTerm;
import com.ibm.xml.xpointer.RelTermAttribute;
import com.ibm.xml.xpointer.SpanTerm;
import com.ibm.xml.xpointer.StringTerm;
import com.ibm.xml.xpointer.XPointer;
import com.ibm.xml.xpointer.XPointerParseException;
import java.util.Hashtable;
import java.util.Vector;

public class XPointerParser {
    static Hashtable s_keys = new Hashtable(14);
    String xpointer;
    int index;

    public XPointer parse(String string) throws XPointerParseException {
        return this.parse(string, 0);
    }

    public XPointer parse(String string, int n) throws XPointerParseException {
        AbsTerm absTerm = null;
        Vector<OtherTerm> vector = new Vector<OtherTerm>();
        this.xpointer = string;
        this.index = n;
        int n2 = 0;
        boolean bl = false;
        while (this.in() && !bl) {
            block0 : switch (n2) {
                case 0: {
                    String string2 = this.getName();
                    if (string2 == null) {
                        this.error("Syntax error: [ROOT] Expect a name.");
                        bl = true;
                        break;
                    }
                    Integer n3 = (Integer)s_keys.get(string2);
                    if (n3 == null) {
                        this.error("Syntax error: [ROOT] Unexpected name: " + string2);
                        bl = true;
                        break;
                    }
                    switch (n3) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: {
                            absTerm = this.parseAbsTerm(n3);
                            break;
                        }
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: {
                            vector.addElement(this.parseOtherTerm(n3, string2));
                            break;
                        }
                        default: {
                            bl = true;
                            this.error("Internal Error: [ROOT]");
                        }
                    }
                    n2 = 1;
                    break;
                }
                case 1: {
                    if (this.next() != 46) {
                        bl = true;
                        break;
                    }
                    this.get();
                    if (this.next() == 40) {
                        vector.addElement(this.parseOtherTerm(-1, null));
                        break;
                    }
                    String string2 = this.getName();
                    if (string2 == null) {
                        this.error("Syntax error: [ROOT] Expect a name.");
                        bl = true;
                        break;
                    }
                    Integer n3 = (Integer)s_keys.get(string2);
                    if (n3 == null) {
                        this.error("Syntax error: [ROOT] Unexpected name: " + string2);
                        bl = true;
                        break;
                    }
                    switch (n3) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: {
                            bl = true;
                            this.error("Syntax error: [ROOT] Unexpected name: " + string2);
                            break block0;
                        }
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: {
                            vector.addElement(this.parseOtherTerm(n3, string2));
                            break block0;
                        }
                    }
                    bl = true;
                    this.error("Internal Error: [ROOT]");
                    break;
                }
                default: {
                    bl = true;
                    this.error("Internal Error: [ROOT] Invalid state: " + n2);
                    break;
                }
            }
        }
        this.xpointer = this.xpointer.substring(n, this.index);
        return new XPointer(absTerm, vector);
    }

    public String toString() {
        return this.xpointer;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.err.println("Require 1 argument.");
            System.exit(1);
        }
        try {
            XPointer xPointer = new XPointerParser().parse(stringArray[0]);
            System.out.println("PARSED and RESTRUCTED: " + xPointer.toString());
            return;
        }
        catch (XPointerParseException xPointerParseException) {
            xPointerParseException.printStackTrace();
            return;
        }
    }

    AbsTerm parseAbsTerm(int n) throws XPointerParseException {
        String string = null;
        if (this.next() != 40) {
            this.error("Syntax error: expect `(': " + this.left());
        } else {
            this.get();
            if (n == 3) {
                String string2 = this.getName();
                if (string2 == null) {
                    this.error("Syntax error: expect ID name: " + this.left());
                } else {
                    string = string2;
                }
            } else if (n == 4) {
                string = this.getSkipLit();
            }
            if (this.next() != 41) {
                this.error("Syntax error: expect `)'");
            } else {
                this.get();
            }
        }
        return new AbsTerm(n, string);
    }

    RelTerm parseRelTerm(int n) throws XPointerParseException {
        if (this.next() != 40) {
            this.error("Syntax error: expect `(': " + this.left());
            return null;
        }
        boolean bl = false;
        int n2 = -1;
        String string = null;
        int n3 = 0;
        Vector<RelTermAttribute> vector = new Vector<RelTermAttribute>();
        this.get();
        String string2 = this.getName();
        if (string2 != null && "all".equals(string2)) {
            bl = true;
        } else if (string2 != null) {
            this.error("Syntax error: [relterm] expect a name or number: " + string2);
        } else {
            n2 = this.getDigit();
        }
        if (this.next() == 44) {
            this.get();
            if (this.next() == 35) {
                this.get();
                string2 = this.getName();
                if (string2 != null) {
                    if (string2.equals("element")) {
                        n3 = 2;
                    } else if (string2.equals("pi")) {
                        n3 = 3;
                    } else if (string2.equals("comment")) {
                        n3 = 4;
                    } else if (string2.equals("text")) {
                        n3 = 5;
                    } else if (string2.equals("cdata")) {
                        n3 = 6;
                    } else if (string2.equals("all")) {
                        n3 = 7;
                    }
                }
            } else {
                string = this.getName();
                n3 = 1;
            }
            if (n3 == 0) {
                this.error("Syntax error: [relterm] expect a name/#element/#pi/#comment/#text/#cdata/#all: #" + string2);
            }
            while (this.in() && this.next() != 41) {
                if (this.next() != 44) break;
                vector.addElement(this.parseAttribute());
            }
        }
        if (this.next() != 41) {
            this.error("Syntax error: [relterm] expect `)': " + this.left());
        } else {
            this.get();
        }
        return new RelTerm(n, bl, n2, n3, string, vector);
    }

    RelTermAttribute parseAttribute() throws XPointerParseException {
        String string;
        int n = -1;
        String string2 = null;
        this.get();
        if (this.next() == 42) {
            string = "*";
            this.get();
        } else {
            string = this.getName();
            if (string == null) {
                this.error("Syntax error: expect `*' or Name: " + this.left());
            }
        }
        if (this.next() != 44) {
            this.error("Syntax error: expect `,': " + this.left());
        } else {
            this.get();
            if (this.next() == 42) {
                this.get();
                n = 1;
                string2 = "*";
            } else if (this.next() == 35) {
                this.get();
                String string3 = this.getName();
                if (string3 == null || !"IMPLIED".equals(string3)) {
                    this.error("Syntax error: [relterm] expect `#IMPLIED': " + this.left());
                } else {
                    n = 0;
                    string2 = "#IMPLIED";
                }
            } else if (this.next() == 34 || this.next() == 39) {
                n = 3;
                string2 = this.getSkipLit();
            } else {
                n = 2;
                string2 = this.getName();
                if (string2 == null) {
                    this.error("Syntax error: [relterm] expect a name: " + this.left());
                }
            }
        }
        return new RelTermAttribute(string, n, string2);
    }

    StringTerm parseStringTerm() throws XPointerParseException {
        boolean bl = false;
        int n = -1;
        String string = null;
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = -1;
        int n3 = -1;
        if (this.next() != 40) {
            this.error("Syntax error: [string] expect `(': " + this.left());
        } else {
            this.get();
            String string2 = this.getName();
            if (string2.equals("all")) {
                bl = true;
            } else {
                n = this.getDigit();
            }
            if (this.next() != 44) {
                this.error("Syntax error: [string] expect `,':" + this.left());
            } else {
                this.get();
                string = this.getSkipLit();
                if (this.next() == 44) {
                    this.get();
                    bl2 = true;
                    string2 = this.getName();
                    if (string2.equals("end")) {
                        bl3 = true;
                    } else {
                        n2 = this.getDigit();
                    }
                    if (this.next() == 44) {
                        this.get();
                        n3 = this.getNaturalNumber();
                    }
                }
                if (this.next() != 41) {
                    this.error("Syntax error: [string] expect `)':" + this.left());
                } else {
                    this.get();
                }
            }
        }
        return new StringTerm(bl, n, string, bl2, bl3, n2, n3);
    }

    AttrTerm parseAttrTerm() throws XPointerParseException {
        String string = null;
        if (this.next() != 40) {
            this.error("Syntax error: [attr] expect `(': " + this.left());
        } else {
            this.get();
            string = this.getName();
            if (string == null) {
                this.error("Syntax error: [attr] expect a name: " + this.left());
            }
            if (this.next() != 41) {
                this.error("Syntax error: [attr] expect `)': " + this.left());
            } else {
                this.get();
            }
        }
        return new AttrTerm(string);
    }

    SpanTerm parseSpanTerm() throws XPointerParseException {
        XPointer xPointer = null;
        XPointer xPointer2 = null;
        if (this.next() != 40) {
            this.error("Syntax error: [span] expect `(': " + this.left());
        } else {
            this.get();
            XPointerParser xPointerParser = new XPointerParser();
            xPointer = xPointerParser.parse(this.xpointer, this.index);
            this.index += xPointerParser.xpointer.length();
            if (this.next() != 44) {
                this.error("Syntax error: [span] expect ',': " + this.left());
            } else {
                this.get();
                xPointer2 = xPointerParser.parse(this.xpointer, this.index);
                this.index += xPointerParser.xpointer.length();
                if (this.next() != 41) {
                    this.error("Syntax error: [span] expect ')': " + this.left());
                } else {
                    this.get();
                }
            }
        }
        return new SpanTerm(xPointer, xPointer2);
    }

    static String makeSkipLit(String string) {
        if (string.indexOf(34) >= 0) {
            return "'" + string + "'";
        }
        return "\"" + string + "\"";
    }

    String left() {
        return this.xpointer.substring(this.index);
    }

    private OtherTerm parseOtherTerm(int n, String string) throws XPointerParseException {
        OtherTerm otherTerm = null;
        switch (n) {
            case -1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                otherTerm = this.parseRelTerm(n);
                break;
            }
            case 12: {
                otherTerm = this.parseSpanTerm();
                break;
            }
            case 13: {
                otherTerm = this.parseAttrTerm();
                break;
            }
            case 14: {
                otherTerm = this.parseStringTerm();
                break;
            }
        }
        return otherTerm;
    }

    private final boolean in() {
        return this.index < this.xpointer.length();
    }

    private final int next() {
        if (this.in()) {
            return this.xpointer.charAt(this.index);
        }
        return -1;
    }

    private final int get() {
        if (this.in()) {
            return this.xpointer.charAt(this.index++);
        }
        return -1;
    }

    private void error(String string) throws XPointerParseException {
        throw new XPointerParseException(string);
    }

    private String getName() {
        int n = this.next();
        if (XMLChar.isLetter((char)n) || n == 95 || n == 58) {
            StringBuffer stringBuffer = new StringBuffer(32);
            do {
                stringBuffer.append((char)this.get());
            } while (this.in() && XMLChar.isNameChar((char)this.next()));
            return stringBuffer.toString();
        }
        return null;
    }

    private String getSkipLit() throws XPointerParseException {
        StringBuffer stringBuffer = new StringBuffer(32);
        int n = this.next();
        if (n == 34 || n == 39) {
            this.get();
            while (this.in() && n != this.next()) {
                stringBuffer.append((char)this.get());
            }
            if (!this.in()) {
                this.error("Unexpected end.");
            }
            this.get();
        } else {
            this.error("Syntax error: expect \" or ': " + this.left());
        }
        return stringBuffer.toString();
    }

    private int getDigit() throws XPointerParseException {
        int n = this.next();
        int n2 = 1;
        if (n == 45) {
            n2 = -1;
            this.get();
        } else if (n == 43) {
            n2 = 1;
            this.get();
        }
        int n3 = 0;
        if (!this.in() || !Character.isDigit((char)(n = this.next()))) {
            this.error("Syntax error: expect digits: " + this.left());
        } else {
            this.get();
            n3 = Character.getNumericValue((char)n);
            while (this.in() && Character.isDigit((char)this.next())) {
                n3 = n3 * 10 + Character.getNumericValue((char)this.get());
            }
        }
        return n3 * n2;
    }

    private int getNaturalNumber() throws XPointerParseException {
        int n = 0;
        if (!this.in() || !Character.isDigit((char)this.next())) {
            this.error("Syntax error: expect digits: " + this.left());
        } else {
            n = Character.getNumericValue((char)this.get());
            while (this.in() && Character.isDigit((char)this.next())) {
                n = n * 10 + Character.getNumericValue((char)this.get());
            }
        }
        return n;
    }

    static {
        s_keys.put(XPointer.literals[1], new Integer(1));
        s_keys.put(XPointer.literals[2], new Integer(2));
        s_keys.put(XPointer.literals[3], new Integer(3));
        s_keys.put(XPointer.literals[4], new Integer(4));
        s_keys.put(XPointer.literals[5], new Integer(5));
        s_keys.put(XPointer.literals[6], new Integer(6));
        s_keys.put(XPointer.literals[7], new Integer(7));
        s_keys.put(XPointer.literals[8], new Integer(8));
        s_keys.put(XPointer.literals[9], new Integer(9));
        s_keys.put(XPointer.literals[10], new Integer(10));
        s_keys.put(XPointer.literals[11], new Integer(11));
        s_keys.put(XPointer.literals[12], new Integer(12));
        s_keys.put(XPointer.literals[13], new Integer(13));
        s_keys.put(XPointer.literals[14], new Integer(14));
    }
}

