/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xpath;

import com.ibm.bsf.BSFEngine;
import com.ibm.bsf.BSFException;
import com.ibm.bsf.BSFManager;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xalan.xpath.XNull;
import org.apache.xalan.xpath.XObject;
import org.apache.xalan.xpath.XPathException;
import org.apache.xalan.xpath.XPathProcessorException;

public class ExtensionFunctionHandler {
    protected String namespaceUri;
    protected String scriptLang = "javaclass";
    protected String scriptSrc;
    protected String scriptSrcURL;
    protected Object javaObject;
    protected boolean hasCalledCTor = false;
    protected Class classObject;
    protected Hashtable functions = new Hashtable();
    protected BSFManager mgr;
    protected boolean componentStarted;
    protected static boolean bsfInitialized;
    static /* synthetic */ Class class$com$ibm$bsf$BSFManager;

    public ExtensionFunctionHandler(String string) {
        this.namespaceUri = string;
    }

    public ExtensionFunctionHandler(String string, String string2, String string3, String string4, String string5) {
        this(string);
        this.setFunctions(string2);
        this.setScript(string3, string4, string5);
    }

    public void setFunctions(String string) {
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r", false);
        Object object = new Object();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            this.functions.put(string2, object);
        }
    }

    public void setScript(String string, String string2, String string3) {
        this.scriptLang = string;
        this.scriptSrcURL = string2;
        this.scriptSrc = string3;
    }

    public boolean isFunctionAvailable(String string) {
        return this.functions.get(string) != null;
    }

    public Object callFunction(String string, Vector vector) throws XPathException {
        if (!this.componentStarted) {
            this.startupComponent();
        }
        try {
            int n;
            Object[] objectArray;
            BSFEngine bSFEngine;
            if (this.mgr == null) {
                this.mgr = new BSFManager();
            }
            boolean bl = false;
            if (this.scriptLang.equals("javaclass")) {
                bl = string.equals("new");
                bSFEngine = this.mgr.loadScriptingEngine("xslt-javaclass");
                if (bl) {
                    objectArray = new Object[vector.size()];
                    n = 0;
                    string = String.valueOf(this.classObject.getName()) + ".new";
                    this.javaObject = null;
                    this.hasCalledCTor = true;
                } else if (!this.hasCalledCTor) {
                    if (this.javaObject == null) {
                        this.javaObject = this.classObject.newInstance();
                    }
                    objectArray = new Object[vector.size() + 1];
                    objectArray[0] = this.javaObject;
                    n = 1;
                } else {
                    objectArray = new Object[vector.size()];
                    n = 0;
                }
            } else {
                bSFEngine = this.mgr.loadScriptingEngine(this.scriptLang);
                objectArray = new Object[vector.size()];
                n = 0;
            }
            int n2 = 0;
            while (n2 < vector.size()) {
                Object e = vector.elementAt(n2);
                objectArray[n2 + n] = e instanceof XObject ? ((XObject)e).object() : e;
                ++n2;
            }
            return bSFEngine.call(null, string, objectArray);
        }
        catch (Exception exception) {
            String string2 = exception.getMessage();
            if (string2 != null) {
                if (string2.startsWith("Stopping after fatal error:")) {
                    string2 = string2.substring("Stopping after fatal error:".length());
                }
                System.out.println("Call to extension function failed: " + string2);
            }
            return new XNull();
        }
    }

    protected void startupComponent() throws XPathProcessorException {
        Object object;
        if (!bsfInitialized) {
            object = class$com$ibm$bsf$BSFManager != null ? class$com$ibm$bsf$BSFManager : (class$com$ibm$bsf$BSFManager = ExtensionFunctionHandler.class$("com.ibm.bsf.BSFManager"));
            synchronized (object) {
                bsfInitialized = true;
                BSFManager.registerScriptingEngine("xslt-javaclass", "org.apache.xalan.xpath.XSLTJavaClassEngine", new String[0]);
            }
        }
        if (this.scriptLang.equals("javaclass") && this.scriptSrcURL != null) {
            try {
                object = this.scriptSrcURL;
                boolean bl = false;
                if (this.scriptSrcURL.startsWith("class:")) {
                    object = this.scriptSrcURL.substring(6);
                    bl = true;
                }
                this.classObject = Class.forName((String)object);
                if (bl) {
                    this.javaObject = this.classObject;
                }
                this.componentStarted = true;
                return;
            }
            catch (Exception exception) {
                throw new XPathProcessorException(exception.getMessage(), exception);
            }
        }
        if (this.scriptSrcURL != null) {
            throw new XPathProcessorException("src attr not supported (yet)");
        }
        if (this.scriptSrc == null) {
            return;
        }
        if (this.mgr == null) {
            this.mgr = new BSFManager();
        }
        try {
            this.mgr.exec(this.scriptLang, "LotusXSLScript", -1, -1, this.scriptSrc);
        }
        catch (BSFException bSFException) {
            throw new XPathProcessorException(bSFException.getMessage(), bSFException);
        }
        this.componentStarted = true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

