/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xpath;

import org.apache.xalan.xpath.XPath;
import org.apache.xalan.xpath.xml.IntStack;

public class UnionContext {
    static final int MAXPATHS = 32;
    IntStack[] m_stacks = new IntStack[32];
    IntStack[] m_posStacks = new IntStack[32];
    int m_stackCount;
    public static final int PSUEDO_POS_FOUNDNODE = -10000;
    public static final int PSUEDO_OP_FOUNDNODE = -10000;

    UnionContext(int[] nArray, int n) {
        int n2 = nArray[n];
        if (n2 == 20) {
            this.pushUnionPath(nArray, n);
            return;
        }
        if (n2 == 28) {
            this.pushLocationPath(0, nArray, n);
            return;
        }
        System.out.println("Programmers Error! Op must be OP_UNION or OP_LOCATIONPATH");
    }

    public final int getLocationPathCount() {
        return this.m_stackCount;
    }

    private final void setLocationPathCount(int n) {
        this.m_stackCount = n;
    }

    private final void addNewLocationPath(int n) {
        this.m_stacks[n] = new IntStack();
        this.m_posStacks[n] = new IntStack();
        this.setLocationPathCount(n + 1);
    }

    void pushLocationPath(int n, int[] nArray, int n2) {
        this.addNewLocationPath(n);
        n2 = XPath.getFirstChildPos(n2);
        this.push(n, n2, 1);
    }

    private void pushUnionPath(int[] nArray, int n) {
        n += 2;
        int n2 = 0;
        while (nArray[n] == 28) {
            int n3 = XPath.getNextOpPos(nArray, n);
            this.pushLocationPath(n2, nArray, n);
            n = n3;
            ++n2;
        }
    }

    void setNodePosition(int n, int n2) {
        this.m_posStacks[n].setTop(n2);
    }

    void incrementNodePosition(int n) {
        this.m_posStacks[n].setTop(this.getNodePosition(n) + 1);
    }

    int getNodePosition(int n) {
        return this.m_posStacks[n].peek();
    }

    public int push(int n, int n2, int n3) {
        this.m_posStacks[n].push(n3);
        return this.m_stacks[n].push(n2);
    }

    public int pop(int n) {
        this.m_posStacks[n].pop();
        return this.m_stacks[n].pop();
    }

    public void pop() {
        int n = this.m_stackCount;
        int n2 = 0;
        while (n2 < n) {
            this.pop(n2);
            ++n2;
        }
    }

    public int peek(int n) {
        return this.m_stacks[n].peek();
    }

    public boolean empty(int n) {
        return this.m_stacks[n].empty();
    }

    public boolean empty() {
        int n = this.m_stackCount;
        int n2 = 0;
        while (n2 < n) {
            if (!this.empty(n2)) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

