/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xpath;

import java.text.NumberFormat;
import java.text.ParseException;
import org.apache.xalan.xpath.MutableNodeList;
import org.apache.xalan.xpath.MutableNodeListImpl;
import org.apache.xalan.xpath.XObject;
import org.apache.xalan.xpath.XPathSupport;
import org.apache.xalan.xpath.xml.XMLParserLiaisonDefault;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XNodeSet
extends XObject {
    public XNodeSet(NodeList nodeList) {
        super(nodeList);
    }

    public XNodeSet() {
        super(new MutableNodeListImpl());
    }

    public XNodeSet(Node node) {
        super(new MutableNodeListImpl());
        if (node != null) {
            ((MutableNodeList)this.m_obj).addNode(node);
        }
    }

    public int getType() {
        return 4;
    }

    private String getTypeString() {
        return "#NODESET";
    }

    double getNumberFromNode(Node node) {
        double d;
        String string = XMLParserLiaisonDefault.getNodeData(node);
        if (string == null) {
            d = 0.0;
        } else {
            try {
                NumberFormat numberFormat = NumberFormat.getNumberInstance();
                d = numberFormat.parse(string.trim()).doubleValue();
            }
            catch (ParseException parseException) {
                d = 0.0;
            }
        }
        return d;
    }

    public double num() {
        NodeList nodeList = this.nodeset();
        int n = nodeList.getLength();
        double d = n > 0 ? this.getNumberFromNode(nodeList.item(0)) : Double.NaN;
        return d;
    }

    public boolean bool() {
        return this.nodeset().getLength() > 0;
    }

    String getStringFromNode(Node node) {
        String string;
        short s = node.getNodeType();
        if (s == 8 || s == 7) {
            string = node.getNodeValue();
        } else {
            string = XMLParserLiaisonDefault.getNodeData(node);
            if (string == null) {
                string = "";
            }
        }
        return string;
    }

    public String str() {
        String string;
        NodeList nodeList = this.nodeset();
        int n = nodeList.getLength();
        if (n > 0) {
            Node node = nodeList.item(0);
            string = this.getStringFromNode(node);
        } else {
            string = "";
        }
        return string;
    }

    public DocumentFragment rtree(XPathSupport xPathSupport) {
        DocumentFragment documentFragment = xPathSupport.getDOMFactory().createDocumentFragment();
        NodeList nodeList = this.nodeset();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            documentFragment.appendChild(nodeList.item(n2).cloneNode(true));
            ++n2;
        }
        return documentFragment;
    }

    public NodeList nodeset() {
        return (NodeList)this.m_obj;
    }

    public MutableNodeList mutableNodeset() {
        MutableNodeList mutableNodeList;
        if (this.m_obj instanceof MutableNodeList) {
            mutableNodeList = (MutableNodeList)this.m_obj;
        } else {
            mutableNodeList = new MutableNodeListImpl(this.nodeset());
            this.m_obj = mutableNodeList;
        }
        return mutableNodeList;
    }

    public boolean lessThan(XObject xObject) throws SAXException {
        boolean bl = false;
        int n = xObject.getType();
        if (n == 4) {
            NodeList nodeList = this.nodeset();
            NodeList nodeList2 = ((XNodeSet)xObject).nodeset();
            int n2 = nodeList.getLength();
            int n3 = nodeList2.getLength();
            int n4 = 0;
            while (n4 < n2) {
                String string = this.getStringFromNode(nodeList.item(n4));
                int n5 = 0;
                while (n5 < n3) {
                    String string2 = this.getStringFromNode(nodeList2.item(n5));
                    if (string.compareTo(string2) < 0) {
                        bl = true;
                        break;
                    }
                    ++n5;
                }
                ++n4;
            }
        } else if (n == 1) {
            double d = this.bool() ? 1.0 : 0.0;
            double d2 = xObject.num();
            bl = d < d2;
        } else if (n == 2) {
            NodeList nodeList = this.nodeset();
            int n6 = nodeList.getLength();
            double d = xObject.num();
            int n7 = 0;
            while (n7 < n6) {
                double d3 = this.getNumberFromNode(nodeList.item(n7));
                if (d3 < d) {
                    bl = true;
                    break;
                }
                ++n7;
            }
        } else if (n == 5) {
            double d = xObject.num();
            if (d != Double.NaN) {
                NodeList nodeList = this.nodeset();
                int n8 = nodeList.getLength();
                int n9 = 0;
                while (n9 < n8) {
                    double d4 = this.getNumberFromNode(nodeList.item(n9));
                    if (d4 < d) {
                        bl = true;
                        break;
                    }
                    ++n9;
                }
            } else {
                NodeList nodeList = this.nodeset();
                int n10 = nodeList.getLength();
                String string = xObject.str();
                int n11 = 0;
                while (n11 < n10) {
                    String string3 = this.getStringFromNode(nodeList.item(n11));
                    if (string3.compareTo(string) < 0) {
                        bl = true;
                        break;
                    }
                    ++n11;
                }
            }
        } else if (n == 3) {
            NodeList nodeList = this.nodeset();
            int n12 = nodeList.getLength();
            String string = xObject.str();
            int n13 = 0;
            while (n13 < n12) {
                String string4 = this.getStringFromNode(nodeList.item(n13));
                if (string4.compareTo(string) < 0) {
                    bl = true;
                    break;
                }
                ++n13;
            }
        } else {
            bl = this.num() < xObject.num();
        }
        return bl;
    }

    public boolean lessThanOrEqual(XObject xObject) throws SAXException {
        boolean bl = false;
        int n = xObject.getType();
        if (n == 4) {
            NodeList nodeList = this.nodeset();
            NodeList nodeList2 = ((XNodeSet)xObject).nodeset();
            int n2 = nodeList.getLength();
            int n3 = nodeList2.getLength();
            int n4 = 0;
            while (n4 < n2) {
                String string = this.getStringFromNode(nodeList.item(n4));
                int n5 = 0;
                while (n5 < n3) {
                    String string2 = this.getStringFromNode(nodeList2.item(n5));
                    if (string.compareTo(string2) <= 0) {
                        bl = true;
                        break;
                    }
                    ++n5;
                }
                ++n4;
            }
        } else if (n == 1) {
            double d = this.bool() ? 1.0 : 0.0;
            double d2 = xObject.num();
            bl = d <= d2;
        } else if (n == 2) {
            NodeList nodeList = this.nodeset();
            int n6 = nodeList.getLength();
            double d = xObject.num();
            int n7 = 0;
            while (n7 < n6) {
                double d3 = this.getNumberFromNode(nodeList.item(n7));
                if (d3 <= d) {
                    bl = true;
                    break;
                }
                ++n7;
            }
        } else if (n == 5) {
            double d = xObject.num();
            if (d != Double.NaN) {
                NodeList nodeList = this.nodeset();
                int n8 = nodeList.getLength();
                int n9 = 0;
                while (n9 < n8) {
                    double d4 = this.getNumberFromNode(nodeList.item(n9));
                    if (d4 <= d) {
                        bl = true;
                        break;
                    }
                    ++n9;
                }
            } else {
                NodeList nodeList = this.nodeset();
                int n10 = nodeList.getLength();
                String string = xObject.str();
                int n11 = 0;
                while (n11 < n10) {
                    String string3 = this.getStringFromNode(nodeList.item(n11));
                    if (string3.compareTo(string) <= 0) {
                        bl = true;
                        break;
                    }
                    ++n11;
                }
            }
        } else if (n == 3) {
            NodeList nodeList = this.nodeset();
            int n12 = nodeList.getLength();
            String string = xObject.str();
            int n13 = 0;
            while (n13 < n12) {
                String string4 = this.getStringFromNode(nodeList.item(n13));
                if (string4.compareTo(string) <= 0) {
                    bl = true;
                    break;
                }
                ++n13;
            }
        } else {
            bl = this.num() <= xObject.num();
        }
        return bl;
    }

    public boolean greaterThan(XObject xObject) throws SAXException {
        boolean bl = false;
        int n = xObject.getType();
        if (n == 4) {
            NodeList nodeList = this.nodeset();
            NodeList nodeList2 = ((XNodeSet)xObject).nodeset();
            int n2 = nodeList.getLength();
            int n3 = nodeList2.getLength();
            int n4 = 0;
            while (n4 < n2) {
                String string = this.getStringFromNode(nodeList.item(n4));
                int n5 = 0;
                while (n5 < n3) {
                    String string2 = this.getStringFromNode(nodeList2.item(n5));
                    if (string.compareTo(string2) > 0) {
                        bl = true;
                        break;
                    }
                    ++n5;
                }
                ++n4;
            }
        } else if (n == 1) {
            double d = this.bool() ? 1.0 : 0.0;
            double d2 = xObject.num();
            bl = d > d2;
        } else if (n == 2) {
            NodeList nodeList = this.nodeset();
            int n6 = nodeList.getLength();
            double d = xObject.num();
            int n7 = 0;
            while (n7 < n6) {
                double d3 = this.getNumberFromNode(nodeList.item(n7));
                if (d3 > d) {
                    bl = true;
                    break;
                }
                ++n7;
            }
        } else if (n == 5) {
            double d = xObject.num();
            if (d != Double.NaN) {
                NodeList nodeList = this.nodeset();
                int n8 = nodeList.getLength();
                int n9 = 0;
                while (n9 < n8) {
                    double d4 = this.getNumberFromNode(nodeList.item(n9));
                    if (d4 > d) {
                        bl = true;
                        break;
                    }
                    ++n9;
                }
            } else {
                NodeList nodeList = this.nodeset();
                int n10 = nodeList.getLength();
                String string = xObject.str();
                int n11 = 0;
                while (n11 < n10) {
                    String string3 = this.getStringFromNode(nodeList.item(n11));
                    if (string3.compareTo(string) > 0) {
                        bl = true;
                        break;
                    }
                    ++n11;
                }
            }
        } else if (n == 3) {
            NodeList nodeList = this.nodeset();
            int n12 = nodeList.getLength();
            String string = xObject.str();
            int n13 = 0;
            while (n13 < n12) {
                String string4 = this.getStringFromNode(nodeList.item(n13));
                if (string4.compareTo(string) > 0) {
                    bl = true;
                    break;
                }
                ++n13;
            }
        } else {
            bl = this.num() > xObject.num();
        }
        return bl;
    }

    public boolean greaterThanOrEqual(XObject xObject) throws SAXException {
        boolean bl = false;
        int n = xObject.getType();
        if (n == 4) {
            NodeList nodeList = this.nodeset();
            NodeList nodeList2 = ((XNodeSet)xObject).nodeset();
            int n2 = nodeList.getLength();
            int n3 = nodeList2.getLength();
            int n4 = 0;
            while (n4 < n2) {
                String string = this.getStringFromNode(nodeList.item(n4));
                int n5 = 0;
                while (n5 < n3) {
                    String string2 = this.getStringFromNode(nodeList2.item(n5));
                    if (string.compareTo(string2) >= 0) {
                        bl = true;
                        break;
                    }
                    ++n5;
                }
                ++n4;
            }
        } else if (n == 1) {
            double d = this.bool() ? 1.0 : 0.0;
            double d2 = xObject.num();
            bl = d >= d2;
        } else if (n == 2) {
            NodeList nodeList = this.nodeset();
            int n6 = nodeList.getLength();
            double d = xObject.num();
            int n7 = 0;
            while (n7 < n6) {
                double d3 = this.getNumberFromNode(nodeList.item(n7));
                if (d3 >= d) {
                    bl = true;
                    break;
                }
                ++n7;
            }
        } else if (n == 5) {
            double d = xObject.num();
            if (d != Double.NaN) {
                NodeList nodeList = this.nodeset();
                int n8 = nodeList.getLength();
                int n9 = 0;
                while (n9 < n8) {
                    double d4 = this.getNumberFromNode(nodeList.item(n9));
                    if (d4 >= d) {
                        bl = true;
                        break;
                    }
                    ++n9;
                }
            } else {
                NodeList nodeList = this.nodeset();
                int n10 = nodeList.getLength();
                String string = xObject.str();
                int n11 = 0;
                while (n11 < n10) {
                    String string3 = this.getStringFromNode(nodeList.item(n11));
                    if (string3.compareTo(string) >= 0) {
                        bl = true;
                        break;
                    }
                    ++n11;
                }
            }
        } else if (n == 3) {
            NodeList nodeList = this.nodeset();
            int n12 = nodeList.getLength();
            String string = xObject.str();
            int n13 = 0;
            while (n13 < n12) {
                String string4 = this.getStringFromNode(nodeList.item(n13));
                if (string4.compareTo(string) >= 0) {
                    bl = true;
                    break;
                }
                ++n13;
            }
        } else {
            bl = this.num() >= xObject.num();
        }
        return bl;
    }

    public boolean equals(XObject xObject) throws SAXException {
        boolean bl = false;
        int n = xObject.getType();
        if (n == 4) {
            NodeList nodeList = this.nodeset();
            NodeList nodeList2 = ((XNodeSet)xObject).nodeset();
            int n2 = nodeList.getLength();
            int n3 = nodeList2.getLength();
            int n4 = 0;
            while (n4 < n2) {
                String string = this.getStringFromNode(nodeList.item(n4));
                int n5 = 0;
                while (n5 < n3) {
                    String string2 = this.getStringFromNode(nodeList2.item(n5));
                    if (string2.equals(string)) {
                        bl = true;
                        break;
                    }
                    ++n5;
                }
                ++n4;
            }
        } else if (n == 1) {
            bl = this.bool() == xObject.bool();
        } else if (n == 2) {
            NodeList nodeList = this.nodeset();
            int n6 = nodeList.getLength();
            double d = xObject.num();
            int n7 = 0;
            while (n7 < n6) {
                double d2 = this.getNumberFromNode(nodeList.item(n7));
                if (d2 == d) {
                    bl = true;
                    break;
                }
                ++n7;
            }
        } else if (n == 5) {
            double d = xObject.num();
            if (d != Double.NaN) {
                NodeList nodeList = this.nodeset();
                int n8 = nodeList.getLength();
                int n9 = 0;
                while (n9 < n8) {
                    double d3 = this.getNumberFromNode(nodeList.item(n9));
                    if (d3 == d) {
                        bl = true;
                        break;
                    }
                    ++n9;
                }
            } else {
                NodeList nodeList = this.nodeset();
                int n10 = nodeList.getLength();
                String string = xObject.str();
                int n11 = 0;
                while (n11 < n10) {
                    String string3 = this.getStringFromNode(nodeList.item(n11));
                    if (string3.equals(string)) {
                        bl = true;
                        break;
                    }
                    ++n11;
                }
            }
        } else if (n == 3) {
            NodeList nodeList = this.nodeset();
            int n12 = nodeList.getLength();
            String string = xObject.str();
            int n13 = 0;
            while (n13 < n12) {
                String string4 = this.getStringFromNode(nodeList.item(n13));
                if (string4.equals(string)) {
                    bl = true;
                    break;
                }
                ++n13;
            }
        } else {
            bl = super.equals(xObject);
        }
        return bl;
    }
}

