/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xpath;

import java.io.Serializable;
import org.apache.xalan.xpath.MutableNodeList;
import org.apache.xalan.xpath.XPathException;
import org.apache.xalan.xpath.XPathSupport;
import org.apache.xalan.xpath.xml.XSLMessages;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class XObject
implements Serializable {
    protected Object m_obj;
    public static final int CLASS_NULL = -1;
    public static final int CLASS_UNKNOWN = 0;
    public static final int CLASS_BOOLEAN = 1;
    public static final int CLASS_NUMBER = 2;
    public static final int CLASS_STRING = 3;
    public static final int CLASS_NODESET = 4;
    public static final int CLASS_RTREEFRAG = 5;

    public XObject() {
    }

    public XObject(Object object) {
        this.m_obj = object;
    }

    public int getType() {
        return 0;
    }

    private String getTypeString() {
        return "#UNKNOWN";
    }

    public double num() throws SAXException {
        this.error(18, new Object[]{this.getTypeString()});
        return 0.0;
    }

    public boolean bool() throws SAXException {
        this.error(18, new Object[]{this.getTypeString()});
        return false;
    }

    public String str() {
        return this.m_obj.toString();
    }

    public String toString() {
        return this.str();
    }

    public DocumentFragment rtree(XPathSupport xPathSupport) {
        DocumentFragment documentFragment = this.rtree();
        if (documentFragment == null) {
            documentFragment = xPathSupport.getDOMFactory().createDocumentFragment();
            Text text = xPathSupport.getDOMFactory().createTextNode(this.str());
            documentFragment.appendChild(text);
        }
        return documentFragment;
    }

    public DocumentFragment rtree() {
        return null;
    }

    public Object object() {
        return this.m_obj;
    }

    public NodeList nodeset() throws SAXException {
        this.error(19, new Object[]{this.getTypeString()});
        return null;
    }

    public MutableNodeList mutableNodeset() throws SAXException {
        this.error(20, new Object[]{this.getTypeString()});
        return (MutableNodeList)this.m_obj;
    }

    public Object castToType(int n, XPathSupport xPathSupport) throws SAXException {
        Object object;
        switch (n) {
            case 3: {
                object = this.str();
                break;
            }
            case 2: {
                object = new Double(this.num());
                break;
            }
            case 4: {
                object = this.nodeset();
                break;
            }
            case 1: {
                object = new Boolean(this.bool());
                break;
            }
            case 0: {
                object = this.m_obj;
                break;
            }
            case 5: {
                object = this.rtree(xPathSupport);
                break;
            }
            default: {
                this.error(21, new Object[]{this.getTypeString(), Integer.toString(n)});
                object = null;
            }
        }
        return object;
    }

    public boolean lessThan(XObject xObject) throws SAXException {
        if (xObject.getType() == 4) {
            return xObject.greaterThan(this);
        }
        return this.num() < xObject.num();
    }

    public boolean lessThanOrEqual(XObject xObject) throws SAXException {
        if (xObject.getType() == 4) {
            return xObject.greaterThanOrEqual(this);
        }
        return this.num() <= xObject.num();
    }

    public boolean greaterThan(XObject xObject) throws SAXException {
        if (xObject.getType() == 4) {
            return xObject.lessThan(this);
        }
        return this.num() > xObject.num();
    }

    public boolean greaterThanOrEqual(XObject xObject) throws SAXException {
        if (xObject.getType() == 4) {
            return xObject.lessThanOrEqual(this);
        }
        return this.num() >= xObject.num();
    }

    public boolean equals(XObject xObject) throws SAXException {
        if (xObject.getType() == 4) {
            return xObject.equals(this);
        }
        return this.m_obj.equals(xObject.m_obj);
    }

    protected void error(int n) throws SAXException {
        this.error(n, null);
    }

    protected void error(int n, Object[] objectArray) throws SAXException {
        String string = XSLMessages.createXPATHMessage(n, objectArray);
        throw new XPathException(string);
    }
}

