/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xpath;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;
import org.apache.xalan.xpath.FoundIndex;
import org.apache.xalan.xpath.FuncLoader;
import org.apache.xalan.xpath.Function;
import org.apache.xalan.xpath.MutableNodeList;
import org.apache.xalan.xpath.SimpleNodeLocator;
import org.apache.xalan.xpath.XBoolean;
import org.apache.xalan.xpath.XBooleanStatic;
import org.apache.xalan.xpath.XLocator;
import org.apache.xalan.xpath.XNodeSet;
import org.apache.xalan.xpath.XNull;
import org.apache.xalan.xpath.XNumber;
import org.apache.xalan.xpath.XObject;
import org.apache.xalan.xpath.XPathException;
import org.apache.xalan.xpath.XPathProcessorImpl;
import org.apache.xalan.xpath.XPathSupport;
import org.apache.xalan.xpath.XRTreeFrag;
import org.apache.xalan.xpath.XString;
import org.apache.xalan.xpath.dtm.DTM;
import org.apache.xalan.xpath.dtm.DTMNodeLocator;
import org.apache.xalan.xpath.xml.PrefixResolver;
import org.apache.xalan.xpath.xml.ProblemListener;
import org.apache.xalan.xpath.xml.ProblemListenerDefault;
import org.apache.xalan.xpath.xml.QName;
import org.apache.xalan.xpath.xml.XSLMessages;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class XPath
implements Serializable {
    public static XBoolean m_true = new XBooleanStatic(true);
    public static XBoolean m_false = new XBooleanStatic(false);
    public String m_currentPattern;
    public static final int MAXTOKENQUEUESIZE = 500;
    public Object[] m_tokenQueue = new Object[500];
    public int m_tokenQueueSize;
    public int[] m_opMap = new int[1500];
    public static final int MAPINDEX_LENGTH = 1;
    public static final boolean m_debug = false;
    private ProblemListener m_problemListener;
    public static final boolean m_trace = false;
    public static final double MATCH_SCORE_NONE = Double.NEGATIVE_INFINITY;
    public static final double MATCH_SCORE_QNAME = 0.0;
    public static final double MATCH_SCORE_NSWILD = -0.25;
    public static final double MATCH_SCORE_NODETEST = -0.5;
    public static final double MATCH_SCORE_OTHER = 0.5;
    public static final int ENDOP = -1;
    public static final int EMPTY = -2;
    public static final int ELEMWILDCARD = -3;
    public static final int OP_XPATH = 1;
    public static final int OP_OR = 2;
    public static final int OP_AND = 3;
    public static final int OP_NOTEQUALS = 4;
    public static final int OP_EQUALS = 5;
    public static final int OP_LTE = 6;
    public static final int OP_LT = 7;
    public static final int OP_GTE = 8;
    public static final int OP_GT = 9;
    public static final int OP_PLUS = 10;
    public static final int OP_MINUS = 11;
    public static final int OP_MULT = 12;
    public static final int OP_DIV = 13;
    public static final int OP_MOD = 14;
    public static final int OP_QUO = 15;
    public static final int OP_NEG = 16;
    public static final int OP_STRING = 17;
    public static final int OP_BOOL = 18;
    public static final int OP_NUMBER = 19;
    public static final int OP_UNION = 20;
    public static final int OP_LITERAL = 21;
    public static final int OP_VARIABLE = 22;
    public static final int OP_GROUP = 23;
    public static final int OP_NUMBERLIT = 24;
    public static final int OP_ARGUMENT = 25;
    public static final int OP_LOCATIONPATH = 28;
    public static final int OP_PREDICATE = 29;
    public static final int NODETYPE_COMMENT = 1030;
    public static final int NODETYPE_TEXT = 1031;
    public static final int NODETYPE_PI = 1032;
    public static final int NODETYPE_NODE = 1033;
    public static final int NODENAME = 34;
    public static final int NODETYPE_ROOT = 35;
    public static final int NODETYPE_ANYELEMENT = 36;
    public static final int FROM_ANCESTORS = 37;
    public static final int FROM_ANCESTORS_OR_SELF = 38;
    public static final int FROM_ATTRIBUTES = 39;
    public static final int FROM_CHILDREN = 40;
    public static final int FROM_DESCENDANTS = 41;
    public static final int FROM_DESCENDANTS_OR_SELF = 42;
    public static final int FROM_FOLLOWING = 43;
    public static final int FROM_FOLLOWING_SIBLINGS = 44;
    public static final int FROM_PARENT = 45;
    public static final int FROM_PRECEDING = 46;
    public static final int FROM_PRECEDING_SIBLINGS = 47;
    public static final int FROM_SELF = 48;
    public static final int FROM_NAMESPACE = 49;
    public static final int FROM_ROOT = 55;
    public static final int FUNC_CURRENT = 0;
    public static final int FUNC_LAST = 1;
    public static final int FUNC_POSITION = 2;
    public static final int FUNC_COUNT = 3;
    public static final int FUNC_ID = 4;
    public static final int FUNC_KEY = 5;
    public static final int FUNC_LOCAL_PART = 7;
    public static final int FUNC_NAMESPACE = 8;
    public static final int FUNC_QNAME = 9;
    public static final int FUNC_GENERATE_ID = 10;
    public static final int FUNC_NOT = 11;
    public static final int FUNC_TRUE = 12;
    public static final int FUNC_FALSE = 13;
    public static final int FUNC_BOOLEAN = 14;
    public static final int FUNC_NUMBER = 15;
    public static final int FUNC_FLOOR = 16;
    public static final int FUNC_CEILING = 17;
    public static final int FUNC_ROUND = 18;
    public static final int FUNC_SUM = 19;
    public static final int FUNC_STRING = 20;
    public static final int FUNC_STARTS_WITH = 21;
    public static final int FUNC_CONTAINS = 22;
    public static final int FUNC_SUBSTRING_BEFORE = 23;
    public static final int FUNC_SUBSTRING_AFTER = 24;
    public static final int FUNC_NORMALIZE_SPACE = 25;
    public static final int FUNC_TRANSLATE = 26;
    public static final int FUNC_CONCAT = 27;
    public static final int FUNC_SUBSTRING = 29;
    public static final int FUNC_STRING_LENGTH = 30;
    public static final int FUNC_SYSTEM_PROPERTY = 31;
    public static final int FUNC_LANG = 32;
    public static final int FUNC_EXT_FUNCTION_AVAILABLE = 33;
    public static final int FUNC_EXT_ELEM_AVAILABLE = 34;
    public static final int FUNC_DOCLOCATION = 35;
    public static final int FUNC_UNPARSED_ENTITY_URI = 36;
    private static final int NUM_BUILT_IN_FUNCS = 37;
    private static final int NUM_ALLOWABLE_ADDINS = 30;
    private static Function[] m_functions;
    private static int m_funcNextFreeIndex;
    public static final int OP_EXTFUNCTION = 26;
    public static final int OP_FUNCTION = 27;
    public static final int OP_MATCHPATTERN = 92;
    public static final int OP_LOCATIONPATHPATTERN = 93;
    public static final int MATCH_ATTRIBUTE = 94;
    public static final int MATCH_ANY_ANCESTOR = 95;
    public static final int MATCH_IMMEDIATE_ANCESTOR = 96;
    public static final String PSEUDONAME_ANY = "*";
    public static final String PSEUDONAME_ROOT = "/";
    public static final String PSEUDONAME_TEXT = "#text";
    public static final String PSEUDONAME_COMMENT = "#comment";
    public static final String PSEUDONAME_PI = "#pi";
    public static final String PSEUDONAME_OTHER = "*";
    public static final int NEXT_FREE_ID = 99;
    public int[] m_patternMap = new int[100];
    public int m_patternMapSize;

    private void ____API____() {
    }

    public XPath(XPathSupport xPathSupport, ProblemListener problemListener) {
        this.m_problemListener = problemListener;
    }

    public XPath(ProblemListener problemListener) {
        this.m_problemListener = problemListener;
    }

    public XPath() {
        this.m_problemListener = new ProblemListenerDefault();
    }

    public void setProblemListener(ProblemListener problemListener) {
        this.m_problemListener = problemListener;
    }

    public ProblemListener getProblemListener() {
        return this.m_problemListener;
    }

    public XLocator createXLocatorHandler(XPath xPath) {
        return new SimpleNodeLocator();
    }

    public XLocator createXLocatorHandler(XPathSupport xPathSupport) {
        return xPathSupport.createXLocatorHandler();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            objectInputStream.defaultReadObject();
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("In XPath.readObject: " + classNotFoundException.getMessage());
        }
    }

    public XObject execute(XPathSupport xPathSupport, Node node, PrefixResolver prefixResolver) throws SAXException {
        PrefixResolver prefixResolver2 = xPathSupport.getNamespaceContext();
        xPathSupport.setNamespaceContext(prefixResolver);
        xPathSupport.setCurrentNode(node);
        XObject xObject = null;
        try {
            xObject = this.execute(xPathSupport, node, 0);
        }
        finally {
            Object var7_6 = null;
            xPathSupport.setNamespaceContext(prefixResolver2);
            xPathSupport.setCurrentNode(null);
        }
        return xObject;
    }

    public double getMatchScore(XPathSupport xPathSupport, Node node) throws SAXException {
        double d = Double.NEGATIVE_INFINITY;
        int n = 0;
        if (this.m_opMap[n] == 92) {
            n = XPath.getFirstChildPos(n);
            XLocator xLocator = xPathSupport.getXLocatorFromNode(node);
            if (xLocator == null) {
                xLocator = xPathSupport.createXLocatorHandler();
            }
            while (this.m_opMap[n] == 93) {
                int n2 = this.getNextOpPos(n);
                d = xLocator.locationPathPattern(this, xPathSupport, node, n);
                if (d == Double.NEGATIVE_INFINITY) {
                    n = n2;
                    continue;
                }
                break;
            }
        } else {
            this.error(node, 22);
        }
        return d;
    }

    public double getMatchScore(XPathSupport xPathSupport, DTM dTM, int n) throws SAXException {
        double d = Double.NEGATIVE_INFINITY;
        int n2 = 0;
        if (this.m_opMap[n2] == 92) {
            n2 = XPath.getFirstChildPos(n2);
            XLocator xLocator = xPathSupport.getXLocatorFromNode(dTM.getDocument());
            if (xLocator == null) {
                xLocator = xPathSupport.createXLocatorHandler();
            }
            DTMNodeLocator dTMNodeLocator = (DTMNodeLocator)xLocator;
            while (this.m_opMap[n2] == 93) {
                int n3 = this.getNextOpPos(n2);
                d = dTMNodeLocator.locationPathPattern(this, xPathSupport, dTM, n, n2);
                if (d == Double.NEGATIVE_INFINITY) {
                    n2 = n3;
                    continue;
                }
                break;
            }
        } else {
            this.error(dTM.getNode(n), 22);
        }
        return d;
    }

    int getCountOfContextNodeList(XPathSupport xPathSupport) {
        if (xPathSupport.getThrowFoundIndex()) {
            throw new FoundIndex();
        }
        return xPathSupport.getContextNodeList().getLength();
    }

    int getPositionInContextNodeList(Node node, XPathSupport xPathSupport) {
        if (xPathSupport.getThrowFoundIndex()) {
            throw new FoundIndex();
        }
        int n = -1;
        if (xPathSupport.getContextNodeList() != null) {
            int n2 = xPathSupport.getContextNodeList().getLength();
            int n3 = 0;
            while (n3 < n2) {
                Node node2 = xPathSupport.getContextNodeList().item(n3);
                if (node2 != null && node2.equals(node)) {
                    n = n3 + 1;
                    break;
                }
                ++n3;
            }
        }
        return n;
    }

    public void shrink() {
        int[] nArray = this.m_opMap;
        int n = this.m_opMap[1];
        this.m_opMap = new int[n + 4];
        int n2 = 0;
        while (n2 < n) {
            this.m_opMap[n2] = nArray[n2];
            ++n2;
        }
        this.m_opMap[n2] = 0;
        this.m_opMap[n2 + 1] = 0;
        this.m_opMap[n2 + 2] = 0;
        nArray = this.m_patternMap;
        n = this.m_patternMapSize;
        this.m_patternMap = new int[n + 4];
        n2 = 0;
        while (n2 < n) {
            this.m_patternMap[n2] = nArray[n2];
            ++n2;
        }
        this.m_patternMap[n2] = 0;
        this.m_patternMap[n2 + 1] = 0;
        this.m_patternMap[n2 + 2] = 0;
        Object[] objectArray = this.m_tokenQueue;
        n = this.m_tokenQueueSize;
        this.m_tokenQueue = new Object[n + 4];
        n2 = 0;
        while (n2 < n) {
            this.m_tokenQueue[n2] = objectArray[n2];
            ++n2;
        }
        this.m_tokenQueue[n2] = null;
        this.m_tokenQueue[n2 + 1] = null;
        this.m_tokenQueue[n2 + 2] = null;
    }

    public void installFunction(String string, int n, Function function) {
        XPath.m_functions[n] = function;
    }

    public static int installFunction(String string, Function function) {
        int n;
        Object v = XPathProcessorImpl.m_functions.get(string);
        if (v != null) {
            n = (Integer)v;
        } else {
            n = m_funcNextFreeIndex++;
            XPathProcessorImpl.m_functions.put(string, new Integer(n));
        }
        XPath.m_functions[n] = function;
        return n;
    }

    private void ____EVALUATION____() {
    }

    protected XObject xpath(XPathSupport xPathSupport, Node node, int n) throws SAXException {
        return this.execute(xPathSupport, node, n + 2);
    }

    protected XBoolean or(XPathSupport xPathSupport, Node node, int n) throws SAXException {
        XObject xObject;
        n = XPath.getFirstChildPos(n);
        int n2 = this.getNextOpPos(n);
        XObject xObject2 = this.execute(xPathSupport, node, n);
        XBoolean xBoolean = !xObject2.bool() ? (!(xObject = this.execute(xPathSupport, node, n2)).bool() ? new XBoolean(false) : new XBoolean(true)) : new XBoolean(true);
        return xBoolean;
    }

    protected XBoolean and(XPathSupport xPathSupport, Node node, int n) throws SAXException {
        n = XPath.getFirstChildPos(n);
        int n2 = this.getNextOpPos(n);
        XObject xObject = this.execute(xPathSupport, node, n);
        if (xObject.bool()) {
            XObject xObject2 = this.execute(xPathSupport, node, n2);
            if (xObject2.bool()) {
                return m_true;
            }
            return m_false;
        }
        return m_false;
    }

    protected XBoolean notequals(XPathSupport xPathSupport, Node node, int n) throws SAXException {
        XObject xObject;
        n = XPath.getFirstChildPos(n);
        int n2 = this.getNextOpPos(n);
        XObject xObject2 = this.execute(xPathSupport, node, n);
        if (!xObject2.equals(xObject = this.execute(xPathSupport, node, n2))) {
            return m_true;
        }
        return m_false;
    }

    protected XBoolean equals(XPathSupport xPathSupport, Node node, int n) throws SAXException {
        XObject xObject;
        n = XPath.getFirstChildPos(n);
        int n2 = this.getNextOpPos(n);
        XObject xObject2 = this.execute(xPathSupport, node, n);
        if (xObject2.equals(xObject = this.execute(xPathSupport, node, n2))) {
            return m_true;
        }
        return m_false;
    }

    protected XBoolean lte(XPathSupport xPathSupport, Node node, int n) throws SAXException {
        XObject xObject;
        n = XPath.getFirstChildPos(n);
        int n2 = this.getNextOpPos(n);
        XObject xObject2 = this.execute(xPathSupport, node, n);
        if (xObject2.lessThanOrEqual(xObject = this.execute(xPathSupport, node, n2))) {
            return m_true;
        }
        return m_false;
    }

    protected XBoolean lt(XPathSupport xPathSupport, Node node, int n) throws SAXException {
        XObject xObject;
        n = XPath.getFirstChildPos(n);
        int n2 = this.getNextOpPos(n);
        XObject xObject2 = this.execute(xPathSupport, node, n);
        if (xObject2.lessThan(xObject = this.execute(xPathSupport, node, n2))) {
            return m_true;
        }
        return m_false;
    }

    protected XBoolean gte(XPathSupport xPathSupport, Node node, int n) throws SAXException {
        XObject xObject;
        n = XPath.getFirstChildPos(n);
        int n2 = this.getNextOpPos(n);
        XObject xObject2 = this.execute(xPathSupport, node, n);
        if (xObject2.greaterThanOrEqual(xObject = this.execute(xPathSupport, node, n2))) {
            return m_true;
        }
        return m_false;
    }

    protected XBoolean gt(XPathSupport xPathSupport, Node node, int n) throws SAXException {
        XObject xObject;
        n = XPath.getFirstChildPos(n);
        int n2 = this.getNextOpPos(n);
        XObject xObject2 = this.execute(xPathSupport, node, n);
        if (xObject2.greaterThan(xObject = this.execute(xPathSupport, node, n2))) {
            return m_true;
        }
        return m_false;
    }

    protected XNumber plus(XPathSupport xPathSupport, Node node, int n) throws SAXException {
        n = XPath.getFirstChildPos(n);
        int n2 = this.getNextOpPos(n);
        XObject xObject = this.execute(xPathSupport, node, n);
        XObject xObject2 = this.execute(xPathSupport, node, n2);
        return new XNumber(xObject.num() + xObject2.num());
    }

    protected XNumber minus(XPathSupport xPathSupport, Node node, int n) throws SAXException {
        n = XPath.getFirstChildPos(n);
        int n2 = this.getNextOpPos(n);
        XObject xObject = this.execute(xPathSupport, node, n);
        XObject xObject2 = this.execute(xPathSupport, node, n2);
        return new XNumber(xObject.num() - xObject2.num());
    }

    protected XNumber mult(XPathSupport xPathSupport, Node node, int n) throws SAXException {
        n = XPath.getFirstChildPos(n);
        int n2 = this.getNextOpPos(n);
        XObject xObject = this.execute(xPathSupport, node, n);
        XObject xObject2 = this.execute(xPathSupport, node, n2);
        return new XNumber(xObject.num() * xObject2.num());
    }

    protected XNumber div(XPathSupport xPathSupport, Node node, int n) throws SAXException {
        n = XPath.getFirstChildPos(n);
        int n2 = this.getNextOpPos(n);
        XObject xObject = this.execute(xPathSupport, node, n);
        XObject xObject2 = this.execute(xPathSupport, node, n2);
        return new XNumber(xObject.num() / xObject2.num());
    }

    protected XNumber mod(XPathSupport xPathSupport, Node node, int n) throws SAXException {
        n = XPath.getFirstChildPos(n);
        int n2 = this.getNextOpPos(n);
        XObject xObject = this.execute(xPathSupport, node, n);
        XObject xObject2 = this.execute(xPathSupport, node, n2);
        return new XNumber(xObject.num() % xObject2.num());
    }

    protected XNumber quo(XPathSupport xPathSupport, Node node, int n) throws SAXException {
        this.warn(5);
        n = XPath.getFirstChildPos(n);
        int n2 = this.getNextOpPos(n);
        XObject xObject = this.execute(xPathSupport, node, n);
        XObject xObject2 = this.execute(xPathSupport, node, n2);
        return new XNumber((int)(xObject.num() / xObject2.num()));
    }

    protected XNumber neg(XPathSupport xPathSupport, Node node, int n) throws SAXException {
        XObject xObject = this.execute(xPathSupport, node, n + 2);
        return new XNumber(-xObject.num());
    }

    protected XString string(XPathSupport xPathSupport, Node node, int n) throws SAXException {
        XObject xObject = this.execute(xPathSupport, node, n + 2);
        return new XString(xObject.str());
    }

    protected XBoolean bool(XPathSupport xPathSupport, Node node, int n) throws SAXException {
        XObject xObject = this.execute(xPathSupport, node, n + 2);
        if (xObject.bool()) {
            return m_true;
        }
        return m_false;
    }

    protected XNumber number(XPathSupport xPathSupport, Node node, int n) throws SAXException {
        XObject xObject = this.execute(xPathSupport, node, n + 2);
        return new XNumber(xObject.num());
    }

    protected XNodeSet union(XPathSupport xPathSupport, Node node, int n) throws SAXException {
        XLocator xLocator = xPathSupport.getXLocatorFromNode(node);
        if (xLocator == null) {
            xLocator = xPathSupport.createXLocatorHandler();
        }
        XNodeSet xNodeSet = xLocator.union(this, xPathSupport, node, n);
        return xNodeSet;
    }

    protected XString literal(XPathSupport xPathSupport, Node node, int n) {
        n = XPath.getFirstChildPos(n);
        return (XString)this.m_tokenQueue[this.m_opMap[n]];
    }

    protected XObject variable(XPathSupport xPathSupport, Node node, int n) throws SAXException {
        XObject xObject;
        n = XPath.getFirstChildPos(n);
        String string = (String)this.m_tokenQueue[this.m_opMap[n]];
        QName qName = new QName(string, xPathSupport.getNamespaceContext());
        try {
            xObject = xPathSupport.getVariable(qName);
        }
        catch (Exception exception) {
            this.error(23, new Object[]{string});
            xObject = null;
        }
        if (xObject == null) {
            this.warn(node, 6, new Object[]{string});
        }
        return xObject;
    }

    protected XObject group(XPathSupport xPathSupport, Node node, int n) throws SAXException {
        return this.execute(xPathSupport, node, n + 2);
    }

    protected XNumber numberlit(XPathSupport xPathSupport, Node node, int n) {
        n = XPath.getFirstChildPos(n);
        return (XNumber)this.m_tokenQueue[this.m_opMap[n]];
    }

    protected XObject arg(XPathSupport xPathSupport, Node node, int n) throws SAXException {
        return this.execute(xPathSupport, node, n + 2);
    }

    public Node getRoot(XPathSupport xPathSupport, Node node) {
        Node node2 = null;
        while (node != null) {
            node2 = node;
            node = xPathSupport.getParentOfNode(node);
        }
        return node2;
    }

    public XNodeSet locationPath(XPathSupport xPathSupport, Node node, int n) throws SAXException {
        XLocator xLocator = xPathSupport.getXLocatorFromNode(node);
        if (xLocator == null) {
            xLocator = xPathSupport.createXLocatorHandler();
        }
        XNodeSet xNodeSet = xLocator.locationPath(this, xPathSupport, node, n);
        return xNodeSet;
    }

    public XObject predicate(XPathSupport xPathSupport, Node node, int n) throws SAXException {
        XObject xObject = this.execute(xPathSupport, node, n + 2);
        int n2 = xObject.getType();
        if (n2 != 2 && n2 != 1) {
            xObject = xObject.bool() ? m_true : m_false;
        }
        return xObject;
    }

    public double nodeTest(XPathSupport xPathSupport, Node node, int n, int n2, int n3) throws SAXException {
        this.warn(node, 7);
        return Double.NEGATIVE_INFINITY;
    }

    protected MutableNodeList step(XPathSupport xPathSupport, Node node, int n) throws SAXException {
        this.warn(node, 7);
        return null;
    }

    protected XObject extfunction(XPathSupport xPathSupport, Node node, int n, String string, String string2, Vector vector) throws SAXException {
        XObject xObject;
        Object object = xPathSupport.extFunction(string, string2, vector);
        if (object != null) {
            if (object instanceof XLocator) {
                XLocator xLocator = (XLocator)object;
                n = this.getNextOpPos(n + 1);
                xObject = xLocator.connectToNodes(this, xPathSupport, node, n, vector);
            } else if (object instanceof XObject) {
                xObject = (XObject)object;
            } else if (object instanceof String) {
                xObject = new XString((String)object);
            } else if (object instanceof Boolean) {
                xObject = (Boolean)object != false ? m_true : m_false;
            } else if (object instanceof Double) {
                xObject = new XNumber((Double)object);
            } else if (object instanceof DocumentFragment) {
                xObject = new XRTreeFrag((DocumentFragment)object);
            } else if (object instanceof Node) {
                n = this.getNextOpPos(n);
                XNodeSet xNodeSet = null;
                if (n < this.m_opMap[1] && this.m_opMap[n] == 28) {
                    xNodeSet = this.locationPath(xPathSupport, (Node)object, n);
                }
                xObject = xNodeSet == null ? new XNodeSet((Node)object) : xNodeSet;
            } else if (object instanceof NodeList) {
                n = this.getNextOpPos(n);
                XNodeSet xNodeSet = null;
                if (n < this.m_opMap[1] && this.m_opMap[n] == 28) {
                    NodeList nodeList = (NodeList)object;
                    int n2 = nodeList.getLength();
                    int n3 = 0;
                    while (n3 < n2) {
                        XNodeSet xNodeSet2 = this.locationPath(xPathSupport, nodeList.item(n3), n);
                        if (xNodeSet2 == null) {
                            xNodeSet = xNodeSet2;
                        } else {
                            xNodeSet.mutableNodeset().addNodes(xNodeSet2.nodeset());
                        }
                        ++n3;
                    }
                }
                xObject = xNodeSet == null ? new XNodeSet((NodeList)object) : xNodeSet;
            } else {
                xObject = new XObject(object);
            }
        } else {
            xObject = new XNull();
        }
        return xObject;
    }

    protected XObject function(XPathSupport xPathSupport, Node node, int n, int n2, Vector vector) throws SAXException {
        return m_functions[n2].execute(this, xPathSupport, node, n, vector);
    }

    protected XObject matchPattern(XPathSupport xPathSupport, Node node, int n) throws SAXException {
        XObject xObject = null;
        while (this.m_opMap[n] == 93) {
            int n2 = this.getNextOpPos(n);
            xObject = this.execute(xPathSupport, node, n);
            if (xObject.num() != Double.NEGATIVE_INFINITY) break;
            n = n2;
        }
        if (xObject == null) {
            xObject = new XNumber(Double.NEGATIVE_INFINITY);
        }
        return xObject;
    }

    protected XNumber locationPathPattern(XPathSupport xPathSupport, Node node, int n) throws SAXException {
        XLocator xLocator = xPathSupport.getXLocatorFromNode(node);
        if (xLocator == null) {
            xLocator = xPathSupport.createXLocatorHandler();
        }
        double d = xLocator.locationPathPattern(this, xPathSupport, node, n);
        return new XNumber(d);
    }

    public Vector getTargetElementStrings() {
        Vector<String> vector = new Vector<String>();
        int n = 2;
        while (this.m_opMap[n] == 93) {
            int n2 = this.getNextOpPos(n);
            n = XPath.getFirstChildPos(n);
            while (this.m_opMap[n] != -1) {
                int n3 = this.getNextOpPos(n);
                int n4 = this.m_opMap[n3];
                if (n4 == 29 || n4 == -1) {
                    int n5 = this.m_opMap[n];
                    n += 3;
                    block0 : switch (n5) {
                        case 27: {
                            vector.addElement("*");
                            break;
                        }
                        case 55: {
                            vector.addElement(PSEUDONAME_ROOT);
                            break;
                        }
                        case 94: 
                        case 95: 
                        case 96: {
                            int n6 = this.m_opMap[n];
                            ++n;
                            switch (n6) {
                                case 1030: {
                                    vector.addElement(PSEUDONAME_COMMENT);
                                    break block0;
                                }
                                case 1031: {
                                    vector.addElement(PSEUDONAME_TEXT);
                                    break block0;
                                }
                                case 1033: {
                                    vector.addElement("*");
                                    break block0;
                                }
                                case 35: {
                                    vector.addElement(PSEUDONAME_ROOT);
                                    break block0;
                                }
                                case 36: {
                                    vector.addElement("*");
                                    break block0;
                                }
                                case 1032: {
                                    vector.addElement("*");
                                    break block0;
                                }
                                case 34: {
                                    int n7 = this.m_opMap[n + 1];
                                    if (n7 >= 0) {
                                        String string = (String)this.m_tokenQueue[n7];
                                        if (string.equals("*")) {
                                            vector.addElement("*");
                                            break block0;
                                        }
                                        vector.addElement(string);
                                        break block0;
                                    }
                                    vector.addElement("*");
                                    break block0;
                                }
                            }
                            vector.addElement("*");
                            break;
                        }
                    }
                }
                n = n3;
            }
            n = n2;
        }
        return vector;
    }

    public XObject execute(XPathSupport xPathSupport, Node node, int n) throws SAXException {
        XObject xObject = null;
        switch (this.m_opMap[n]) {
            case 1: {
                xObject = this.execute(xPathSupport, node, n + 2);
                break;
            }
            case 92: {
                xObject = this.matchPattern(xPathSupport, node, n + 2);
                break;
            }
            case -2: {
                ++n;
                break;
            }
            case 2: {
                xObject = this.or(xPathSupport, node, n);
                break;
            }
            case 3: {
                xObject = this.and(xPathSupport, node, n);
                break;
            }
            case 4: {
                xObject = this.notequals(xPathSupport, node, n);
                break;
            }
            case 5: {
                xObject = this.equals(xPathSupport, node, n);
                break;
            }
            case 6: {
                xObject = this.lte(xPathSupport, node, n);
                break;
            }
            case 7: {
                xObject = this.lt(xPathSupport, node, n);
                break;
            }
            case 8: {
                xObject = this.gte(xPathSupport, node, n);
                break;
            }
            case 9: {
                xObject = this.gt(xPathSupport, node, n);
                break;
            }
            case 10: {
                xObject = this.plus(xPathSupport, node, n);
                break;
            }
            case 11: {
                xObject = this.minus(xPathSupport, node, n);
                break;
            }
            case 12: {
                xObject = this.mult(xPathSupport, node, n);
                break;
            }
            case 13: {
                xObject = this.div(xPathSupport, node, n);
                break;
            }
            case 14: {
                xObject = this.mod(xPathSupport, node, n);
                break;
            }
            case 15: {
                xObject = this.quo(xPathSupport, node, n);
                break;
            }
            case 16: {
                xObject = this.neg(xPathSupport, node, n);
                break;
            }
            case 17: {
                xObject = this.string(xPathSupport, node, n);
                break;
            }
            case 18: {
                xObject = this.bool(xPathSupport, node, n);
                break;
            }
            case 19: {
                xObject = this.number(xPathSupport, node, n);
                break;
            }
            case 20: {
                xObject = this.union(xPathSupport, node, n);
                break;
            }
            case 21: {
                xObject = this.literal(xPathSupport, node, n);
                break;
            }
            case 22: {
                xObject = this.variable(xPathSupport, node, n);
                break;
            }
            case 23: {
                xObject = this.group(xPathSupport, node, n);
                break;
            }
            case 24: {
                xObject = this.numberlit(xPathSupport, node, n);
                break;
            }
            case 25: {
                xObject = this.arg(xPathSupport, node, n);
                break;
            }
            case 26: {
                int n2 = n + this.m_opMap[n + 1] - 1;
                n = XPath.getFirstChildPos(n);
                String string = (String)this.m_tokenQueue[this.m_opMap[n]];
                String string2 = (String)this.m_tokenQueue[this.m_opMap[++n]];
                ++n;
                Vector<XObject> vector = new Vector<XObject>();
                while (n < n2) {
                    int n3 = this.getNextOpPos(n);
                    vector.addElement(this.execute(xPathSupport, node, n));
                    n = n3;
                }
                xObject = this.extfunction(xPathSupport, node, n, string, string2, vector);
                break;
            }
            case 27: {
                int n4 = n + this.m_opMap[n + 1] - 1;
                n = XPath.getFirstChildPos(n);
                int n5 = this.m_opMap[n];
                ++n;
                Vector<XObject> vector = new Vector<XObject>();
                while (n < n4) {
                    int n6 = this.getNextOpPos(n);
                    vector.addElement(this.execute(xPathSupport, node, n));
                    n = n6;
                }
                if (n5 != -1) {
                    xObject = this.function(xPathSupport, node, n, n5, vector);
                    break;
                }
                this.warn(8);
                break;
            }
            case 28: {
                xObject = this.locationPath(xPathSupport, node, n);
                break;
            }
            case 93: {
                xObject = this.locationPathPattern(xPathSupport, node, n);
                break;
            }
            default: {
                this.error(node, 24, new Object[]{Integer.toString(this.m_opMap[n])});
            }
        }
        return xObject;
    }

    private void ____OPCODE_POSITION_HELPER_FUNCTIONS____() {
    }

    public int getOp(int n) {
        return this.m_opMap[n];
    }

    public int getNextOpPos(int n) {
        return n + this.m_opMap[n + 1];
    }

    public static int getNextOpPos(int[] nArray, int n) {
        return n + nArray[n + 1];
    }

    public static int getFirstChildPos(int n) {
        return n + 2;
    }

    public int getArgLengthOfStep(int n) {
        return this.m_opMap[n + 1 + 1] - 3;
    }

    public static int getFirstChildPosOfStep(int n) {
        return n + 3;
    }

    private void ____DIAGNOSTICS_AND_ERRORS____() {
    }

    private final void trace(String string) {
        System.out.println(string);
    }

    public void warn(int n) throws SAXException {
        this.warn(null, n, null);
    }

    public void warn(int n, Object[] objectArray) throws SAXException {
        this.warn(null, n, objectArray);
    }

    public void warn(Node node, int n) throws SAXException {
        this.warn(node, n, null);
    }

    public void warn(Node node, int n, Object[] objectArray) throws SAXException {
        String string = XSLMessages.createXPATHWarning(n, objectArray);
        boolean bl = this.m_problemListener.problem((short)4, (short)1, null, node, string, null, 0, 0);
        if (bl) {
            throw new XPathException(string);
        }
    }

    private void assert(boolean bl, String string) throws SAXException {
        if (!bl) {
            this.error(null, 25, new Object[]{string});
        }
    }

    public void error(int n) throws SAXException {
        this.error(null, n, null);
    }

    public void error(int n, Object[] objectArray) throws SAXException {
        this.error(null, n, objectArray);
    }

    public void error(Node node, int n) throws SAXException {
        this.error(node, n, null);
    }

    public void error(Node node, int n, Object[] objectArray) throws SAXException {
        String string = XSLMessages.createXPATHMessage(n, objectArray);
        String string2 = String.valueOf(this.m_currentPattern != null ? "pattern = '" + this.m_currentPattern + "'\n" : "") + string;
        boolean bl = this.m_problemListener.problem((short)4, (short)2, null, node, string2, null, 0, 0);
        if (bl) {
            throw new XPathException(string2);
        }
    }

    private void ____CONSTANTS____() {
    }

    private void ____IGNORE____() {
    }

    static {
        m_funcNextFreeIndex = 37;
        m_functions = new Function[67];
        XPath.m_functions[0] = new FuncLoader("FuncCurrent", 0);
        XPath.m_functions[1] = new FuncLoader("FuncLast", 1);
        XPath.m_functions[2] = new FuncLoader("FuncPosition", 2);
        XPath.m_functions[3] = new FuncLoader("FuncCount", 3);
        XPath.m_functions[4] = new FuncLoader("FuncId", 4);
        XPath.m_functions[5] = new FuncLoader("FuncKey", 5);
        XPath.m_functions[7] = new FuncLoader("FuncLocalPart", 7);
        XPath.m_functions[8] = new FuncLoader("FuncNamespace", 8);
        XPath.m_functions[9] = new FuncLoader("FuncQname", 9);
        XPath.m_functions[10] = new FuncLoader("FuncGenerateId", 10);
        XPath.m_functions[11] = new FuncLoader("FuncNot", 11);
        XPath.m_functions[12] = new FuncLoader("FuncTrue", 12);
        XPath.m_functions[13] = new FuncLoader("FuncFalse", 13);
        XPath.m_functions[14] = new FuncLoader("FuncBoolean", 14);
        XPath.m_functions[32] = new FuncLoader("FuncLang", 32);
        XPath.m_functions[15] = new FuncLoader("FuncNumber", 15);
        XPath.m_functions[16] = new FuncLoader("FuncFloor", 16);
        XPath.m_functions[17] = new FuncLoader("FuncCeiling", 17);
        XPath.m_functions[18] = new FuncLoader("FuncRound", 18);
        XPath.m_functions[19] = new FuncLoader("FuncSum", 19);
        XPath.m_functions[20] = new FuncLoader("FuncString", 20);
        XPath.m_functions[21] = new FuncLoader("FuncStartsWith", 21);
        XPath.m_functions[22] = new FuncLoader("FuncContains", 22);
        XPath.m_functions[23] = new FuncLoader("FuncSubstringBefore", 23);
        XPath.m_functions[24] = new FuncLoader("FuncSubstringAfter", 24);
        XPath.m_functions[25] = new FuncLoader("FuncNormalizeSpace", 25);
        XPath.m_functions[26] = new FuncLoader("FuncTranslate", 26);
        XPath.m_functions[27] = new FuncLoader("FuncConcat", 27);
        XPath.m_functions[31] = new FuncLoader("FuncSystemProperty", 31);
        XPath.m_functions[33] = new FuncLoader("FuncExtFunctionAvailable", 33);
        XPath.m_functions[34] = new FuncLoader("FuncExtElementAvailable", 34);
        XPath.m_functions[29] = new FuncLoader("FuncSubstring", 29);
        XPath.m_functions[30] = new FuncLoader("FuncStringLength", 30);
        XPath.m_functions[35] = new FuncLoader("FuncDoclocation", 35);
        XPath.m_functions[36] = new FuncLoader("FuncUnparsedEntityURI", 36);
    }
}

