/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xpath;

import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.xalan.xpath.XNumber;
import org.apache.xalan.xpath.XPath;
import org.apache.xalan.xpath.XPathProcessor;
import org.apache.xalan.xpath.XPathProcessorException;
import org.apache.xalan.xpath.XPathSupport;
import org.apache.xalan.xpath.XPathSupportDefault;
import org.apache.xalan.xpath.XString;
import org.apache.xalan.xpath.xml.PrefixResolver;
import org.apache.xalan.xpath.xml.ProblemListenerDefault;
import org.apache.xalan.xpath.xml.StringKey;
import org.apache.xalan.xpath.xml.XSLMessages;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class XPathProcessorImpl
implements XPathProcessor {
    private XPath m_xpath;
    private XPathSupport m_support;
    private String m_token;
    private char m_tokenChar;
    public int m_queueMark;
    Hashtable m_durationsTable = new Hashtable();
    PrefixResolver m_namespaceContext;
    public static final boolean m_debug = false;
    public static final boolean m_trace = false;
    static final int TARGETEXTRA = 10000;
    public static final String PSEUDONAME_ANY = "*";
    public static final String PSEUDONAME_ROOT = "/";
    public static final String PSEUDONAME_TEXT = "#text";
    public static final String PSEUDONAME_COMMENT = "#comment";
    public static final String PSEUDONAME_PI = "#pi";
    public static final String PSEUDONAME_OTHER = "*";
    private static Hashtable m_keywords = new Hashtable();
    private static Hashtable m_axisnames = new Hashtable();
    static Hashtable m_functions = new Hashtable();
    private static Hashtable m_nodetypes = new Hashtable();
    private static final String FROM_ANCESTORS_STRING = "ancestor";
    private static final String FROM_ANCESTORS_OR_SELF_STRING = "ancestor-or-self";
    private static final String FROM_ATTRIBUTES_STRING = "attribute";
    private static final String FROM_CHILDREN_STRING = "child";
    private static final String FROM_DESCENDANTS_STRING = "descendant";
    private static final String FROM_DESCENDANTS_OR_SELF_STRING = "descendant-or-self";
    private static final String FROM_FOLLOWING_STRING = "following";
    private static final String FROM_FOLLOWING_SIBLINGS_STRING = "following-sibling";
    private static final String FROM_PARENT_STRING = "parent";
    private static final String FROM_PRECEDING_STRING = "preceding";
    private static final String FROM_PRECEDING_SIBLINGS_STRING = "preceding-sibling";
    private static final String FROM_SELF_STRING = "self";
    private static final String FROM_NAMESPACE_STRING = "namespace";
    private static final String FROM_SELF_ABBREVIATED_STRING = ".";
    private static final String NODETYPE_COMMENT_STRING = "comment";
    private static final String NODETYPE_TEXT_STRING = "text";
    private static final String NODETYPE_PI_STRING = "processing-instruction";
    private static final String NODETYPE_NODE_STRING = "node";
    private static final String FROM_ATTRIBUTE_STRING = "@";
    private static final String FROM_DOC_STRING = "document";
    private static final String FROM_DOCREF_STRING = "document";
    private static final String FROM_ID_STRING = "id";
    private static final String FROM_IDREF_STRING = "idref";
    private static final String NODETYPE_ANYELEMENT_STRING = "*";
    private static final String FUNC_CURRENT_STRING = "current";
    private static final String FUNC_LAST_STRING = "last";
    private static final String FUNC_POSITION_STRING = "position";
    private static final String FUNC_COUNT_STRING = "count";
    private static final String FUNC_ID_STRING = "id";
    private static final String FUNC_IDREF_STRING = "idref";
    private static final String FUNC_KEY_STRING = "key";
    private static final String FUNC_KEYREF_STRING = "keyref";
    private static final String FUNC_DOC_STRING = "doc";
    private static final String FUNC_DOCUMENT_STRING = "document";
    private static final String FUNC_DOCREF_STRING = "docref";
    private static final String FUNC_LOCAL_PART_STRING = "local-name";
    private static final String FUNC_NAMESPACE_STRING = "namespace-uri";
    private static final String FUNC_NAME_STRING = "name";
    private static final String FUNC_GENERATE_ID_STRING = "generate-id";
    private static final String FUNC_NOT_STRING = "not";
    private static final String FUNC_TRUE_STRING = "true";
    private static final String FUNC_FALSE_STRING = "false";
    private static final String FUNC_BOOLEAN_STRING = "boolean";
    private static final String FUNC_LANG_STRING = "lang";
    private static final String FUNC_NUMBER_STRING = "number";
    private static final String FUNC_FLOOR_STRING = "floor";
    private static final String FUNC_CEILING_STRING = "ceiling";
    private static final String FUNC_ROUND_STRING = "round";
    private static final String FUNC_SUM_STRING = "sum";
    private static final String FUNC_STRING_STRING = "string";
    private static final String FUNC_STARTS_WITH_STRING = "starts-with";
    private static final String FUNC_CONTAINS_STRING = "contains";
    private static final String FUNC_SUBSTRING_BEFORE_STRING = "substring-before";
    private static final String FUNC_SUBSTRING_AFTER_STRING = "substring-after";
    private static final String FUNC_NORMALIZE_SPACE_STRING = "normalize-space";
    private static final String FUNC_TRANSLATE_STRING = "translate";
    private static final String FUNC_CONCAT_STRING = "concat";
    private static final String FUNC_SYSTEM_PROPERTY_STRING = "system-property";
    private static final String FUNC_EXT_FUNCTION_AVAILABLE_STRING = "function-available";
    private static final String FUNC_EXT_ELEM_AVAILABLE_STRING = "element-available";
    private static final String FUNC_SUBSTRING_STRING = "substring";
    private static final String FUNC_STRING_LENGTH_STRING = "string-length";
    private static final String FUNC_UNPARSED_ENTITY_URI_STRING = "unparsed-entity-uri";
    private static final String FUNC_DOCLOCATION_STRING = "document-location";
    private static String m_opLabel;
    private static String m_lenLabel;
    private static String m_arglenLabel;
    private static String m_noLabel;
    private static String m_nTestLabel;
    private static String m_open;
    private static String m_close;

    public XPathProcessorImpl(XPathSupport xPathSupport) {
        this.m_support = xPathSupport;
    }

    public XPathProcessorImpl() {
        this.m_support = new XPathSupportDefault();
    }

    public void pushTime(Object object) {
        if (object != null) {
            this.m_durationsTable.put(object, new Date());
        }
    }

    public long popDuration(Object object) {
        long l = 0L;
        if (object != null) {
            Date date = (Date)this.m_durationsTable.get(object);
            Date date2 = new Date();
            l = date2.getTime() - date.getTime();
            this.m_durationsTable.remove(object);
        }
        return l;
    }

    public void displayDuration(String string, Object object) {
        long l = 0L;
        if (object != null) {
            Date date = (Date)this.m_durationsTable.get(object);
            Date date2 = new Date();
            l = date2.getTime() - date.getTime();
            System.out.println(String.valueOf(string) + " took " + l + " milliseconds");
            this.m_durationsTable.remove(object);
        }
    }

    public void initXPath(XPath xPath, String string, PrefixResolver prefixResolver) throws SAXException {
        this.m_xpath = xPath;
        this.m_namespaceContext = prefixResolver;
        this.tokenize(string);
        this.m_xpath.m_opMap[0] = 1;
        this.m_xpath.m_opMap[1] = 2;
        this.nextToken();
        this.Expr();
        if (this.m_token != null) {
            String string2 = "";
            while (this.m_token != null) {
                string2 = String.valueOf(string2) + "'" + this.m_token + "'";
                this.nextToken();
                if (this.m_token == null) continue;
                string2 = String.valueOf(string2) + ", ";
            }
            this.error(25, new Object[]{string2});
        }
    }

    public void initMatchPattern(XPath xPath, String string, PrefixResolver prefixResolver) throws SAXException {
        this.m_xpath = xPath;
        this.m_namespaceContext = prefixResolver;
        this.tokenize(string);
        this.m_xpath.m_opMap[0] = 92;
        this.m_xpath.m_opMap[1] = 2;
        this.nextToken();
        this.Pattern();
        if (this.m_token != null) {
            String string2 = "";
            while (this.m_token != null) {
                string2 = String.valueOf(string2) + "'" + this.m_token + "'";
                this.nextToken();
                if (this.m_token == null) continue;
                string2 = String.valueOf(string2) + ", ";
            }
            this.error(25, new Object[]{string2});
        }
        this.m_xpath.m_opMap[this.m_xpath.m_opMap[1]] = -1;
        this.m_xpath.m_opMap[1] = this.m_xpath.m_opMap[1] + 1;
    }

    private void ___________LEXICAL_ANALYSIS___________() {
    }

    private void ____TOKENIZATION_FUNCTIONS____() {
    }

    private void tokenize(String string) throws SAXException {
        this.tokenize(string, null);
    }

    private void tokenize(String string, Vector vector) throws SAXException {
        this.m_xpath.m_tokenQueueSize = 0;
        this.m_xpath.m_currentPattern = string;
        this.m_xpath.m_patternMapSize = 0;
        int n = string.length();
        int n2 = -1;
        int n3 = -1;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            char c = string.charAt(n5);
            switch (c) {
                case '\"': {
                    if (n2 != -1) {
                        bl3 = false;
                        bl = this.mapPatternElemPos(n4, bl, bl2);
                        bl2 = false;
                        if (n3 != -1) {
                            n3 = this.mapNSTokens(string, n2, n3, n5);
                        } else {
                            this.addToTokenQueue(string.substring(n2, n5));
                        }
                    }
                    n2 = n5++;
                    while (n5 < n && (c = string.charAt(n5)) != '\"') {
                        ++n5;
                    }
                    if (c == '\"') {
                        this.addToTokenQueue(string.substring(n2, n5 + 1));
                        n2 = -1;
                        break;
                    }
                    this.error(26);
                    break;
                }
                case '\'': {
                    if (n2 != -1) {
                        bl3 = false;
                        bl = this.mapPatternElemPos(n4, bl, bl2);
                        bl2 = false;
                        if (n3 != -1) {
                            n3 = this.mapNSTokens(string, n2, n3, n5);
                        } else {
                            this.addToTokenQueue(string.substring(n2, n5));
                        }
                    }
                    n2 = n5++;
                    while (n5 < n && (c = string.charAt(n5)) != '\'') {
                        ++n5;
                    }
                    if (c == '\'') {
                        this.addToTokenQueue(string.substring(n2, n5 + 1));
                        n2 = -1;
                        break;
                    }
                    this.error(27);
                    break;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (n2 == -1) break;
                    bl3 = false;
                    bl = this.mapPatternElemPos(n4, bl, bl2);
                    bl2 = false;
                    if (n3 != -1) {
                        n3 = this.mapNSTokens(string, n2, n3, n5);
                    } else {
                        this.addToTokenQueue(string.substring(n2, n5));
                    }
                    n2 = -1;
                    break;
                }
                case '@': {
                    bl2 = true;
                }
                case '-': {
                    if (c == '-') {
                        if (!bl3 && n2 != -1) break;
                        bl3 = false;
                    }
                }
                case '!': 
                case '$': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '/': 
                case '<': 
                case '=': 
                case '>': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '|': {
                    if (n2 != -1) {
                        bl3 = false;
                        bl = this.mapPatternElemPos(n4, bl, bl2);
                        bl2 = false;
                        if (n3 != -1) {
                            n3 = this.mapNSTokens(string, n2, n3, n5);
                        } else {
                            this.addToTokenQueue(string.substring(n2, n5));
                        }
                        n2 = -1;
                    } else if (c == '/' && bl) {
                        bl = this.mapPatternElemPos(n4, bl, bl2);
                    } else if (c == '*') {
                        bl = this.mapPatternElemPos(n4, bl, bl2);
                        bl2 = false;
                    }
                    if (n4 == 0 && c == '|') {
                        if (vector != null) {
                            this.recordTokenString(vector);
                        }
                        bl = true;
                    }
                    if (c == ')' || c == ']') {
                        --n4;
                    } else if (c == '(' || c == '[') {
                        ++n4;
                    }
                    this.addToTokenQueue(string.substring(n5, n5 + 1));
                    break;
                }
                case ':': {
                    if (n3 == n5 - 1) {
                        if (n2 != -1 && n2 < n5 - 1) {
                            this.addToTokenQueue(string.substring(n2, n5 - 1));
                        }
                        bl3 = false;
                        bl2 = false;
                        n2 = -1;
                        n3 = -1;
                        this.addToTokenQueue(string.substring(n5 - 1, n5 + 1));
                        break;
                    }
                    n3 = n5;
                }
                default: {
                    if (n2 == -1) {
                        n2 = n5;
                        bl3 = Character.isDigit(c);
                        break;
                    }
                    if (!bl3) break;
                    bl3 = Character.isDigit(c);
                }
            }
            ++n5;
        }
        if (n2 != -1) {
            bl3 = false;
            bl = this.mapPatternElemPos(n4, bl, bl2);
            if (n3 != -1) {
                n3 = this.mapNSTokens(string, n2, n3, n);
            } else {
                this.addToTokenQueue(string.substring(n2, n));
            }
        }
        if (this.m_xpath.m_tokenQueueSize == 0) {
            this.error(28);
        } else if (vector != null) {
            this.recordTokenString(vector);
        }
        this.m_queueMark = 0;
    }

    private boolean mapPatternElemPos(int n, boolean bl, boolean bl2) {
        if (n == 0) {
            if (!bl) {
                int n2 = this.m_xpath.m_patternMapSize - 1;
                this.m_xpath.m_patternMap[n2] = this.m_xpath.m_patternMap[n2] - 10000;
            }
            this.m_xpath.m_patternMap[this.m_xpath.m_patternMapSize] = this.m_xpath.m_tokenQueueSize - (bl2 ? 1 : 0) + 10000;
            ++this.m_xpath.m_patternMapSize;
            bl = false;
        }
        return bl;
    }

    private void recordTokenString(Vector vector) {
        int n = this.getTokenQueuePosFromMap(this.m_xpath.m_patternMapSize - 1);
        this.resetTokenMark(n + 1);
        if (this.lookahead('(', 1)) {
            int n2 = this.getKeywordToken(this.m_token);
            switch (n2) {
                case 1030: {
                    vector.addElement(PSEUDONAME_COMMENT);
                    return;
                }
                case 1031: {
                    vector.addElement(PSEUDONAME_TEXT);
                    return;
                }
                case 1033: {
                    vector.addElement("*");
                    return;
                }
                case 35: {
                    vector.addElement(PSEUDONAME_ROOT);
                    return;
                }
                case 36: {
                    vector.addElement("*");
                    return;
                }
                case 1032: {
                    vector.addElement("*");
                    return;
                }
            }
            vector.addElement("*");
            return;
        }
        if (this.tokenIs('@')) {
            this.resetTokenMark(++n + 1);
        }
        if (this.lookahead(':', 1)) {
            n += 2;
        }
        vector.addElement(this.m_xpath.m_tokenQueue[n]);
    }

    private void ____TOKEN_ACCESS_AND_MANIPULATION____() {
    }

    private final void addToTokenQueue(String string) {
        this.m_xpath.m_tokenQueue[this.m_xpath.m_tokenQueueSize++] = string;
    }

    private int mapNSTokens(String string, int n, int n2, int n3) {
        String string2;
        String string3 = string.substring(n, n2);
        if (this.m_namespaceContext != null) {
            try {
                string2 = this.m_namespaceContext.getNamespaceForPrefix(string3);
            }
            catch (ClassCastException classCastException) {
                string2 = this.m_namespaceContext.getNamespaceForPrefix(string3);
            }
        } else {
            string2 = string3;
        }
        if (string2 != null && string2.length() > 0) {
            this.addToTokenQueue(string2);
            this.addToTokenQueue(":");
            String string4 = string.substring(n2 + 1, n3);
            if (string4.length() > 0) {
                this.addToTokenQueue(string4);
            }
        } else {
            this.addToTokenQueue(string3);
            this.addToTokenQueue(":");
            String string5 = string.substring(n2 + 1, n3);
            if (string5.length() > 0) {
                this.addToTokenQueue(string5);
            }
        }
        return -1;
    }

    int getTokenQueuePosFromMap(int n) {
        int n2 = this.m_xpath.m_patternMap[n];
        if (n2 >= 10000) {
            return n2 - 10000;
        }
        return n2;
    }

    int getNextTargetIndexInMap(int n) {
        int n2 = -1;
        int n3 = n + 1;
        while (n3 < this.m_xpath.m_patternMapSize) {
            int n4 = this.m_xpath.m_patternMap[n3];
            if (n4 >= 10000) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        return n2;
    }

    int getNextIndexInMap(int n) {
        int n2 = this.m_xpath.m_patternMap[n] >= 10000 ? -1 : (n + 1 < this.m_xpath.m_patternMapSize ? n + 1 : -1);
        return n2;
    }

    int getNextSubpatternStartIndexInMap(int n) {
        int n2 = -1;
        if (n == -1) {
            n2 = 0;
        } else {
            int n3 = n;
            while (n3 < this.m_xpath.m_patternMapSize) {
                int n4 = this.m_xpath.m_patternMap[n3];
                if (n4 >= 10000) {
                    if (n3 + 1 >= this.m_xpath.m_patternMapSize) break;
                    n2 = n3 + 1;
                    break;
                }
                ++n3;
            }
        }
        return n2;
    }

    int getNextPatternPos(int n) {
        int n2 = -1;
        int n3 = n + 1;
        int n4 = this.m_xpath.m_patternMapSize;
        if (n3 < n4) {
            int n5;
            int n6 = n5 = n >= 0 ? this.m_xpath.m_patternMap[n] : 0;
            if (n5 != 10000) {
                n2 = this.m_xpath.m_patternMap[n3];
            }
        }
        return n2;
    }

    int getPrevMapIndex(int n) {
        int n2;
        int n3 = -1;
        int n4 = n - 1;
        if (n4 >= 0 && (n2 = this.m_xpath.m_patternMap[n4]) < 10000) {
            n3 = n4;
        }
        return n3;
    }

    private final boolean tokenIs(String string) {
        if (this.m_token != null) {
            return this.m_token.equals(string);
        }
        return string == null;
    }

    private final boolean tokenIs(char c) {
        if (this.m_token != null) {
            return this.m_tokenChar == c;
        }
        return false;
    }

    private final boolean lookahead(char c, int n) {
        String string;
        int n2 = this.m_queueMark + n;
        boolean bl = n2 <= this.m_xpath.m_tokenQueueSize && n2 > 0 && this.m_xpath.m_tokenQueueSize != 0 ? ((string = (String)this.m_xpath.m_tokenQueue[n2 - 1]).length() == 1 ? string.charAt(0) == c : false) : false;
        return bl;
    }

    private final boolean lookbehind(char c, int n) {
        boolean bl;
        int n2 = this.m_queueMark - (n + 1);
        if (n2 >= 0) {
            String string = (String)this.m_xpath.m_tokenQueue[n2];
            if (string.length() == 1) {
                char c2;
                char c3 = c2 = string == null ? (char)'|' : (char)string.charAt(0);
                bl = c2 == '|' ? false : c2 == c;
            } else {
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean lookbehindHasToken(int n) {
        boolean bl;
        if (this.m_queueMark - n > 0) {
            String string = (String)this.m_xpath.m_tokenQueue[this.m_queueMark - (n - 1)];
            int n2 = string == null ? 124 : (int)string.charAt(0);
            bl = n2 != 124;
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean lookahead(String string, int n) {
        String string2;
        boolean bl = this.m_queueMark + n <= this.m_xpath.m_tokenQueueSize ? ((string2 = (String)this.m_xpath.m_tokenQueue[this.m_queueMark + (n - 1)]) != null ? string2.equals(string) : string == null) : string == null;
        return bl;
    }

    private final void nextToken() {
        if (this.m_queueMark < this.m_xpath.m_tokenQueueSize) {
            this.m_token = (String)this.m_xpath.m_tokenQueue[this.m_queueMark++];
            this.m_tokenChar = this.m_token.charAt(0);
            return;
        }
        this.m_token = null;
        this.m_tokenChar = '\u0000';
    }

    private final String getTokenRelative(int n) {
        int n2 = this.m_queueMark + n;
        String string = n2 > 0 && n2 < this.m_xpath.m_tokenQueueSize ? (String)this.m_xpath.m_tokenQueue[n2] : null;
        return string;
    }

    private final void prevToken() {
        if (this.m_queueMark > 0) {
            --this.m_queueMark;
            this.m_token = (String)this.m_xpath.m_tokenQueue[this.m_queueMark];
            this.m_tokenChar = this.m_token.charAt(0);
            return;
        }
        this.m_token = null;
        this.m_tokenChar = '\u0000';
    }

    private final void resetTokenMark(int n) {
        int n2 = this.m_xpath.m_tokenQueueSize;
        int n3 = n > 0 ? (n <= n2 ? n - 1 : n) : (this.m_queueMark = 0);
        if (this.m_queueMark < n2) {
            this.m_token = (String)this.m_xpath.m_tokenQueue[this.m_queueMark++];
            this.m_tokenChar = this.m_token.charAt(0);
            return;
        }
        this.m_token = null;
        this.m_tokenChar = '\u0000';
    }

    private final void consumeExpected(String string) throws SAXException {
        if (this.tokenIs(string)) {
            this.nextToken();
            return;
        }
        this.error(29, new Object[]{string, this.m_token});
    }

    private final void consumeExpected(char c) throws SAXException {
        if (this.tokenIs(c)) {
            this.nextToken();
            return;
        }
        this.error(29, new Object[]{String.valueOf(c), this.m_token});
    }

    private void ____DIAGNOSTICS_AND_ERRORS____() {
    }

    private final void trace(String string) {
        System.out.println(string);
    }

    public void warn(int n) throws XPathProcessorException {
        this.warn(null, n, null);
    }

    public void warn(int n, Object[] objectArray) throws XPathProcessorException {
        this.warn(null, n, objectArray);
    }

    public void warn(Node node, int n) throws XPathProcessorException {
        this.warn(node, n, null);
    }

    public void warn(Node node, int n, Object[] objectArray) throws XPathProcessorException {
        String string = XSLMessages.createXPATHWarning(n, objectArray);
        boolean bl = this.m_xpath.getProblemListener().problem((short)5, (short)1, this.m_namespaceContext, node, string, null, 0, 0);
        if (bl) {
            throw new XPathProcessorException(string);
        }
    }

    private void assert(boolean bl, String string) throws XPathProcessorException {
        if (!bl) {
            this.error(null, 30, new Object[]{string});
        }
    }

    public void error(int n) throws XPathProcessorException {
        this.error(null, n, null);
    }

    public void error(int n, Object[] objectArray) throws XPathProcessorException {
        this.error(null, n, objectArray);
    }

    public void error(Node node, int n) throws XPathProcessorException {
        this.error(node, n, null);
    }

    public void error(Node node, int n, Object[] objectArray) throws XPathProcessorException {
        String string = XSLMessages.createXPATHMessage(n, objectArray);
        String string2 = String.valueOf(this.m_xpath.m_currentPattern != null ? "pattern = '" + this.m_xpath.m_currentPattern + "'\n" : "") + string + this.dumpRemainingTokenQueue();
        boolean bl = this.m_xpath.getProblemListener().problem((short)5, (short)2, this.m_namespaceContext, node, string2, null, 0, 0);
        if (bl) {
            throw new XPathProcessorException(string2);
        }
    }

    protected String dumpRemainingTokenQueue() {
        String string;
        int n = this.m_queueMark;
        if (n < this.m_xpath.m_tokenQueueSize) {
            String string2 = "\n Remaining tokens: (";
            while (n < this.m_xpath.m_tokenQueueSize) {
                String string3 = (String)this.m_xpath.m_tokenQueue[n++];
                string2 = String.valueOf(string2) + " '" + string3 + "'";
            }
            string = String.valueOf(string2) + ")";
        } else {
            string = "";
        }
        return string;
    }

    final int getKeywordToken(String string) {
        int n;
        try {
            Integer n2 = (Integer)m_keywords.get(string);
            n = n2 != null ? n2 : 0;
        }
        catch (NullPointerException nullPointerException) {
            n = 0;
        }
        catch (ClassCastException classCastException) {
            n = 0;
        }
        return n;
    }

    final int getFunctionToken(String string) {
        int n;
        try {
            n = (Integer)m_functions.get(string);
        }
        catch (NullPointerException nullPointerException) {
            n = -1;
        }
        catch (ClassCastException classCastException) {
            n = -1;
        }
        return n;
    }

    private void ___________PARSER___________() {
    }

    void insertOp(int n, int n2, int n3) {
        int n4 = this.m_xpath.m_opMap[1];
        int n5 = n4 - 1;
        while (n5 >= n) {
            this.m_xpath.m_opMap[n5 + n2] = this.m_xpath.m_opMap[n5];
            --n5;
        }
        this.m_xpath.m_opMap[n] = n3;
        this.m_xpath.m_opMap[1] = n4 + n2;
    }

    void appendOp(int n, int n2) {
        int n3 = this.m_xpath.m_opMap[1];
        this.m_xpath.m_opMap[n3] = n2;
        this.m_xpath.m_opMap[n3 + 1] = n;
        this.m_xpath.m_opMap[1] = n3 + n;
    }

    private void ____EXPRESSIONS____() {
    }

    protected void Expr() throws SAXException {
        this.OrExpr();
    }

    protected void OrExpr() throws SAXException {
        int n = this.m_xpath.m_opMap[1];
        this.AndExpr();
        if (this.m_token != null && this.tokenIs("or")) {
            this.nextToken();
            this.insertOp(n, 2, 2);
            this.OrExpr();
            this.m_xpath.m_opMap[n + 1] = this.m_xpath.m_opMap[1] - n;
        }
    }

    protected void AndExpr() throws SAXException {
        int n = this.m_xpath.m_opMap[1];
        this.EqualityExpr(-1);
        if (this.m_token != null && this.tokenIs("and")) {
            this.nextToken();
            this.insertOp(n, 2, 3);
            this.AndExpr();
            this.m_xpath.m_opMap[n + 1] = this.m_xpath.m_opMap[1] - n;
        }
    }

    protected int EqualityExpr(int n) throws SAXException {
        int n2 = this.m_xpath.m_opMap[1];
        if (n == -1) {
            n = n2;
        }
        this.RelationalExpr(-1);
        if (this.m_token != null) {
            if (this.tokenIs('!') && this.lookahead('=', 1)) {
                this.nextToken();
                this.nextToken();
                this.insertOp(n, 2, 4);
                int n3 = this.m_xpath.m_opMap[1] - n;
                n = this.EqualityExpr(n);
                this.m_xpath.m_opMap[n + 1] = this.m_xpath.m_opMap[n + n3 + 1] + n3;
                n += 2;
            } else if (this.tokenIs('=')) {
                this.nextToken();
                this.insertOp(n, 2, 5);
                int n4 = this.m_xpath.m_opMap[1] - n;
                n = this.EqualityExpr(n);
                this.m_xpath.m_opMap[n + 1] = this.m_xpath.m_opMap[n + n4 + 1] + n4;
                n += 2;
            }
        }
        return n;
    }

    protected int RelationalExpr(int n) throws SAXException {
        int n2 = this.m_xpath.m_opMap[1];
        if (n == -1) {
            n = n2;
        }
        this.AdditiveExpr(-1);
        if (this.m_token != null) {
            if (this.tokenIs('<')) {
                this.nextToken();
                if (this.tokenIs('=')) {
                    this.nextToken();
                    this.insertOp(n, 2, 6);
                } else {
                    this.insertOp(n, 2, 7);
                }
                int n3 = this.m_xpath.m_opMap[1] - n;
                n = this.RelationalExpr(n);
                this.m_xpath.m_opMap[n + 1] = this.m_xpath.m_opMap[n + n3 + 1] + n3;
                n += 2;
            } else if (this.tokenIs('>')) {
                this.nextToken();
                if (this.tokenIs('=')) {
                    this.nextToken();
                    this.insertOp(n, 2, 8);
                } else {
                    this.insertOp(n, 2, 9);
                }
                int n4 = this.m_xpath.m_opMap[1] - n;
                n = this.RelationalExpr(n);
                this.m_xpath.m_opMap[n + 1] = this.m_xpath.m_opMap[n + n4 + 1] + n4;
                n += 2;
            }
        }
        return n;
    }

    protected int AdditiveExpr(int n) throws SAXException {
        int n2 = this.m_xpath.m_opMap[1];
        if (n == -1) {
            n = n2;
        }
        this.MultiplicativeExpr(-1);
        if (this.m_token != null) {
            if (this.tokenIs('+')) {
                this.nextToken();
                this.insertOp(n, 2, 10);
                int n3 = this.m_xpath.m_opMap[1] - n;
                n = this.AdditiveExpr(n);
                this.m_xpath.m_opMap[n + 1] = this.m_xpath.m_opMap[n + n3 + 1] + n3;
                n += 2;
            } else if (this.tokenIs('-')) {
                this.nextToken();
                this.insertOp(n, 2, 11);
                int n4 = this.m_xpath.m_opMap[1] - n;
                n = this.AdditiveExpr(n);
                this.m_xpath.m_opMap[n + 1] = this.m_xpath.m_opMap[n + n4 + 1] + n4;
                n += 2;
            }
        }
        return n;
    }

    protected int MultiplicativeExpr(int n) throws SAXException {
        int n2 = this.m_xpath.m_opMap[1];
        if (n == -1) {
            n = n2;
        }
        this.UnaryExpr();
        if (this.m_token != null) {
            if (this.tokenIs('*')) {
                this.nextToken();
                this.insertOp(n2, 2, 12);
                int n3 = this.m_xpath.m_opMap[1] - n;
                n = this.MultiplicativeExpr(n);
                this.m_xpath.m_opMap[n + 1] = this.m_xpath.m_opMap[n + n3 + 1] + n3;
                n += 2;
            } else if (this.tokenIs("div")) {
                this.nextToken();
                this.insertOp(n2, 2, 13);
                int n4 = this.m_xpath.m_opMap[1] - n;
                n = this.MultiplicativeExpr(n);
                this.m_xpath.m_opMap[n + 1] = this.m_xpath.m_opMap[n + n4 + 1] + n4;
                n += 2;
            } else if (this.tokenIs("mod")) {
                this.nextToken();
                this.insertOp(n2, 2, 14);
                int n5 = this.m_xpath.m_opMap[1] - n;
                n = this.MultiplicativeExpr(n);
                this.m_xpath.m_opMap[n + 1] = this.m_xpath.m_opMap[n + n5 + 1] + n5;
                n += 2;
            } else if (this.tokenIs("quo")) {
                this.nextToken();
                this.insertOp(n2, 2, 15);
                int n6 = this.m_xpath.m_opMap[1] - n;
                n = this.MultiplicativeExpr(n);
                this.m_xpath.m_opMap[n + 1] = this.m_xpath.m_opMap[n + n6 + 1] + n6;
                n += 2;
            }
        }
        return n;
    }

    protected void UnaryExpr() throws SAXException {
        int n = this.m_xpath.m_opMap[1];
        boolean bl = false;
        if (this.m_tokenChar == '-') {
            this.nextToken();
            this.appendOp(2, 16);
            bl = true;
        }
        this.UnionExpr();
        if (bl) {
            this.m_xpath.m_opMap[n + 1] = this.m_xpath.m_opMap[1] - n;
        }
    }

    protected void StringExpr() throws SAXException {
        int n = this.m_xpath.m_opMap[1];
        this.appendOp(2, 17);
        this.Expr();
        this.m_xpath.m_opMap[n + 1] = this.m_xpath.m_opMap[1] - n;
    }

    protected void BooleanExpr() throws SAXException {
        int n = this.m_xpath.m_opMap[1];
        this.appendOp(2, 18);
        this.Expr();
        int n2 = this.m_xpath.m_opMap[1] - n;
        if (n2 == 2) {
            this.error(31);
        }
        this.m_xpath.m_opMap[n + 1] = n2;
    }

    protected void NumberExpr() throws SAXException {
        int n = this.m_xpath.m_opMap[1];
        this.appendOp(2, 19);
        this.Expr();
        this.m_xpath.m_opMap[n + 1] = this.m_xpath.m_opMap[1] - n;
    }

    protected void UnionExpr() throws SAXException {
        int n = this.m_xpath.m_opMap[1];
        boolean bl = true;
        boolean bl2 = false;
        do {
            this.PathExpr();
            if (!this.tokenIs('|')) break;
            if (!bl2) {
                bl2 = true;
                this.insertOp(n, 2, 20);
            }
            this.nextToken();
        } while (bl);
        this.m_xpath.m_opMap[n + 1] = this.m_xpath.m_opMap[1] - n;
    }

    protected void PathExpr() throws SAXException {
        int n = this.m_xpath.m_opMap[1];
        this.FilterExpr();
        if (this.tokenIs('/')) {
            this.nextToken();
            this.insertOp(n, 2, 28);
            this.RelativeLocationPath();
            this.m_xpath.m_opMap[this.m_xpath.m_opMap[1]] = -1;
            this.m_xpath.m_opMap[1] = this.m_xpath.m_opMap[1] + 1;
            this.m_xpath.m_opMap[n + 1] = this.m_xpath.m_opMap[1] - n;
        }
    }

    protected void FilterExpr() throws SAXException {
        int n = this.m_xpath.m_opMap[1];
        this.PrimaryExpr();
        if (this.tokenIs('[')) {
            this.insertOp(n, 2, 28);
            while (this.tokenIs('[')) {
                this.Predicate();
            }
            if (this.tokenIs('/')) {
                this.nextToken();
                this.RelativeLocationPath();
            }
            this.m_xpath.m_opMap[this.m_xpath.m_opMap[1]] = -1;
            this.m_xpath.m_opMap[1] = this.m_xpath.m_opMap[1] + 1;
            this.m_xpath.m_opMap[n + 1] = this.m_xpath.m_opMap[1] - n;
        }
    }

    protected void PrimaryExpr() throws SAXException {
        int n = this.m_xpath.m_opMap[1];
        if (this.m_tokenChar == '\'' || this.m_tokenChar == '\"') {
            this.appendOp(2, 21);
            this.Literal();
            this.m_xpath.m_opMap[n + 1] = this.m_xpath.m_opMap[1] - n;
            return;
        }
        if (this.m_tokenChar == '$') {
            this.nextToken();
            this.appendOp(2, 22);
            this.NCName();
            this.m_xpath.m_opMap[n + 1] = this.m_xpath.m_opMap[1] - n;
            return;
        }
        if (this.m_tokenChar == '(') {
            this.nextToken();
            this.appendOp(2, 23);
            this.Expr();
            this.consumeExpected(')');
            this.m_xpath.m_opMap[n + 1] = this.m_xpath.m_opMap[1] - n;
            return;
        }
        if (this.m_token != null && (this.m_tokenChar == '.' && this.m_token.length() > 1 && Character.isDigit(this.m_token.charAt(1)) || Character.isDigit(this.m_tokenChar))) {
            this.appendOp(2, 24);
            this.Number();
            this.m_xpath.m_opMap[n + 1] = this.m_xpath.m_opMap[1] - n;
            return;
        }
        if (this.lookahead('(', 1) || this.lookahead(':', 1) && this.lookahead('(', 3)) {
            this.FunctionCall();
            return;
        }
        this.LocationPath();
    }

    protected void Argument() throws SAXException {
        int n = this.m_xpath.m_opMap[1];
        this.appendOp(2, 25);
        this.Expr();
        this.m_xpath.m_opMap[n + 1] = this.m_xpath.m_opMap[1] - n;
    }

    protected void FunctionCall() throws SAXException {
        int n = this.m_xpath.m_opMap[1];
        if (this.lookahead(':', 1)) {
            this.appendOp(4, 26);
            this.m_xpath.m_opMap[n + 1 + 1] = this.m_queueMark - 1;
            this.nextToken();
            this.consumeExpected(':');
            this.m_xpath.m_opMap[n + 1 + 2] = this.m_queueMark - 1;
            this.nextToken();
        } else {
            int n2 = this.getFunctionToken(this.m_token);
            if (n2 == -1) {
                this.warn(9, new Object[]{this.m_token});
            }
            switch (n2) {
                case 1030: 
                case 1031: 
                case 1032: 
                case 1033: {
                    this.LocationPath();
                    return;
                }
            }
            this.appendOp(3, 27);
            this.m_xpath.m_opMap[n + 1 + 1] = n2;
            this.nextToken();
        }
        this.consumeExpected('(');
        while (!this.tokenIs(')')) {
            if (this.tokenIs(',')) {
                this.error(32);
            }
            this.Argument();
            if (this.tokenIs(')')) continue;
            this.consumeExpected(',');
            if (!this.tokenIs(')')) continue;
            this.error(33);
        }
        this.consumeExpected(')');
        this.m_xpath.m_opMap[this.m_xpath.m_opMap[1]] = -1;
        this.m_xpath.m_opMap[1] = this.m_xpath.m_opMap[1] + 1;
        this.m_xpath.m_opMap[n + 1] = this.m_xpath.m_opMap[1] - n;
    }

    private void ____LOCATION_PATHS____() {
    }

    protected void LocationPath() throws SAXException {
        int n = this.m_xpath.m_opMap[1];
        this.appendOp(2, 28);
        if (this.tokenIs('/')) {
            this.appendOp(4, 55);
            this.m_xpath.m_opMap[this.m_xpath.m_opMap[1] - 2] = 4;
            this.m_xpath.m_opMap[this.m_xpath.m_opMap[1] - 1] = 35;
            this.nextToken();
        }
        if (this.m_token != null) {
            this.RelativeLocationPath();
        }
        this.m_xpath.m_opMap[this.m_xpath.m_opMap[1]] = -1;
        this.m_xpath.m_opMap[1] = this.m_xpath.m_opMap[1] + 1;
        this.m_xpath.m_opMap[n + 1] = this.m_xpath.m_opMap[1] - n;
    }

    protected void RelativeLocationPath() throws SAXException {
        this.Step();
        while (this.tokenIs('/')) {
            this.nextToken();
            this.Step();
        }
    }

    protected void Step() throws SAXException {
        int n = this.m_xpath.m_opMap[1];
        if (this.tokenIs(FROM_SELF_ABBREVIATED_STRING)) {
            this.nextToken();
            if (this.tokenIs('[')) {
                this.error(34);
            }
            this.appendOp(4, 48);
            this.m_xpath.m_opMap[this.m_xpath.m_opMap[1] - 2] = 4;
            this.m_xpath.m_opMap[this.m_xpath.m_opMap[1] - 1] = 1033;
            return;
        }
        if (this.tokenIs("..")) {
            this.nextToken();
            this.appendOp(4, 45);
            this.m_xpath.m_opMap[this.m_xpath.m_opMap[1] - 2] = 4;
            this.m_xpath.m_opMap[this.m_xpath.m_opMap[1] - 1] = 1033;
            return;
        }
        this.Basis();
        while (this.tokenIs('[')) {
            this.Predicate();
        }
        this.m_xpath.m_opMap[n + 1] = this.m_xpath.m_opMap[1] - n;
    }

    protected void Basis() throws SAXException {
        int n = this.m_xpath.m_opMap[1];
        if (this.lookahead("::", 1)) {
            this.AxisName();
            this.nextToken();
            this.nextToken();
        } else if (this.tokenIs('@')) {
            this.appendOp(2, 39);
            this.nextToken();
        } else {
            if (this.tokenIs('/')) {
                this.appendOp(2, 42);
                this.m_xpath.m_opMap[1] = this.m_xpath.m_opMap[1] + 1;
                this.m_xpath.m_opMap[this.m_xpath.m_opMap[1]] = 1033;
                this.m_xpath.m_opMap[1] = this.m_xpath.m_opMap[1] + 1;
                this.m_xpath.m_opMap[n + 1 + 1] = this.m_xpath.m_opMap[1] - n;
                return;
            }
            this.appendOp(2, 40);
        }
        this.m_xpath.m_opMap[1] = this.m_xpath.m_opMap[1] + 1;
        this.NodeTest();
        this.m_xpath.m_opMap[n + 1 + 1] = this.m_xpath.m_opMap[1] - n;
    }

    protected void AxisName() throws SAXException {
        Object v = m_axisnames.get(this.m_token);
        if (v == null) {
            this.error(35, new Object[]{this.m_token});
        }
        this.appendOp(2, (Integer)v);
    }

    protected void NodeTest() throws SAXException {
        if (this.lookahead('(', 1)) {
            int n;
            Object v = m_nodetypes.get(this.m_token);
            if (v == null) {
                this.error(36, new Object[]{this.m_token});
                return;
            }
            this.nextToken();
            this.m_xpath.m_opMap[this.m_xpath.m_opMap[1]] = n = ((Integer)v).intValue();
            this.m_xpath.m_opMap[1] = this.m_xpath.m_opMap[1] + 1;
            this.consumeExpected('(');
            if (n == 1032 && !this.tokenIs(')')) {
                this.Literal();
            }
            this.consumeExpected(')');
            return;
        }
        this.m_xpath.m_opMap[this.m_xpath.m_opMap[1]] = 34;
        this.m_xpath.m_opMap[1] = this.m_xpath.m_opMap[1] + 1;
        if (this.lookahead(':', 1)) {
            this.m_xpath.m_opMap[this.m_xpath.m_opMap[1]] = this.tokenIs('*') ? -3 : this.m_queueMark - 1;
            this.nextToken();
            this.consumeExpected(':');
        } else {
            this.m_xpath.m_opMap[this.m_xpath.m_opMap[1]] = -2;
        }
        this.m_xpath.m_opMap[1] = this.m_xpath.m_opMap[1] + 1;
        this.m_xpath.m_opMap[this.m_xpath.m_opMap[1]] = this.tokenIs('*') ? -3 : this.m_queueMark - 1;
        this.m_xpath.m_opMap[1] = this.m_xpath.m_opMap[1] + 1;
        this.nextToken();
    }

    protected void Predicate() throws SAXException {
        if (this.tokenIs('[')) {
            this.nextToken();
            this.PredicateExpr();
            this.consumeExpected(']');
        }
    }

    protected void PredicateExpr() throws SAXException {
        int n = this.m_xpath.m_opMap[1];
        this.appendOp(2, 29);
        this.Expr();
        this.m_xpath.m_opMap[this.m_xpath.m_opMap[1]] = -1;
        this.m_xpath.m_opMap[1] = this.m_xpath.m_opMap[1] + 1;
        this.m_xpath.m_opMap[n + 1] = this.m_xpath.m_opMap[1] - n;
    }

    protected void QName() throws SAXException {
        this.m_xpath.m_opMap[this.m_xpath.m_opMap[1]] = this.m_queueMark - 1;
        this.m_xpath.m_opMap[1] = this.m_xpath.m_opMap[1] + 1;
        this.nextToken();
        this.consumeExpected(':');
        this.m_xpath.m_opMap[this.m_xpath.m_opMap[1]] = this.m_queueMark - 1;
        this.m_xpath.m_opMap[1] = this.m_xpath.m_opMap[1] + 1;
        this.nextToken();
    }

    protected void NCName() {
        this.m_xpath.m_opMap[this.m_xpath.m_opMap[1]] = this.m_queueMark - 1;
        this.m_xpath.m_opMap[1] = this.m_xpath.m_opMap[1] + 1;
        this.nextToken();
    }

    protected void Literal() throws SAXException {
        int n = this.m_token.length() - 1;
        char c = this.m_tokenChar;
        char c2 = this.m_token.charAt(n);
        if (c == '\"' && c2 == '\"' || c == '\'' && c2 == '\'') {
            int n2 = this.m_queueMark - 1;
            this.m_xpath.m_tokenQueue[n2] = null;
            XString xString = new XString(this.m_token.substring(1, n));
            this.m_xpath.m_tokenQueue[n2] = xString;
            this.m_xpath.m_opMap[this.m_xpath.m_opMap[1]] = n2;
            this.m_xpath.m_opMap[1] = this.m_xpath.m_opMap[1] + 1;
            this.nextToken();
            return;
        }
        this.error(37, new Object[]{this.m_token});
    }

    protected void Number() throws SAXException {
        if (this.m_token != null) {
            double d;
            try {
                d = Double.valueOf(this.m_token);
            }
            catch (NumberFormatException numberFormatException) {
                d = 0.0;
                this.error(38, new Object[]{this.m_token});
            }
            this.m_xpath.m_tokenQueue[this.m_queueMark - 1] = new XNumber(d);
            this.m_xpath.m_opMap[this.m_xpath.m_opMap[1]] = this.m_queueMark - 1;
            this.m_xpath.m_opMap[1] = this.m_xpath.m_opMap[1] + 1;
            this.nextToken();
        }
    }

    private void ____PATTERNS____() {
    }

    protected void Pattern() throws SAXException {
        while (true) {
            this.LocationPathPattern();
            if (!this.tokenIs('|')) break;
            this.nextToken();
        }
    }

    protected void LocationPathPattern() throws SAXException {
        int n = this.m_xpath.m_opMap[1];
        this.appendOp(2, 93);
        if (this.lookahead('(', 1) && this.tokenIs("id") || this.tokenIs(FUNC_KEY_STRING)) {
            this.IdKeyPattern();
        }
        if (this.tokenIs('/')) {
            if (this.lookahead('/', 1)) {
                this.appendOp(4, 95);
            } else {
                this.appendOp(4, 55);
            }
            this.m_xpath.m_opMap[this.m_xpath.m_opMap[1] - 2] = 4;
            this.m_xpath.m_opMap[this.m_xpath.m_opMap[1] - 1] = 35;
            this.nextToken();
        }
        if (!this.tokenIs('|') && this.m_token != null) {
            this.RelativePathPattern();
        }
        this.m_xpath.m_opMap[this.m_xpath.m_opMap[1]] = -1;
        this.m_xpath.m_opMap[1] = this.m_xpath.m_opMap[1] + 1;
        this.m_xpath.m_opMap[n + 1] = this.m_xpath.m_opMap[1] - n;
    }

    protected void IdKeyPattern() throws SAXException {
        this.FunctionCall();
    }

    protected void RelativePathPattern() throws SAXException {
        this.StepPattern();
        while (this.tokenIs('/')) {
            this.nextToken();
            this.StepPattern();
        }
    }

    protected void StepPattern() throws SAXException {
        this.AbbreviatedNodeTestStep();
    }

    protected void AbbreviatedNodeTestStep() throws SAXException {
        int n = this.m_xpath.m_opMap[1];
        int n2 = -1;
        if (this.tokenIs('@')) {
            this.appendOp(2, 94);
            this.nextToken();
        } else if (this.tokenIs('/')) {
            this.appendOp(2, 95);
            this.nextToken();
        } else {
            if (this.tokenIs('/')) {
                this.nextToken();
            }
            n2 = this.m_xpath.m_opMap[1];
            this.appendOp(2, 96);
        }
        this.m_xpath.m_opMap[1] = this.m_xpath.m_opMap[1] + 1;
        this.NodeTest();
        this.m_xpath.m_opMap[n + 1 + 1] = this.m_xpath.m_opMap[1] - n;
        while (this.tokenIs('[')) {
            this.Predicate();
        }
        if (n2 > -1 && this.tokenIs('/') && this.lookahead('/', 1)) {
            this.m_xpath.m_opMap[n2] = 95;
            this.nextToken();
        }
        this.m_xpath.m_opMap[n + 1] = this.m_xpath.m_opMap[1] - n;
    }

    private void ____DIAGNOSTIC_FUNCTIONS____() {
    }

    public static void diagnoseXPathString(String string) throws SAXException {
        XPathSupportDefault xPathSupportDefault = new XPathSupportDefault();
        XPathProcessorImpl xPathProcessorImpl = new XPathProcessorImpl(xPathSupportDefault);
        XPath xPath = new XPath(xPathSupportDefault, new ProblemListenerDefault());
        xPathProcessorImpl.initXPath(xPath, string, null);
        XPathProcessorImpl.diagnoseXPath(xPath, 0, 0);
    }

    static int diagnoseXPathBinaryOperation(String string, XPath xPath, int n, int n2) {
        System.out.println(String.valueOf(string) + " {");
        n += 2;
        n = XPathProcessorImpl.diagnoseXPath(xPath, n, n2 + 1);
        n = XPathProcessorImpl.diagnoseXPath(xPath, n, n2 + 1);
        XPathProcessorImpl.indent(n2);
        System.out.println("}");
        return n;
    }

    static int diagnoseXPathUnaryOperation(String string, XPath xPath, int n, int n2) {
        System.out.println(String.valueOf(string) + " {");
        n += 2;
        n = XPathProcessorImpl.diagnoseXPath(xPath, n, n2 + 1);
        XPathProcessorImpl.indent(n2);
        System.out.println("}");
        return n;
    }

    static int diagnoseXPathMultiOperation(String string, int n, XPath xPath, int n2, int n3) {
        System.out.println(String.valueOf(string) + " {");
        n2 += 2;
        while (xPath.m_opMap[n2] == n) {
            XPathProcessorImpl.indent(n3 + 1);
            System.out.println("{");
            n2 = XPathProcessorImpl.diagnoseXPath(xPath, n2, n3 + 2);
            XPathProcessorImpl.indent(n3 + 1);
            System.out.println("}");
        }
        XPathProcessorImpl.indent(n3);
        System.out.println("}");
        return n2;
    }

    static int diagnoseToken(XPath xPath, int n) {
        System.out.print("{");
        System.out.print(xPath.m_tokenQueue[xPath.m_opMap[n]]);
        System.out.print("}");
        return n + 1;
    }

    static int diagnoseXPathSimpleOperation(String string, XPath xPath, int n, int n2) {
        n += 2;
        System.out.print(string);
        n = XPathProcessorImpl.diagnoseToken(xPath, n);
        System.out.println("");
        return n;
    }

    static int diagnoseXPathLocationStep(String string, XPath xPath, int n, int n2) {
        int n3 = xPath.m_opMap[n + 1 + 1];
        n += 3;
        System.out.print(string);
        if (n3 > 3) {
            n = XPathProcessorImpl.diagnoseXPath(xPath, n, 1);
        }
        System.out.println("");
        return n;
    }

    static int diagnoseXPath(XPath xPath, int n, int n2) {
        XPathProcessorImpl.indent(n2);
        switch (xPath.m_opMap[n]) {
            case 1: {
                n = XPathProcessorImpl.diagnoseXPathUnaryOperation("OP_XPATH", xPath, n, n2);
                break;
            }
            case -2: {
                System.out.println("{EMPTY}");
                ++n;
                break;
            }
            case 2: {
                n = XPathProcessorImpl.diagnoseXPathBinaryOperation("OP_OR", xPath, n, n2);
                break;
            }
            case 3: {
                n = XPathProcessorImpl.diagnoseXPathBinaryOperation("OP_AND", xPath, n, n2);
                break;
            }
            case 4: {
                n = XPathProcessorImpl.diagnoseXPathBinaryOperation("OP_NOTEQUALS", xPath, n, n2);
                break;
            }
            case 5: {
                n = XPathProcessorImpl.diagnoseXPathBinaryOperation("OP_EQUALS", xPath, n, n2);
                break;
            }
            case 6: {
                n = XPathProcessorImpl.diagnoseXPathBinaryOperation("OP_LTE", xPath, n, n2);
                break;
            }
            case 7: {
                n = XPathProcessorImpl.diagnoseXPathBinaryOperation("OP_LT", xPath, n, n2);
                break;
            }
            case 8: {
                n = XPathProcessorImpl.diagnoseXPathBinaryOperation("OP_GTE", xPath, n, n2);
                break;
            }
            case 9: {
                n = XPathProcessorImpl.diagnoseXPathBinaryOperation("OP_GT", xPath, n, n2);
                break;
            }
            case 10: {
                n = XPathProcessorImpl.diagnoseXPathBinaryOperation("OP_PLUS", xPath, n, n2);
                break;
            }
            case 11: {
                n = XPathProcessorImpl.diagnoseXPathBinaryOperation("OP_MINUS", xPath, n, n2);
                break;
            }
            case 12: {
                n = XPathProcessorImpl.diagnoseXPathBinaryOperation("OP_MULT", xPath, n, n2);
                break;
            }
            case 13: {
                n = XPathProcessorImpl.diagnoseXPathBinaryOperation("OP_DIV", xPath, n, n2);
                break;
            }
            case 14: {
                n = XPathProcessorImpl.diagnoseXPathBinaryOperation("OP_MOD", xPath, n, n2);
                break;
            }
            case 15: {
                n = XPathProcessorImpl.diagnoseXPathBinaryOperation("OP_QUO", xPath, n, n2);
                break;
            }
            case 16: {
                n = XPathProcessorImpl.diagnoseXPathUnaryOperation("OP_NEG", xPath, n, n2);
                break;
            }
            case 17: {
                n = XPathProcessorImpl.diagnoseXPathUnaryOperation("OP_STRING", xPath, n, n2);
                break;
            }
            case 18: {
                n = XPathProcessorImpl.diagnoseXPathUnaryOperation("OP_BOOL", xPath, n, n2);
                break;
            }
            case 19: {
                n = XPathProcessorImpl.diagnoseXPathUnaryOperation("OP_NUMBER", xPath, n, n2);
                break;
            }
            case 20: {
                n = XPathProcessorImpl.diagnoseXPathMultiOperation("OP_UNION", 28, xPath, n, n2);
                break;
            }
            case 21: {
                n = XPathProcessorImpl.diagnoseXPathSimpleOperation("OP_LITERAL", xPath, n, n2);
                break;
            }
            case 22: {
                n = XPathProcessorImpl.diagnoseXPathSimpleOperation("OP_VARIABLE", xPath, n, n2);
                break;
            }
            case 23: {
                n = XPathProcessorImpl.diagnoseXPathUnaryOperation("OP_GROUP", xPath, n, n2);
                break;
            }
            case 24: {
                n = XPathProcessorImpl.diagnoseXPathSimpleOperation("OP_NUMBERLIT", xPath, n, n2);
                break;
            }
            case 25: {
                n = XPathProcessorImpl.diagnoseXPathUnaryOperation("OP_ARGUMENT", xPath, n, n2);
                break;
            }
            case 26: {
                System.out.println("OP_EXTFUNCTION {");
                int n3 = n + xPath.m_opMap[n + 1] - 1;
                n += 2;
                XPathProcessorImpl.indent(n2 + 1);
                n = XPathProcessorImpl.diagnoseToken(xPath, n);
                System.out.print(":");
                n = XPathProcessorImpl.diagnoseToken(xPath, n);
                System.out.println("");
                while (n < n3) {
                    XPathProcessorImpl.indent(n2 + 1);
                    System.out.println("{");
                    n = XPathProcessorImpl.diagnoseXPath(xPath, n, n2 + 2);
                    XPathProcessorImpl.indent(n2 + 1);
                    System.out.println("}");
                }
                XPathProcessorImpl.indent(n2);
                System.out.println("}");
                if (xPath.m_opMap[n] != -1) {
                    System.out.println(XSLMessages.createXPATHMessage(41, null));
                }
                ++n;
                break;
            }
            case 27: {
                System.out.println("OP_FUNCTION {");
                int n4 = n + xPath.m_opMap[n + 1] - 1;
                XPathProcessorImpl.indent(n2 + 1);
                int n5 = xPath.m_opMap[n += 2];
                switch (n5) {
                    case 1: {
                        System.out.print("FUNC_LAST");
                        break;
                    }
                    case 2: {
                        System.out.print("FUNC_POSITION");
                        break;
                    }
                    case 3: {
                        System.out.print("FUNC_COUNT");
                        break;
                    }
                    case 4: {
                        System.out.print("FUNC_ID");
                        break;
                    }
                    case 5: {
                        System.out.print("FUNC_KEY");
                        break;
                    }
                    case 7: {
                        System.out.print("FUNC_LOCAL_PART");
                        break;
                    }
                    case 8: {
                        System.out.print("FUNC_NAMESPACE");
                        break;
                    }
                    case 9: {
                        System.out.print("FUNC_QNAME");
                        break;
                    }
                    case 10: {
                        System.out.print("FUNC_GENERATE_ID");
                        break;
                    }
                    case 11: {
                        System.out.print("FUNC_NOT");
                        break;
                    }
                    case 12: {
                        System.out.print("FUNC_TRUE");
                        break;
                    }
                    case 13: {
                        System.out.print("FUNC_FALSE");
                        break;
                    }
                    case 14: {
                        System.out.print("FUNC_BOOLEAN");
                        break;
                    }
                    case 32: {
                        System.out.print("FUNC_LANG");
                        break;
                    }
                    case 15: {
                        System.out.print("FUNC_NUMBER");
                        break;
                    }
                    case 16: {
                        System.out.print("FUNC_FLOOR");
                        break;
                    }
                    case 17: {
                        System.out.print("FUNC_CEILING");
                        break;
                    }
                    case 18: {
                        System.out.print("FUNC_ROUND");
                        break;
                    }
                    case 19: {
                        System.out.print("FUNC_SUM");
                        break;
                    }
                    case 20: {
                        System.out.print("FUNC_STRING");
                        break;
                    }
                    case 21: {
                        System.out.print("FUNC_STARTS_WITH");
                        break;
                    }
                    case 22: {
                        System.out.print("FUNC_CONTAINS");
                        break;
                    }
                    case 23: {
                        System.out.print("FUNC_SUBSTRING_BEFORE");
                        break;
                    }
                    case 24: {
                        System.out.print("FUNC_SUBSTRING_AFTER");
                        break;
                    }
                    case 25: {
                        System.out.print("FUNC_NORMALIZE_SPACE");
                        break;
                    }
                    case 26: {
                        System.out.print("FUNC_TRANSLATE");
                        break;
                    }
                    case 27: {
                        System.out.print("FUNC_CONCAT");
                        break;
                    }
                    case 31: {
                        System.out.print("FUNC_SYSTEM_PROPERTY");
                        break;
                    }
                    case 33: {
                        System.out.print("FUNC_EXT_FUNCTION_AVAILABLE");
                        break;
                    }
                    case 34: {
                        System.out.print("FUNC_EXT_ELEM_AVAILABLE");
                        break;
                    }
                    case 29: {
                        System.out.print("FUNC_SUBSTRING");
                        break;
                    }
                    case 30: {
                        System.out.print("FUNC_STRING_LENGTH");
                        break;
                    }
                    case 35: {
                        System.out.print("FUNC_DOCLOCATION");
                        break;
                    }
                }
                ++n;
                System.out.println("");
                while (n < n4) {
                    XPathProcessorImpl.indent(n2 + 1);
                    System.out.println("{");
                    n = XPathProcessorImpl.diagnoseXPath(xPath, n, n2 + 2);
                    XPathProcessorImpl.indent(n2 + 1);
                    System.out.println("}");
                }
                XPathProcessorImpl.indent(n2);
                System.out.println("}");
                if (xPath.m_opMap[n] != -1) {
                    System.out.println(XSLMessages.createXPATHMessage(41, null));
                }
                ++n;
                break;
            }
            case 28: {
                System.out.println("OP_LOCATIONPATH {");
                int n6 = n + xPath.m_opMap[n + 1] - 1;
                n += 2;
                while (n < n6) {
                    n = XPathProcessorImpl.diagnoseXPath(xPath, n, n2 + 1);
                }
                XPathProcessorImpl.indent(n2);
                System.out.println("}");
                if (xPath.m_opMap[n] != -1) {
                    System.out.println(XSLMessages.createXPATHMessage(41, null));
                }
                ++n;
                break;
            }
            case 29: {
                n = XPathProcessorImpl.diagnoseXPathUnaryOperation("OP_PREDICATE", xPath, n, n2);
                if (xPath.m_opMap[n] != -1) {
                    System.out.println("ERROR! Could not find ENDOP after OP_LOCATIONPATH");
                }
                ++n;
                break;
            }
            case 37: {
                n = XPathProcessorImpl.diagnoseXPathLocationStep("FROM_ANCESTORS", xPath, n, 1);
                break;
            }
            case 38: {
                n = XPathProcessorImpl.diagnoseXPathLocationStep("FROM_ANCESTORS_OR_SELF", xPath, n, 1);
                break;
            }
            case 39: {
                n = XPathProcessorImpl.diagnoseXPathLocationStep("FROM_ATTRIBUTES", xPath, n, 1);
                break;
            }
            case 40: {
                n = XPathProcessorImpl.diagnoseXPathLocationStep("FROM_CHILDREN", xPath, n, 1);
                break;
            }
            case 41: {
                n = XPathProcessorImpl.diagnoseXPathLocationStep("FROM_DESCENDANTS", xPath, n, 1);
                break;
            }
            case 42: {
                n = XPathProcessorImpl.diagnoseXPathLocationStep("FROM_DESCENDANTS_OR_SELF", xPath, n, 1);
                break;
            }
            case 43: {
                n = XPathProcessorImpl.diagnoseXPathLocationStep("FROM_FOLLOWING", xPath, n, n2);
                break;
            }
            case 44: {
                n = XPathProcessorImpl.diagnoseXPathLocationStep("FROM_FOLLOWING_SIBLINGS", xPath, n, n2);
                break;
            }
            case 45: {
                n = XPathProcessorImpl.diagnoseXPathLocationStep("FROM_PARENT", xPath, n, n2);
                break;
            }
            case 46: {
                n = XPathProcessorImpl.diagnoseXPathLocationStep("FROM_PRECEDING", xPath, n, n2);
                break;
            }
            case 47: {
                n = XPathProcessorImpl.diagnoseXPathLocationStep("FROM_PRECEDING_SIBLINGS", xPath, n, n2);
                break;
            }
            case 48: {
                n = XPathProcessorImpl.diagnoseXPathLocationStep("FROM_SELF", xPath, n, n2);
                break;
            }
            case 49: {
                n = XPathProcessorImpl.diagnoseXPathLocationStep("FROM_NAMESPACE", xPath, n, n2);
                break;
            }
            case 55: {
                n = XPathProcessorImpl.diagnoseXPathLocationStep("FROM_ROOT", xPath, n, n2);
                break;
            }
            case 1030: {
                System.out.println("{NODETYPE_COMMENT}");
                ++n;
                break;
            }
            case 1031: {
                System.out.println("{NODETYPE_TEXT}");
                ++n;
                break;
            }
            case 1032: {
                int n7 = xPath.m_opMap[n - 1];
                System.out.println("{NODETYPE_PI ");
                ++n;
                if (n7 <= 3) break;
                n = XPathProcessorImpl.diagnoseToken(xPath, n);
                break;
            }
            case 1033: {
                System.out.println("{NODETYPE_NODE}");
                ++n;
                break;
            }
            case 35: {
                System.out.println("{NODETYPE_ROOT}");
                ++n;
                break;
            }
            case 36: {
                System.out.println("{NODETYPE_ANYELEMENT}");
                ++n;
                break;
            }
            case 34: {
                System.out.print("{NODENAME ");
                if (xPath.m_opMap[++n] < 0) {
                    System.out.print("{EMPTY}");
                    ++n;
                } else {
                    n = XPathProcessorImpl.diagnoseToken(xPath, n);
                }
                System.out.print(":");
                n = XPathProcessorImpl.diagnoseToken(xPath, n);
                break;
            }
            default: {
                System.out.println(XSLMessages.createXPATHMessage(42, new Object[]{Integer.toString(xPath.m_opMap[n])}));
            }
        }
        return n;
    }

    static void indent(int n) {
        int n2 = n * 3;
        int n3 = 0;
        while (n3 < n2) {
            System.out.print(" ");
            ++n3;
        }
    }

    public static void diagnoseXPathString2(String string) throws SAXException {
        XPathSupportDefault xPathSupportDefault = new XPathSupportDefault();
        XPathProcessorImpl xPathProcessorImpl = new XPathProcessorImpl(xPathSupportDefault);
        XPath xPath = new XPath(xPathSupportDefault, new ProblemListenerDefault());
        xPathProcessorImpl.initXPath(xPath, string, null);
        XPathProcessorImpl.diagnoseXPath2(xPath, 0, 0);
    }

    public static void diagnoseXPathString3(String string) throws SAXException {
        XPathSupportDefault xPathSupportDefault = new XPathSupportDefault();
        XPathProcessorImpl xPathProcessorImpl = new XPathProcessorImpl(xPathSupportDefault);
        XPath xPath = new XPath(xPathSupportDefault, new ProblemListenerDefault());
        xPathProcessorImpl.initXPath(xPath, string, null);
        int n = xPath.m_opMap[1];
        int n2 = 0;
        while (n2 < n) {
            System.out.println("[" + xPath.m_opMap[n2] + "]");
            ++n2;
        }
    }

    private static void diagnoseNodeTest2(int n, String string) {
        System.out.print(String.valueOf(m_nTestLabel) + string + m_close);
    }

    private static void diagnoseOpNoLable2(int n, String string) {
        System.out.println(String.valueOf(m_noLabel) + string + m_close);
    }

    private static void diagnoseOpOnly2(int n, String string) {
        System.out.println(String.valueOf(m_opLabel) + string + m_close);
    }

    private static void diagnoseOp2(String string, XPath xPath, int n) {
        System.out.print(String.valueOf(m_opLabel) + string + m_close);
        int n2 = xPath.m_opMap[n + 1];
        System.out.println(String.valueOf(m_open) + n2 + m_close);
    }

    private static void diagnoseOp2SameLine(String string, XPath xPath, int n) {
        System.out.print(String.valueOf(m_opLabel) + string + m_close);
        int n2 = xPath.m_opMap[n + 1];
        System.out.print(String.valueOf(m_open) + n2 + m_close);
    }

    static int diagnoseXPathBinaryOperation2(String string, XPath xPath, int n, int n2) {
        XPathProcessorImpl.diagnoseOp2(string, xPath, n);
        n += 2;
        n = XPathProcessorImpl.diagnoseXPath2(xPath, n, n2 + 1);
        n = XPathProcessorImpl.diagnoseXPath2(xPath, n, n2 + 1);
        return n;
    }

    static int diagnoseXPathUnaryOperation2(String string, XPath xPath, int n, int n2) {
        XPathProcessorImpl.diagnoseOp2(string, xPath, n);
        n += 2;
        n = XPathProcessorImpl.diagnoseXPath2(xPath, n, n2 + 1);
        return n;
    }

    static int diagnoseXPathMultiOperation2(String string, int n, XPath xPath, int n2, int n3) {
        XPathProcessorImpl.diagnoseOp2(string, xPath, n2);
        n2 += 2;
        while (xPath.m_opMap[n2] == n) {
            n2 = XPathProcessorImpl.diagnoseXPath2(xPath, n2, n3 + 2);
        }
        return n2;
    }

    static int diagnoseToken2(XPath xPath, int n) {
        int n2 = xPath.m_opMap[n];
        String string = n2 >= 0 ? xPath.m_tokenQueue[n2].toString() : (n2 == -3 ? "*" : (n2 == -2 ? "EMPTY" : "UNKNOWN"));
        System.out.println(String.valueOf(m_noLabel) + string + m_close);
        return n + 1;
    }

    static int diagnoseToken2SameLine(XPath xPath, int n) {
        System.out.print(String.valueOf(m_noLabel) + xPath.m_tokenQueue[xPath.m_opMap[n]] + m_close);
        return n + 1;
    }

    static int diagnoseXPathSimpleOperation2(String string, XPath xPath, int n, int n2) {
        XPathProcessorImpl.diagnoseOp2SameLine(string, xPath, n);
        n += 2;
        n = XPathProcessorImpl.diagnoseToken2(xPath, n);
        return n;
    }

    static int diagnoseXPathLocationStep2(String string, XPath xPath, int n, int n2) {
        int n3 = xPath.m_opMap[n + 1];
        int n4 = xPath.m_opMap[n + 1 + 1];
        System.out.print(String.valueOf(m_opLabel) + string + m_close);
        System.out.print(String.valueOf(m_open) + n3 + m_close);
        System.out.print(String.valueOf(m_open) + n4 + m_close);
        n += 3;
        if (n4 > 3) {
            n = XPathProcessorImpl.diagnoseXPath2(xPath, n, 0);
        }
        return n;
    }

    static int diagnoseXPath2(XPath xPath, int n, int n2) {
        XPathProcessorImpl.indent(n2);
        switch (xPath.m_opMap[n]) {
            case 1: {
                n = XPathProcessorImpl.diagnoseXPathUnaryOperation2("OP_XPATH", xPath, n, n2);
                break;
            }
            case -2: {
                XPathProcessorImpl.diagnoseOpOnly2(n, "EMPTY");
                ++n;
                break;
            }
            case 2: {
                n = XPathProcessorImpl.diagnoseXPathBinaryOperation2("OP_OR", xPath, n, n2);
                break;
            }
            case 3: {
                n = XPathProcessorImpl.diagnoseXPathBinaryOperation2("OP_AND", xPath, n, n2);
                break;
            }
            case 4: {
                n = XPathProcessorImpl.diagnoseXPathBinaryOperation2("OP_NOTEQUALS", xPath, n, n2);
                break;
            }
            case 5: {
                n = XPathProcessorImpl.diagnoseXPathBinaryOperation2("OP_EQUALS", xPath, n, n2);
                break;
            }
            case 6: {
                n = XPathProcessorImpl.diagnoseXPathBinaryOperation2("OP_LTE", xPath, n, n2);
                break;
            }
            case 7: {
                n = XPathProcessorImpl.diagnoseXPathBinaryOperation2("OP_LT", xPath, n, n2);
                break;
            }
            case 8: {
                n = XPathProcessorImpl.diagnoseXPathBinaryOperation2("OP_GTE", xPath, n, n2);
                break;
            }
            case 9: {
                n = XPathProcessorImpl.diagnoseXPathBinaryOperation2("OP_GT", xPath, n, n2);
                break;
            }
            case 10: {
                n = XPathProcessorImpl.diagnoseXPathBinaryOperation2("OP_PLUS", xPath, n, n2);
                break;
            }
            case 11: {
                n = XPathProcessorImpl.diagnoseXPathBinaryOperation2("OP_MINUS", xPath, n, n2);
                break;
            }
            case 12: {
                n = XPathProcessorImpl.diagnoseXPathBinaryOperation2("OP_MULT", xPath, n, n2);
                break;
            }
            case 13: {
                n = XPathProcessorImpl.diagnoseXPathBinaryOperation2("OP_DIV", xPath, n, n2);
                break;
            }
            case 14: {
                n = XPathProcessorImpl.diagnoseXPathBinaryOperation2("OP_MOD", xPath, n, n2);
                break;
            }
            case 15: {
                n = XPathProcessorImpl.diagnoseXPathBinaryOperation2("OP_QUO", xPath, n, n2);
                break;
            }
            case 16: {
                n = XPathProcessorImpl.diagnoseXPathUnaryOperation2("OP_NEG", xPath, n, n2);
                break;
            }
            case 17: {
                n = XPathProcessorImpl.diagnoseXPathUnaryOperation2("OP_STRING", xPath, n, n2);
                break;
            }
            case 18: {
                n = XPathProcessorImpl.diagnoseXPathUnaryOperation2("OP_BOOL", xPath, n, n2);
                break;
            }
            case 19: {
                n = XPathProcessorImpl.diagnoseXPathUnaryOperation2("OP_NUMBER", xPath, n, n2);
                break;
            }
            case 20: {
                n = XPathProcessorImpl.diagnoseXPathMultiOperation2("OP_UNION", 28, xPath, n, n2);
                break;
            }
            case 21: {
                n = XPathProcessorImpl.diagnoseXPathSimpleOperation2("OP_LITERAL", xPath, n, n2);
                break;
            }
            case 22: {
                n = XPathProcessorImpl.diagnoseXPathSimpleOperation2("OP_VARIABLE", xPath, n, n2);
                break;
            }
            case 23: {
                n = XPathProcessorImpl.diagnoseXPathUnaryOperation2("OP_GROUP", xPath, n, n2);
                break;
            }
            case 24: {
                n = XPathProcessorImpl.diagnoseXPathSimpleOperation2("OP_NUMBERLIT", xPath, n, n2);
                break;
            }
            case 25: {
                n = XPathProcessorImpl.diagnoseXPathUnaryOperation2("OP_ARGUMENT", xPath, n, n2);
                break;
            }
            case 26: {
                XPathProcessorImpl.diagnoseOp2SameLine("OP_EXTFUNCTION", xPath, n);
                int n3 = n + xPath.m_opMap[n + 1] - 1;
                n += 2;
                n = XPathProcessorImpl.diagnoseToken2SameLine(xPath, n);
                n = XPathProcessorImpl.diagnoseToken2(xPath, n);
                while (n < n3) {
                    n = XPathProcessorImpl.diagnoseXPath2(xPath, n, n2 + 2);
                }
                if (xPath.m_opMap[n] != -1) {
                    System.out.println("ERROR! Could not find ENDOP after OP_LOCATIONPATH");
                }
                XPathProcessorImpl.indent(n2 + 1);
                XPathProcessorImpl.diagnoseOpOnly2(n, "ENDOP");
                ++n;
                break;
            }
            case 27: {
                XPathProcessorImpl.diagnoseOp2SameLine("OP_FUNCTION", xPath, n);
                int n4 = n + xPath.m_opMap[n + 1] - 1;
                int n5 = xPath.m_opMap[n += 2];
                switch (n5) {
                    case 1: {
                        XPathProcessorImpl.diagnoseOpNoLable2(n, "FUNC_LAST");
                        break;
                    }
                    case 2: {
                        XPathProcessorImpl.diagnoseOpNoLable2(n, "FUNC_POSITION");
                        break;
                    }
                    case 3: {
                        XPathProcessorImpl.diagnoseOpNoLable2(n, "FUNC_COUNT");
                        break;
                    }
                    case 4: {
                        XPathProcessorImpl.diagnoseOpNoLable2(n, "FUNC_ID");
                        break;
                    }
                    case 5: {
                        XPathProcessorImpl.diagnoseOpNoLable2(n, "FUNC_KEY");
                        break;
                    }
                    case 7: {
                        XPathProcessorImpl.diagnoseOpNoLable2(n, "FUNC_LOCAL_PART");
                        break;
                    }
                    case 8: {
                        XPathProcessorImpl.diagnoseOpNoLable2(n, "FUNC_NAMESPACE");
                        break;
                    }
                    case 9: {
                        XPathProcessorImpl.diagnoseOpNoLable2(n, "FUNC_QNAME");
                        break;
                    }
                    case 10: {
                        XPathProcessorImpl.diagnoseOpNoLable2(n, "FUNC_GENERATE_ID");
                        break;
                    }
                    case 11: {
                        XPathProcessorImpl.diagnoseOpNoLable2(n, "FUNC_NOT");
                        break;
                    }
                    case 12: {
                        XPathProcessorImpl.diagnoseOpNoLable2(n, "FUNC_TRUE");
                        break;
                    }
                    case 13: {
                        XPathProcessorImpl.diagnoseOpNoLable2(n, "FUNC_FALSE");
                        break;
                    }
                    case 14: {
                        XPathProcessorImpl.diagnoseOpNoLable2(n, "FUNC_BOOLEAN");
                        break;
                    }
                    case 32: {
                        XPathProcessorImpl.diagnoseOpNoLable2(n, "FUNC_LANG");
                        break;
                    }
                    case 15: {
                        XPathProcessorImpl.diagnoseOpNoLable2(n, "FUNC_NUMBER");
                        break;
                    }
                    case 16: {
                        XPathProcessorImpl.diagnoseOpNoLable2(n, "FUNC_FLOOR");
                        break;
                    }
                    case 17: {
                        XPathProcessorImpl.diagnoseOpNoLable2(n, "FUNC_CEILING");
                        break;
                    }
                    case 18: {
                        XPathProcessorImpl.diagnoseOpNoLable2(n, "FUNC_ROUND");
                        break;
                    }
                    case 19: {
                        XPathProcessorImpl.diagnoseOpNoLable2(n, "FUNC_SUM");
                        break;
                    }
                    case 20: {
                        XPathProcessorImpl.diagnoseOpNoLable2(n, "FUNC_STRING");
                        break;
                    }
                    case 21: {
                        XPathProcessorImpl.diagnoseOpNoLable2(n, "FUNC_STARTS_WITH");
                        break;
                    }
                    case 22: {
                        XPathProcessorImpl.diagnoseOpNoLable2(n, "FUNC_CONTAINS");
                        break;
                    }
                    case 23: {
                        XPathProcessorImpl.diagnoseOpNoLable2(n, "FUNC_SUBSTRING_BEFORE");
                        break;
                    }
                    case 24: {
                        XPathProcessorImpl.diagnoseOpNoLable2(n, "FUNC_SUBSTRING_AFTER");
                        break;
                    }
                    case 25: {
                        XPathProcessorImpl.diagnoseOpNoLable2(n, "FUNC_NORMALIZE_SPACE");
                        break;
                    }
                    case 26: {
                        XPathProcessorImpl.diagnoseOpNoLable2(n, "FUNC_TRANSLATE");
                        break;
                    }
                    case 27: {
                        XPathProcessorImpl.diagnoseOpNoLable2(n, "FUNC_CONCAT");
                        break;
                    }
                    case 31: {
                        XPathProcessorImpl.diagnoseOpNoLable2(n, "FUNC_SYSTEM_PROPERTY");
                        break;
                    }
                    case 33: {
                        XPathProcessorImpl.diagnoseOpNoLable2(n, "FUNC_EXT_FUNCTION_AVAILABLE");
                        break;
                    }
                    case 34: {
                        XPathProcessorImpl.diagnoseOpNoLable2(n, "FUNC_EXT_ELEM_AVAILABLE");
                        break;
                    }
                    case 29: {
                        XPathProcessorImpl.diagnoseOpNoLable2(n, "FUNC_SUBSTRING");
                        break;
                    }
                    case 30: {
                        XPathProcessorImpl.diagnoseOpNoLable2(n, "FUNC_STRING_LENGTH");
                        break;
                    }
                    case 35: {
                        XPathProcessorImpl.diagnoseOpNoLable2(n, "FUNC_DOCLOCATION");
                        break;
                    }
                }
                ++n;
                while (n < n4) {
                    n = XPathProcessorImpl.diagnoseXPath2(xPath, n, n2 + 2);
                }
                XPathProcessorImpl.indent(n2);
                if (xPath.m_opMap[n] != -1) {
                    System.out.println(XSLMessages.createXPATHMessage(41, null));
                }
                XPathProcessorImpl.indent(n2 + 1);
                XPathProcessorImpl.diagnoseOpOnly2(n, "ENDOP");
                ++n;
                break;
            }
            case 28: {
                XPathProcessorImpl.diagnoseOp2("OP_LOCATIONPATH", xPath, n);
                int n6 = n + xPath.m_opMap[n + 1] - 1;
                n += 2;
                while (n < n6) {
                    n = XPathProcessorImpl.diagnoseXPath2(xPath, n, n2 + 1);
                }
                if (xPath.m_opMap[n] != -1) {
                    System.out.println(XSLMessages.createXPATHMessage(41, null));
                }
                XPathProcessorImpl.indent(n2 + 1);
                XPathProcessorImpl.diagnoseOpOnly2(n, "ENDOP");
                ++n;
                break;
            }
            case 29: {
                XPathProcessorImpl.indent(1);
                n = XPathProcessorImpl.diagnoseXPathUnaryOperation2("OP_PREDICATE", xPath, n, n2 + 1);
                if (xPath.m_opMap[n] != -1) {
                    System.out.println("ERROR! Could not find ENDOP after OP_LOCATIONPATH");
                }
                XPathProcessorImpl.indent(n2 + 2);
                XPathProcessorImpl.diagnoseOpOnly2(n, "ENDOP");
                ++n;
                break;
            }
            case 37: {
                n = XPathProcessorImpl.diagnoseXPathLocationStep2("FROM_ANCESTORS", xPath, n, 1);
                break;
            }
            case 38: {
                n = XPathProcessorImpl.diagnoseXPathLocationStep2("FROM_ANCESTORS_OR_SELF", xPath, n, 1);
                break;
            }
            case 39: {
                n = XPathProcessorImpl.diagnoseXPathLocationStep2("FROM_ATTRIBUTES", xPath, n, 1);
                break;
            }
            case 40: {
                n = XPathProcessorImpl.diagnoseXPathLocationStep2("FROM_CHILDREN", xPath, n, 1);
                break;
            }
            case 41: {
                n = XPathProcessorImpl.diagnoseXPathLocationStep2("FROM_DESCENDANTS", xPath, n, 1);
                break;
            }
            case 42: {
                n = XPathProcessorImpl.diagnoseXPathLocationStep2("FROM_DESCENDANTS_OR_SELF", xPath, n, 1);
                break;
            }
            case 43: {
                n = XPathProcessorImpl.diagnoseXPathLocationStep2("FROM_FOLLOWING", xPath, n, n2);
                break;
            }
            case 44: {
                n = XPathProcessorImpl.diagnoseXPathLocationStep2("FROM_FOLLOWING_SIBLINGS", xPath, n, n2);
                break;
            }
            case 45: {
                n = XPathProcessorImpl.diagnoseXPathLocationStep2("FROM_PARENT", xPath, n, n2);
                break;
            }
            case 46: {
                n = XPathProcessorImpl.diagnoseXPathLocationStep2("FROM_PRECEDING", xPath, n, n2);
                break;
            }
            case 47: {
                n = XPathProcessorImpl.diagnoseXPathLocationStep2("FROM_PRECEDING_SIBLINGS", xPath, n, n2);
                break;
            }
            case 48: {
                n = XPathProcessorImpl.diagnoseXPathLocationStep2("FROM_SELF", xPath, n, n2);
                break;
            }
            case 49: {
                n = XPathProcessorImpl.diagnoseXPathLocationStep2("FROM_NAMESPACE", xPath, n, n2);
                break;
            }
            case 55: {
                n = XPathProcessorImpl.diagnoseXPathLocationStep2("FROM_ROOT", xPath, n, n2);
                break;
            }
            case 1030: {
                XPathProcessorImpl.diagnoseNodeTest2(n, "NODETYPE_COMMENT");
                System.out.println();
                ++n;
                break;
            }
            case 1031: {
                XPathProcessorImpl.diagnoseNodeTest2(n, "NODETYPE_TEXT");
                System.out.println();
                ++n;
                break;
            }
            case 1032: {
                int n7 = xPath.m_opMap[n - 1];
                XPathProcessorImpl.diagnoseNodeTest2(n, "NODETYPE_PI");
                ++n;
                if (n7 <= 3) break;
                n = XPathProcessorImpl.diagnoseToken(xPath, n);
                break;
            }
            case 1033: {
                XPathProcessorImpl.diagnoseNodeTest2(n, "NODETYPE_NODE");
                System.out.println();
                ++n;
                break;
            }
            case 35: {
                XPathProcessorImpl.diagnoseNodeTest2(n, "NODETYPE_ROOT");
                System.out.println();
                ++n;
                break;
            }
            case 36: {
                XPathProcessorImpl.diagnoseNodeTest2(n, "NODETYPE_ANYELEMENT");
                System.out.println();
                ++n;
                break;
            }
            case 34: {
                XPathProcessorImpl.diagnoseNodeTest2(n, "NODENAME");
                if (xPath.m_opMap[++n] < 0) {
                    System.out.print(String.valueOf(m_noLabel) + "EMPTY" + m_close);
                    ++n;
                } else {
                    n = XPathProcessorImpl.diagnoseToken2(xPath, n);
                }
                n = XPathProcessorImpl.diagnoseToken2(xPath, n);
                break;
            }
            default: {
                System.out.println(XSLMessages.createXPATHMessage(42, new Object[]{Integer.toString(xPath.m_opMap[n])}));
            }
        }
        return n;
    }

    static {
        m_axisnames.put(new StringKey(FROM_ANCESTORS_STRING), new Integer(37));
        m_axisnames.put(new StringKey(FROM_ANCESTORS_OR_SELF_STRING), new Integer(38));
        m_axisnames.put(new StringKey(FROM_ATTRIBUTES_STRING), new Integer(39));
        m_axisnames.put(new StringKey(FROM_CHILDREN_STRING), new Integer(40));
        m_axisnames.put(new StringKey(FROM_DESCENDANTS_STRING), new Integer(41));
        m_axisnames.put(new StringKey(FROM_DESCENDANTS_OR_SELF_STRING), new Integer(42));
        m_axisnames.put(new StringKey(FROM_FOLLOWING_STRING), new Integer(43));
        m_axisnames.put(new StringKey(FROM_FOLLOWING_SIBLINGS_STRING), new Integer(44));
        m_axisnames.put(new StringKey(FROM_PARENT_STRING), new Integer(45));
        m_axisnames.put(new StringKey(FROM_PRECEDING_STRING), new Integer(46));
        m_axisnames.put(new StringKey(FROM_PRECEDING_SIBLINGS_STRING), new Integer(47));
        m_axisnames.put(new StringKey(FROM_SELF_STRING), new Integer(48));
        m_axisnames.put(new StringKey(FROM_NAMESPACE_STRING), new Integer(49));
        m_nodetypes.put(new StringKey(NODETYPE_COMMENT_STRING), new Integer(1030));
        m_nodetypes.put(new StringKey(NODETYPE_TEXT_STRING), new Integer(1031));
        m_nodetypes.put(new StringKey(NODETYPE_PI_STRING), new Integer(1032));
        m_nodetypes.put(new StringKey(NODETYPE_NODE_STRING), new Integer(1033));
        m_nodetypes.put(new StringKey("*"), new Integer(36));
        m_keywords.put(new StringKey(FROM_SELF_ABBREVIATED_STRING), new Integer(48));
        m_keywords.put(new StringKey("id"), new Integer(4));
        m_keywords.put(new StringKey(FUNC_KEY_STRING), new Integer(5));
        m_functions.put(new StringKey(FUNC_CURRENT_STRING), new Integer(0));
        m_functions.put(new StringKey(FUNC_LAST_STRING), new Integer(1));
        m_functions.put(new StringKey(FUNC_POSITION_STRING), new Integer(2));
        m_functions.put(new StringKey(FUNC_COUNT_STRING), new Integer(3));
        m_functions.put(new StringKey("id"), new Integer(4));
        m_functions.put(new StringKey(FUNC_KEY_STRING), new Integer(5));
        m_functions.put(new StringKey(FUNC_LOCAL_PART_STRING), new Integer(7));
        m_functions.put(new StringKey(FUNC_NAMESPACE_STRING), new Integer(8));
        m_functions.put(new StringKey(FUNC_NAME_STRING), new Integer(9));
        m_functions.put(new StringKey(FUNC_GENERATE_ID_STRING), new Integer(10));
        m_functions.put(new StringKey(FUNC_NOT_STRING), new Integer(11));
        m_functions.put(new StringKey(FUNC_TRUE_STRING), new Integer(12));
        m_functions.put(new StringKey(FUNC_FALSE_STRING), new Integer(13));
        m_functions.put(new StringKey(FUNC_BOOLEAN_STRING), new Integer(14));
        m_functions.put(new StringKey(FUNC_LANG_STRING), new Integer(32));
        m_functions.put(new StringKey(FUNC_NUMBER_STRING), new Integer(15));
        m_functions.put(new StringKey(FUNC_FLOOR_STRING), new Integer(16));
        m_functions.put(new StringKey(FUNC_CEILING_STRING), new Integer(17));
        m_functions.put(new StringKey(FUNC_ROUND_STRING), new Integer(18));
        m_functions.put(new StringKey(FUNC_SUM_STRING), new Integer(19));
        m_functions.put(new StringKey(FUNC_STRING_STRING), new Integer(20));
        m_functions.put(new StringKey(FUNC_STARTS_WITH_STRING), new Integer(21));
        m_functions.put(new StringKey(FUNC_CONTAINS_STRING), new Integer(22));
        m_functions.put(new StringKey(FUNC_SUBSTRING_BEFORE_STRING), new Integer(23));
        m_functions.put(new StringKey(FUNC_SUBSTRING_AFTER_STRING), new Integer(24));
        m_functions.put(new StringKey(FUNC_NORMALIZE_SPACE_STRING), new Integer(25));
        m_functions.put(new StringKey(FUNC_TRANSLATE_STRING), new Integer(26));
        m_functions.put(new StringKey(FUNC_CONCAT_STRING), new Integer(27));
        m_functions.put(new StringKey(FUNC_SYSTEM_PROPERTY_STRING), new Integer(31));
        m_functions.put(new StringKey(FUNC_EXT_FUNCTION_AVAILABLE_STRING), new Integer(33));
        m_functions.put(new StringKey(FUNC_EXT_ELEM_AVAILABLE_STRING), new Integer(34));
        m_functions.put(new StringKey(FUNC_SUBSTRING_STRING), new Integer(29));
        m_functions.put(new StringKey(FUNC_STRING_LENGTH_STRING), new Integer(30));
        m_functions.put(new StringKey(FUNC_UNPARSED_ENTITY_URI_STRING), new Integer(36));
        m_functions.put(new StringKey(NODETYPE_COMMENT_STRING), new Integer(1030));
        m_functions.put(new StringKey(NODETYPE_TEXT_STRING), new Integer(1031));
        m_functions.put(new StringKey(NODETYPE_PI_STRING), new Integer(1032));
        m_functions.put(new StringKey(NODETYPE_NODE_STRING), new Integer(1033));
        m_functions.put(new StringKey(FUNC_DOCLOCATION_STRING), new Integer(35));
        m_opLabel = "[";
        m_lenLabel = "[";
        m_arglenLabel = "[";
        m_noLabel = "[";
        m_nTestLabel = "[";
        m_open = "[";
        m_close = "]";
    }
}

