/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xpath.xdom;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.StringTokenizer;
import org.apache.xalan.xpath.XPathEnvSupport;
import org.apache.xalan.xpath.XPathSupport;
import org.apache.xalan.xpath.xml.DefaultErrorHandler;
import org.apache.xalan.xpath.xml.XMLParserLiaisonDefault;
import org.apache.xerces.dom.AttrImpl;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.dom.NodeImpl;
import org.apache.xerces.dom.TextImpl;
import org.apache.xerces.framework.XMLErrorReporter;
import org.apache.xerces.framework.XMLParser;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.parsers.SAXParser;
import org.apache.xerces.readers.XMLEntityHandler;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.validators.schema.XSchemaValidator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XercesLiaison
extends XMLParserLiaisonDefault
implements XPathSupport {
    public static final String XML4J_VERSION = "XML4J 2.0.15";
    private transient boolean m_didVersionCheck = false;
    private static final int MAJOR = 1;
    private static final int MINOR = 2;
    private static final int SUBMINOR = 3;
    static /* synthetic */ Class class$org$apache$xerces$framework$Version;

    public String getParserDescription() {
        return "XML4J Version " + this.getXML4JVersionString();
    }

    public XercesLiaison(ErrorHandler errorHandler) {
        this.m_errorHandler = errorHandler;
    }

    public XercesLiaison(XPathEnvSupport xPathEnvSupport) {
        this.m_envSupport = xPathEnvSupport;
    }

    public XercesLiaison() {
    }

    public void checkNode(Node node) throws SAXException {
        if (!(node instanceof NodeImpl)) {
            throw new SAXException("XercesLiaison can not handle nodes of type" + node.getClass());
        }
    }

    public boolean supportsSAX() {
        return true;
    }

    private String getXML4JVersionString() {
        String string = "";
        try {
            Field field = (class$org$apache$xerces$framework$Version != null ? class$org$apache$xerces$framework$Version : (class$org$apache$xerces$framework$Version = XercesLiaison.class$("org.apache.xerces.framework.Version"))).getField("fVersion");
            string = (String)field.get(null);
        }
        catch (Exception exception) {}
        return string;
    }

    private int getXML4JVersionNum(int n) {
        int n2 = 0;
        String string = this.getXML4JVersionString();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " .");
        int n3 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (n == n3) {
                n2 = Integer.parseInt(string2);
            }
            ++n3;
        }
        return n2;
    }

    public void checkXML4JVersion() {
        if (!this.m_didVersionCheck) {
            if (!this.getXML4JVersionString().equals(XML4J_VERSION)) {
                if (this.getXML4JVersionNum(1) == 2 && this.getXML4JVersionNum(2) == 0 && this.getXML4JVersionNum(3) >= 14 || this.getXML4JVersionNum(1) == 2 && this.getXML4JVersionNum(2) > 0 || this.getXML4JVersionNum(1) > 2) {
                    System.out.println("Found version " + this.getXML4JVersionString() + " of XML4J. \n" + "This version of XSLT4J is only tested with version " + XML4J_VERSION + " of XML4J! \n");
                } else {
                    System.out.println("Found version " + this.getXML4JVersionString() + " of XML4J. \n" + "This version of XSLT4J doesn't work with versions less than " + XML4J_VERSION + " of XML4J! \n");
                }
            }
            this.m_didVersionCheck = true;
        }
    }

    public void parse(InputSource inputSource) throws SAXException, IOException {
        Object object;
        boolean bl;
        Object object2 = null;
        if (this.m_docHandler == null) {
            bl = true;
            object = new MyParser();
            object.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
            object2 = object;
        } else {
            bl = false;
            object = new SAXParser();
            object.setDocumentHandler(this.m_docHandler);
            this.m_docHandler = null;
            object2 = object;
            if (this.m_DTDHandler != null) {
                object.setDTDHandler(this.m_DTDHandler);
            }
        }
        try {
            if (this.m_errorHandler != null) {
                object2.setErrorHandler(this.m_errorHandler);
            } else {
                object = inputSource.getSystemId() == null ? "Input XSL" : inputSource.getSystemId();
                object2.setErrorHandler((ErrorHandler)new DefaultErrorHandler((String)object));
            }
            if (this.m_entityResolver != null) {
                object2.setEntityResolver(this.m_entityResolver);
            }
            if (this.m_locale != null) {
                object2.setLocale(this.m_locale);
            }
            object2.parse(inputSource);
            if (bl) {
                this.m_document = ((DOMParser)object2).getDocument();
                if (inputSource.getSystemId() != null) {
                    this.getSourceDocsTable().put(inputSource.getSystemId(), this.m_document);
                    return;
                }
            }
        }
        catch (SAXException sAXException) {
            if (object2 != null) {
                throw new SAXException("XercesLiaison.parse error: SystemID - " + object2.getSystemId() + " line - " + object2.getLineNumber(), sAXException);
            }
            throw new SAXException("XercesLiaison.parse error", sAXException);
        }
    }

    public Document createDocument() {
        DocumentImpl documentImpl = new DocumentImpl();
        return documentImpl;
    }

    public Element getElementByID(String string, Document document) {
        return ((DocumentImpl)document).getIdentifier(string);
    }

    public boolean isIgnorableWhitespace(Text text) {
        boolean bl = text instanceof TextImpl ? ((TextImpl)text).isIgnorableWhitespace() : false;
        return bl;
    }

    public Node getParentOfNode(Node node) throws RuntimeException {
        if (node.getNodeType() == 2) {
            return ((AttrImpl)node).getElement();
        }
        return node.getParentNode();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class NullSchemaValidator
    extends XSchemaValidator {
        public NullSchemaValidator(StringPool stringPool, XMLErrorReporter xMLErrorReporter, XMLEntityHandler xMLEntityHandler) {
            super(stringPool, xMLErrorReporter, xMLEntityHandler);
            XercesLiaison.this = XercesLiaison.this;
        }

        public final void loadSchema(String string) {
        }
    }

    class MyParser
    extends DOMParser {
        protected XSchemaValidator getSchemaValidator() {
            if (((XMLParser)this).fSchemaValidator == null) {
                ((XMLParser)this).fSchemaValidator = new NullSchemaValidator(((XMLParser)this).fStringPool, ((XMLParser)this).fErrorReporter, ((XMLParser)this).fEntityHandler);
            }
            return ((XMLParser)this).fSchemaValidator;
        }

        MyParser() {
            XercesLiaison.this = XercesLiaison.this;
        }
    }
}

