/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xpath.xml;

import java.util.EmptyStackException;

public class BoolStack {
    private int m_blocksize;
    private boolean[] m_map;
    private int m_firstFree;
    private int m_mapSize;

    public BoolStack() {
        this.m_mapSize = this.m_blocksize = 32;
        this.m_map = new boolean[this.m_blocksize];
    }

    public BoolStack(int n) {
        this.m_blocksize = n;
        this.m_mapSize = n;
        this.m_map = new boolean[n];
    }

    public final int size() {
        return this.m_firstFree;
    }

    public final void addElement(boolean bl) {
        if (this.m_firstFree + 1 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize;
            boolean[] blArray = new boolean[this.m_mapSize];
            System.arraycopy(this.m_map, 0, blArray, 0, this.m_firstFree + 1);
            this.m_map = blArray;
        }
        this.m_map[this.m_firstFree] = bl;
        ++this.m_firstFree;
    }

    public final void insertElementAt(boolean bl, int n) {
        if (this.m_firstFree + 1 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize;
            boolean[] blArray = new boolean[this.m_mapSize];
            System.arraycopy(this.m_map, 0, blArray, 0, this.m_firstFree + 1);
            this.m_map = blArray;
        }
        if (n <= this.m_firstFree - 1) {
            System.arraycopy(this.m_map, n, this.m_map, n + 1, this.m_firstFree - n);
        }
        this.m_map[n] = bl;
        ++this.m_firstFree;
    }

    public final void removeAllElements() {
        int n = 0;
        while (n < this.m_firstFree) {
            this.m_map[n] = false;
            ++n;
        }
        this.m_firstFree = 0;
    }

    public final void removeElementAt(int n) {
        if (n > this.m_firstFree) {
            System.arraycopy(this.m_map, n + 1, this.m_map, n, this.m_firstFree);
        } else {
            this.m_map[n] = false;
        }
        --this.m_firstFree;
    }

    public final void setElementAt(boolean bl, int n) {
        this.m_map[n] = bl;
    }

    public final boolean elementAt(int n) {
        return this.m_map[n];
    }

    public final int lastIndexOf(boolean bl) {
        int n = this.m_firstFree - 1;
        while (n >= 0) {
            if (this.m_map[n] == bl) {
                return n;
            }
            --n;
        }
        return Integer.MIN_VALUE;
    }

    public boolean push(boolean bl) {
        this.addElement(bl);
        return bl;
    }

    public boolean pop() {
        int n = this.size();
        boolean bl = this.peek();
        this.removeElementAt(n - 1);
        return bl;
    }

    public boolean peek() {
        int n = this.size();
        if (n == 0) {
            return false;
        }
        return this.elementAt(n - 1);
    }

    public void setTop(boolean bl) {
        int n = this.size();
        if (n == 0) {
            throw new EmptyStackException();
        }
        this.setElementAt(bl, n - 1);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }
}

