/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xpath.xml;

import java.io.Writer;
import java.util.Stack;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class FormatterToDOM
implements DocumentHandler {
    Document m_doc;
    Node m_currentNode;
    public DocumentFragment m_docFrag;
    Stack m_elemStack = new Stack();

    public FormatterToDOM(Document document, Element element) {
        this.m_doc = document;
        this.m_currentNode = element;
    }

    public FormatterToDOM(Document document, DocumentFragment documentFragment) {
        this.m_doc = document;
        this.m_docFrag = documentFragment;
    }

    public FormatterToDOM(Document document) {
        this.m_doc = document;
    }

    public Node getRootNode() {
        if (this.m_docFrag != null) {
            return this.m_docFrag;
        }
        return this.m_doc;
    }

    public Writer getWriter() {
        return null;
    }

    private void append(Node node) {
        if (this.m_currentNode != null) {
            this.m_currentNode.appendChild(node);
            return;
        }
        if (this.m_docFrag != null) {
            this.m_docFrag.appendChild(node);
            return;
        }
        this.m_doc.appendChild(node);
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        Element element = this.m_doc.createElement(string);
        int n = attributeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            element.setAttribute(attributeList.getName(n2), attributeList.getValue(n2));
            ++n2;
        }
        this.append(element);
        this.m_elemStack.push(element);
        this.m_currentNode = element;
    }

    public void endElement(String string) throws SAXException {
        this.m_elemStack.pop();
        if (!this.m_elemStack.isEmpty()) {
            this.m_currentNode = (Element)this.m_elemStack.peek();
            return;
        }
        this.m_currentNode = null;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2);
        Text text = this.m_doc.createTextNode(string);
        this.append(text);
    }

    public void charactersRaw(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2);
        this.append(this.m_doc.createProcessingInstruction("xslt-next-is-raw", "formatter-to-dom"));
        this.append(this.m_doc.createTextNode(string));
    }

    public void entityReference(String string) throws SAXException {
        this.append(this.m_doc.createEntityReference(string));
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2);
        this.append(this.m_doc.createTextNode(string));
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this.append(this.m_doc.createProcessingInstruction(string, string2));
    }

    public void comment(String string) throws SAXException {
        this.append(this.m_doc.createComment(string));
    }

    public void cdata(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2);
        this.append(this.m_doc.createCDATASection(string));
    }
}

