/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xpath.xml;

public class IntVector {
    private int m_blocksize;
    private int[] m_map;
    private int m_firstFree;
    private int m_mapSize;

    public IntVector() {
        this.m_mapSize = this.m_blocksize = 32;
        this.m_map = new int[this.m_blocksize];
    }

    public IntVector(int n) {
        this.m_blocksize = n;
        this.m_mapSize = n;
        this.m_map = new int[n];
    }

    public final int size() {
        return this.m_firstFree;
    }

    public final void addElement(int n) {
        if (this.m_firstFree + 1 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize;
            int[] nArray = new int[this.m_mapSize];
            System.arraycopy(this.m_map, 0, nArray, 0, this.m_firstFree + 1);
            this.m_map = nArray;
        }
        this.m_map[this.m_firstFree] = n;
        ++this.m_firstFree;
    }

    public final void insertElementAt(int n, int n2) {
        if (this.m_firstFree + 1 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize;
            int[] nArray = new int[this.m_mapSize];
            System.arraycopy(this.m_map, 0, nArray, 0, this.m_firstFree + 1);
            this.m_map = nArray;
        }
        if (n2 <= this.m_firstFree - 1) {
            System.arraycopy(this.m_map, n2, this.m_map, n2 + 1, this.m_firstFree - n2);
        }
        this.m_map[n2] = n;
        ++this.m_firstFree;
    }

    public final void removeAllElements() {
        int n = 0;
        while (n < this.m_firstFree) {
            this.m_map[n] = Integer.MIN_VALUE;
            ++n;
        }
        this.m_firstFree = 0;
    }

    public final boolean removeElement(int n) {
        int n2 = 0;
        while (n2 < this.m_firstFree) {
            if (this.m_map[n2] == n) {
                if (n2 > this.m_firstFree) {
                    System.arraycopy(this.m_map, n2 + 1, this.m_map, n2 - 1, this.m_firstFree - n2);
                } else {
                    this.m_map[n2] = Integer.MIN_VALUE;
                }
                --this.m_firstFree;
                return true;
            }
            ++n2;
        }
        return false;
    }

    public final void removeElementAt(int n) {
        if (n > this.m_firstFree) {
            System.arraycopy(this.m_map, n + 1, this.m_map, n, this.m_firstFree);
        } else {
            this.m_map[n] = Integer.MIN_VALUE;
        }
        --this.m_firstFree;
    }

    public final void setElementAt(int n, int n2) {
        this.m_map[n2] = n;
    }

    public final int elementAt(int n) {
        return this.m_map[n];
    }

    public final boolean contains(int n) {
        int n2 = 0;
        while (n2 < this.m_firstFree) {
            if (this.m_map[n2] == n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public final int indexOf(int n, int n2) {
        int n3 = n2;
        while (n3 < this.m_firstFree) {
            if (this.m_map[n3] == n) {
                return n3;
            }
            ++n3;
        }
        return Integer.MIN_VALUE;
    }

    public final int indexOf(int n) {
        int n2 = 0;
        while (n2 < this.m_firstFree) {
            if (this.m_map[n2] == n) {
                return n2;
            }
            ++n2;
        }
        return Integer.MIN_VALUE;
    }

    public final int lastIndexOf(int n) {
        int n2 = this.m_firstFree - 1;
        while (n2 >= 0) {
            if (this.m_map[n2] == n) {
                return n2;
            }
            --n2;
        }
        return Integer.MIN_VALUE;
    }
}

