/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xslt;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.NoSuchElementException;
import org.apache.xalan.xslt.DecimalToRoman;
import org.apache.xalan.xslt.XSLProcessorException;
import org.apache.xalan.xslt.XSLTEngineImpl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NumeratorFormatter {
    protected Element m_xslNumberElement;
    NumberFormatStringTokenizer m_formatTokenizer;
    Locale m_locale;
    NumberFormat m_formatter;
    XSLTEngineImpl m_processor;
    private static final DecimalToRoman[] m_romanConvertTable = new DecimalToRoman[]{new DecimalToRoman(1000L, "M", 900L, "CM"), new DecimalToRoman(500L, "D", 400L, "CD"), new DecimalToRoman(100L, "C", 90L, "XC"), new DecimalToRoman(50L, "L", 40L, "XL"), new DecimalToRoman(10L, "X", 9L, "IX"), new DecimalToRoman(5L, "V", 4L, "IV"), new DecimalToRoman(1L, "I", 1L, "I")};
    private static final char[] m_alphaCountTable = new char[]{'Z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y'};

    NumeratorFormatter(Element element, XSLTEngineImpl xSLTEngineImpl) {
        this.m_xslNumberElement = element;
        this.m_processor = xSLTEngineImpl;
    }

    void processAttributes(Node node) throws XSLProcessorException, MalformedURLException, FileNotFoundException, IOException {
    }

    /*
     * Unable to fully structure code
     */
    String formatNumberList(int[] var1_1) {
        var2_2 = "";
        var3_3 = var1_1.length;
        var4_4 = 49;
        var5_5 = 1;
        var7_6 = "";
        var8_7 = null;
        var9_8 = this.m_formatter.format(0L);
        var10_9 = null;
        this.m_formatTokenizer.reset();
        var11_10 = 0;
        ** GOTO lbl63
        {
            block17: {
                if (var10_9 != null) {
                    var6_11 = var10_9;
                    var10_9 = null;
                } else {
                    var6_11 = this.m_formatTokenizer.nextToken();
                }
                if (!Character.isLetterOrDigit(var6_11.charAt(var6_11.length() - 1))) break block17;
                var5_5 = var6_11.length();
                var4_4 = var6_11.charAt(var5_5 - 1);
                ** GOTO lbl39
            }
            var7_6 = var6_11;
            while (this.m_formatTokenizer.hasMoreTokens()) {
                var10_9 = this.m_formatTokenizer.nextToken();
                if (Character.isLetterOrDigit(var10_9.charAt(0))) break;
                var7_6 = String.valueOf(var7_6) + var10_9;
                var10_9 = null;
            }
            if (!this.m_formatTokenizer.hasMoreTokens()) {
                var8_7 = var7_6;
                var13_14 = var12_12 = var7_6.length() - 1;
                while (var13_14 >= 0) {
                    if (!Character.isWhitespace(var7_6.charAt(var13_14))) break;
                    --var13_14;
                }
                var7_6 = var7_6.substring(0, var13_14 + 1);
            }
            do {
                if (this.m_formatTokenizer.hasMoreTokens()) continue block6;
lbl39:
                // 2 sources

                switch (var4_4) {
                    case 65: {
                        var2_2 = String.valueOf(var2_2) + var7_6 + this.int2alphaCount(var1_1[var11_10], NumeratorFormatter.m_alphaCountTable);
                        break;
                    }
                    case 97: {
                        var2_2 = String.valueOf(var2_2) + var7_6 + this.int2alphaCount(var1_1[var11_10], NumeratorFormatter.m_alphaCountTable).toLowerCase(this.m_locale);
                        break;
                    }
                    case 73: {
                        var2_2 = String.valueOf(var2_2) + var7_6 + this.long2roman(var1_1[var11_10], true);
                        break;
                    }
                    case 105: {
                        var2_2 = String.valueOf(var2_2) + var7_6 + this.long2roman(var1_1[var11_10], true).toLowerCase(this.m_locale);
                        break;
                    }
                    default: {
                        var12_13 = this.m_formatter.format(var1_1[var11_10]);
                        var13_14 = var5_5 - var12_13.length();
                        var2_2 = String.valueOf(var2_2) + var7_6;
                        var14_15 = 0;
                        while (var14_15 < var13_14) {
                            var2_2 = String.valueOf(var2_2) + var9_8;
                            ++var14_15;
                        }
                        var2_2 = String.valueOf(var2_2) + var12_13;
                    }
                }
                ++var11_10;
lbl63:
                // 2 sources

            } while (var11_10 < var3_3);
        }
        if (var8_7 == null) {
            var8_7 = "";
            while (this.m_formatTokenizer.hasMoreTokens()) {
                var10_9 = this.m_formatTokenizer.nextToken();
                var8_7 = Character.isLetterOrDigit(var10_9.charAt(0)) == false ? String.valueOf(var8_7) + var10_9 : "";
            }
        }
        if (var8_7 != null) {
            var2_2 = String.valueOf(var2_2) + var8_7;
        }
        return var2_2;
    }

    protected String int2alphaCount(int n, char[] cArray) {
        int n2 = cArray.length;
        char[] cArray2 = new char[100];
        int n3 = cArray2.length - 1;
        int n4 = 1;
        int n5 = 0;
        while ((n4 = (n + (n5 = n4 == 0 || n5 != 0 && n4 == n2 - 1 ? n2 - 1 : 0)) % n2) != 0 || (n /= n2) != 0) {
            cArray2[n3--] = cArray[n4];
            if (n > 0) continue;
        }
        return new String(cArray2, n3 + 1, cArray2.length - n3 - 1);
    }

    protected String long2roman(long l, boolean bl) {
        if (l <= 0L) {
            return "#E(" + l + ")";
        }
        String string = "";
        int n = 0;
        if (l <= 3999L) {
            while (true) {
                if (l >= NumeratorFormatter.m_romanConvertTable[n].m_postValue) {
                    string = String.valueOf(string) + NumeratorFormatter.m_romanConvertTable[n].m_postLetter;
                    l -= NumeratorFormatter.m_romanConvertTable[n].m_postValue;
                    continue;
                }
                if (bl && l >= NumeratorFormatter.m_romanConvertTable[n].m_preValue) {
                    string = String.valueOf(string) + NumeratorFormatter.m_romanConvertTable[n].m_preLetter;
                    l -= NumeratorFormatter.m_romanConvertTable[n].m_preValue;
                }
                ++n;
                if (l <= 0L) break;
            }
        } else {
            string = "#error";
        }
        return string;
    }

    class NumberFormatStringTokenizer {
        private int currentPosition;
        private int maxPosition;
        private String str;

        public NumberFormatStringTokenizer(String string) {
            NumeratorFormatter.this = NumeratorFormatter.this;
            this.str = string;
            this.maxPosition = string.length();
        }

        public void reset() {
            this.currentPosition = 0;
        }

        public String nextToken() {
            if (this.currentPosition >= this.maxPosition) {
                throw new NoSuchElementException();
            }
            int n = this.currentPosition;
            while (this.currentPosition < this.maxPosition && Character.isLetterOrDigit(this.str.charAt(this.currentPosition))) {
                ++this.currentPosition;
            }
            if (n == this.currentPosition && !Character.isLetterOrDigit(this.str.charAt(this.currentPosition))) {
                ++this.currentPosition;
            }
            return this.str.substring(n, this.currentPosition);
        }

        public boolean hasMoreTokens() {
            return this.currentPosition < this.maxPosition;
        }

        public int countTokens() {
            int n = 0;
            int n2 = this.currentPosition;
            while (n2 < this.maxPosition) {
                int n3 = n2;
                while (n2 < this.maxPosition && Character.isLetterOrDigit(this.str.charAt(n2))) {
                    ++n2;
                }
                if (n3 == n2 && !Character.isLetterOrDigit(this.str.charAt(n2))) {
                    ++n2;
                }
                ++n;
            }
            return n;
        }
    }
}

