/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xslt.client;

import java.applet.Applet;
import java.awt.Graphics;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.xalan.xpath.xml.XMLParserLiaison;
import org.apache.xalan.xslt.XSLProcessorException;
import org.apache.xalan.xslt.XSLTInputSource;
import org.apache.xalan.xslt.XSLTProcessor;
import org.apache.xalan.xslt.XSLTProcessorFactory;
import org.apache.xalan.xslt.XSLTResultTarget;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XSLTProcessorApplet
extends Applet {
    transient XMLParserLiaison m_liaison;
    XSLTProcessor m_processor;
    private String m_styleURL;
    private String m_documentURL;
    private final String PARAM_styleURL = "styleURL";
    private final String PARAM_documentURL = "documentURL";
    private final String PARAM_parser = "parser";
    private String whichParser;
    private String m_styleURLOfCached;
    private String m_documentURLOfCached;
    private URL m_codeBase;
    private URL m_documentBase;
    private Document m_docTree;
    private Document m_styleTree;
    private transient Thread m_callThread;
    private transient TrustedAgent m_trustedAgent;
    private transient Thread m_trustedWorker;
    private transient String m_htmlText;
    private transient String m_nameOfIDAttrOfElemToModify;
    private transient String m_elemIdToModify;
    private transient String m_attrNameToSet;
    private transient String m_attrValueToSet;
    transient String m_key;
    transient String m_expression;

    public String getAppletInfo() {
        return "Name: XSLTProcessorApplet\r\nAuthor: Scott Boag";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"styleURL", "String", "URL to a XSL style sheet"}, {"documentURL", "String", "URL to a XML document"}, {"parser", "String", "Which parser to use: XML4J or ANY"}};
        return stringArray;
    }

    public void init() {
        String string = this.getParameter("parser");
        this.whichParser = string != null ? string : "ANY";
        string = this.getParameter("styleURL");
        if (string != null) {
            this.setStyleURL(string);
        }
        if ((string = this.getParameter("documentURL")) != null) {
            this.setDocumentURL(string);
        }
        this.m_codeBase = this.getCodeBase();
        this.m_documentBase = this.getDocumentBase();
        this.resize(320, 240);
        this.initLiaison();
    }

    protected void initLiaison() {
        String string = "org.apache.xalan.xpath.dtm.DTMLiaison";
        try {
            Class<?> clazz = Class.forName(string);
            Constructor<?> constructor = clazz.getConstructor(null);
            this.m_liaison = (XMLParserLiaison)constructor.newInstance(null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        try {
            this.m_processor = XSLTProcessorFactory.getProcessor();
            this.m_processor.setDiagnosticsOutput(System.out);
            return;
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
            throw new RuntimeException(sAXException.getMessage());
        }
    }

    public void destroy() {
        if (this.m_trustedWorker != null) {
            this.m_trustedWorker.stop();
            this.m_trustedWorker = null;
        }
        this.m_styleURLOfCached = null;
        this.m_documentURLOfCached = null;
    }

    public void paint(Graphics graphics) {
    }

    public void start() {
        this.m_trustedAgent = new TrustedAgent();
        Thread thread = Thread.currentThread();
        this.m_trustedWorker = new Thread(thread.getThreadGroup(), this.m_trustedAgent);
        this.m_trustedWorker.start();
        try {
            this.showStatus("Causing XSLT4J and XML4J to Load and JIT...");
            StringReader stringReader = new StringReader("<?xml version='1.0'?><foo/>");
            StringReader stringReader2 = new StringReader("<?xml version='1.0'?><xsl:stylesheet xmlns:xsl='http://www.w3.org/1999/XSL/Transform'><xsl:template match='foo'><out/></xsl:template></xsl:stylesheet>");
            PrintWriter printWriter = new PrintWriter(new StringWriter());
            XSLTProcessor xSLTProcessor = this.m_processor;
            synchronized (xSLTProcessor) {
                this.m_processor.process(new XSLTInputSource(stringReader), new XSLTInputSource(stringReader2), new XSLTResultTarget(printWriter));
                this.showStatus("PRIMED the pump!");
            }
            this.showStatus("Ready to click!");
            return;
        }
        catch (Exception exception) {
            this.showStatus("Could not prime the pump!");
            System.out.println("Could not prime the pump!");
            exception.printStackTrace();
            return;
        }
    }

    public void stop() {
        if (this.m_trustedWorker != null) {
            this.m_trustedWorker.stop();
            this.m_trustedWorker = null;
        }
        this.m_styleURLOfCached = null;
        this.m_documentURLOfCached = null;
    }

    public void setStyleURL(String string) {
        this.m_styleURL = string;
    }

    public void setDocumentURL(String string) {
        this.m_documentURL = string;
    }

    public void freeCache() {
        this.m_styleURLOfCached = null;
        this.m_documentURLOfCached = null;
    }

    public void setStyleSheetAttribute(String string, String string2, String string3, String string4) {
        this.m_nameOfIDAttrOfElemToModify = string;
        this.m_elemIdToModify = string2;
        this.m_attrNameToSet = string3;
        this.m_attrValueToSet = string4;
    }

    public void setStylesheetParam(String string, String string2) {
        this.m_key = string;
        this.m_expression = string2;
    }

    public String escapeString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '<') {
                stringBuffer.append("&lt;");
            } else if (c == '>') {
                stringBuffer.append("&gt;");
            } else if (c == '&') {
                stringBuffer.append("&amp;");
            } else if (c >= '\ud800' && c < '\udc00') {
                int n3;
                if (n2 + 1 >= n) {
                    throw new RuntimeException("Invalid UTF-16 surrogate detected: " + Integer.toHexString(c) + " ?");
                }
                if ((n3 = string.charAt(++n2)) < 56320 || n3 >= 57344) {
                    throw new RuntimeException("Invalid UTF-16 surrogate detected: " + Integer.toHexString(c) + " " + Integer.toHexString(n3));
                }
                n3 = (c - 55296 << 10) + n3 - 56320 + 65536;
                stringBuffer.append("&#x");
                stringBuffer.append(Integer.toHexString(n3));
                stringBuffer.append(";");
            } else {
                stringBuffer.append(c);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public String getHtmlText() {
        this.m_trustedAgent.m_getData = true;
        this.m_callThread = Thread.currentThread();
        try {
            Thread thread = this.m_callThread;
            synchronized (thread) {
                this.m_callThread.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            System.out.println(interruptedException.getMessage());
        }
        return this.m_htmlText;
    }

    public String getTreeAsText(String string) throws IOException {
        String string2 = "";
        byte[] byArray = new byte[50000];
        try {
            int n;
            URL uRL = new URL(this.m_documentBase, string);
            InputStream inputStream = uRL.openStream();
            while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
                string2 = String.valueOf(string2) + new String(byArray, 0, n);
            }
            inputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    public String getSourceTreeAsText() throws Exception {
        return this.getTreeAsText(this.m_documentURL);
    }

    public String getStyleTreeAsText() throws Exception {
        return this.getTreeAsText(this.m_styleURL);
    }

    public String getResultTreeAsText() throws Exception {
        return this.escapeString(this.getHtmlText());
    }

    public String transformToHtml(String string, String string2) {
        if (string != null) {
            this.m_documentURL = string;
        }
        if (string2 != null) {
            this.m_styleURL = string2;
        }
        return this.getHtmlText();
    }

    public String transformToHtml(String string) {
        if (string != null) {
            this.m_documentURL = string;
        }
        this.m_styleURL = null;
        return this.getHtmlText();
    }

    private String doTransformation(XMLParserLiaison xMLParserLiaison, XSLTProcessor xSLTProcessor) throws XSLProcessorException, MalformedURLException, FileNotFoundException, IOException, SAXException {
        Object object;
        URL uRL = null;
        URL uRL2 = null;
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, false);
        if (this.m_key != null) {
            xSLTProcessor.setStylesheetParam(this.m_key, this.m_expression);
        }
        this.showStatus("Begin Transformation...");
        try {
            uRL = new URL(this.m_codeBase, this.m_documentURL);
            object = new XSLTInputSource(uRL.toString());
            Node node = this.m_processor.getSourceTreeFromInput((XSLTInputSource)object);
            uRL2 = new URL(this.m_codeBase, this.m_styleURL);
            XSLTInputSource xSLTInputSource = new XSLTInputSource(uRL2.toString());
            Node node2 = this.m_processor.getSourceTreeFromInput(xSLTInputSource);
            if (node == null) {
                System.out.println("XML Source Node is null");
            }
            if (node.getNodeType() == 9) {
                this.m_docTree = (Document)node;
            } else {
                System.out.println("XML source document node type is " + node.getNodeType());
            }
            if (node2.getNodeType() == 9) {
                this.m_styleTree = (Document)node2;
            } else {
                System.out.println("Stylesheet source document node type is " + node2.getNodeType());
            }
            xSLTProcessor.process((XSLTInputSource)object, xSLTInputSource, new XSLTResultTarget(printWriter));
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            System.exit(-1);
        }
        this.showStatus("Transformation Done!");
        object = stringWriter.toString();
        return object;
    }

    protected String processTransformation() throws Exception {
        String string;
        block6: {
            string = null;
            try {
                if (this.whichParser.trim().equals("XML4J") || this.whichParser.trim().equals("ANY")) {
                    this.showStatus("Waiting for XSLT4J and XML4J to finish loading and JITing...");
                    XSLTProcessor xSLTProcessor = this.m_processor;
                    synchronized (xSLTProcessor) {
                        this.m_processor.reset();
                        string = this.doTransformation(this.m_liaison, this.m_processor);
                        break block6;
                    }
                }
                System.out.println("XSLTProcessorApplet only works with XML4J at the moment!");
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                System.out.println("Can not find " + this.whichParser + " XML Processor!!");
            }
        }
        return string;
    }

    static /* synthetic */ Thread access$0(XSLTProcessorApplet xSLTProcessorApplet) {
        return xSLTProcessorApplet.m_trustedWorker;
    }

    static /* synthetic */ String access$1(XSLTProcessorApplet xSLTProcessorApplet) {
        return xSLTProcessorApplet.m_htmlText;
    }

    class TrustedAgent
    implements Runnable {
        public boolean m_getData = false;

        public void run() {
            while (true) {
                Thread.yield();
                if (this.m_getData) {
                    Thread thread;
                    Object var2_3;
                    try {
                        try {
                            this.m_getData = false;
                            XSLTProcessorApplet.this.m_htmlText = null;
                            XSLTProcessorApplet.this.m_htmlText = XSLTProcessorApplet.this.processTransformation();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        var2_3 = null;
                    }
                    catch (Throwable throwable) {
                        var2_3 = null;
                        thread = XSLTProcessorApplet.this.m_callThread;
                        synchronized (thread) {
                            XSLTProcessorApplet.this.m_callThread.notify();
                        }
                        throw throwable;
                    }
                    thread = XSLTProcessorApplet.this.m_callThread;
                    synchronized (thread) {
                        XSLTProcessorApplet.this.m_callThread.notify();
                    }
                }
                try {
                    Thread.sleep(50L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                    continue;
                }
                break;
            }
        }

        TrustedAgent() {
            XSLTProcessorApplet.this = XSLTProcessorApplet.this;
        }
    }
}

