/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xslt.extensions;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.Hashtable;
import org.apache.xalan.xpath.XObject;
import org.apache.xalan.xpath.XPathSupport;
import org.apache.xalan.xslt.ElemTemplateElement;
import org.apache.xalan.xslt.StylesheetRoot;
import org.apache.xalan.xslt.XSLProcessorContext;
import org.apache.xml.serialize.OutputFormat;
import org.w3c.dom.Element;
import org.xml.sax.DocumentHandler;
import org.xml.sax.SAXException;

public class Redirect {
    protected Hashtable m_formatterListeners = new Hashtable();
    protected Hashtable m_outputStreams = new Hashtable();

    public void open(XSLProcessorContext xSLProcessorContext, Element element) throws MalformedURLException, FileNotFoundException, IOException, SAXException {
        String string = this.getFilename(xSLProcessorContext, element);
        Object v = this.m_formatterListeners.get(string);
        if (v == null) {
            this.makeFormatterListener(xSLProcessorContext, string, true);
        }
    }

    public void write(XSLProcessorContext xSLProcessorContext, Element element) throws MalformedURLException, FileNotFoundException, IOException, SAXException {
        OutputStream outputStream;
        DocumentHandler documentHandler;
        String string = this.getFilename(xSLProcessorContext, element);
        Object v = this.m_formatterListeners.get(string);
        boolean bl = false;
        if (v == null) {
            documentHandler = this.makeFormatterListener(xSLProcessorContext, string, true);
        } else {
            bl = true;
            documentHandler = (DocumentHandler)v;
        }
        xSLProcessorContext.processor.writeChildren(documentHandler, xSLProcessorContext.stylesheetTree, (ElemTemplateElement)element, xSLProcessorContext.sourceTree, xSLProcessorContext.sourceNode, xSLProcessorContext.mode);
        if (!bl && (outputStream = (OutputStream)this.m_outputStreams.get(string)) != null) {
            outputStream.close();
            this.m_outputStreams.remove(string);
            this.m_formatterListeners.remove(string);
        }
    }

    public void close(XSLProcessorContext xSLProcessorContext, Element element) throws MalformedURLException, FileNotFoundException, IOException, SAXException {
        String string = this.getFilename(xSLProcessorContext, element);
        Object v = this.m_formatterListeners.get(string);
        if (v != null) {
            OutputStream outputStream = (OutputStream)this.m_outputStreams.get(string);
            if (outputStream != null) {
                outputStream.close();
                this.m_outputStreams.remove(string);
            }
            DocumentHandler documentHandler = (DocumentHandler)v;
            documentHandler.endDocument();
            this.m_formatterListeners.remove(string);
        }
    }

    private String getFilename(XSLProcessorContext xSLProcessorContext, Element element) throws MalformedURLException, FileNotFoundException, IOException, SAXException {
        String string;
        String string2 = element.getAttribute("select");
        if (string2 != null) {
            XPathSupport xPathSupport = xSLProcessorContext.processor.getExecContext();
            XObject xObject = xSLProcessorContext.processor.getStylesheet().evalXPathStr(xPathSupport, string2, xSLProcessorContext.sourceNode, xPathSupport.getNamespaceContext());
            string = xObject.str();
            if (string == null || string.length() == 0) {
                string = element.getAttribute("file");
            }
        } else {
            string = element.getAttribute("file");
        }
        if (string == null) {
            xSLProcessorContext.processor.error(element, xSLProcessorContext.sourceNode, 93);
        }
        return string;
    }

    private DocumentHandler makeFormatterListener(XSLProcessorContext xSLProcessorContext, String string, boolean bl) throws MalformedURLException, FileNotFoundException, IOException, SAXException {
        Serializable serializable;
        File file = new File(string);
        if (!file.isAbsolute() && xSLProcessorContext.processor.getOutputFileName() != null) {
            serializable = new File(xSLProcessorContext.processor.getOutputFileName());
            file = new File(((File)serializable).getParent(), string);
        }
        serializable = xSLProcessorContext.stylesheetTree.m_stylesheetRoot;
        OutputFormat outputFormat = ((StylesheetRoot)serializable).getOutputFormat();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        DocumentHandler documentHandler = ((StylesheetRoot)serializable).makeSAXSerializer(fileOutputStream, outputFormat);
        documentHandler.startDocument();
        if (bl) {
            this.m_outputStreams.put(string, fileOutputStream);
            this.m_formatterListeners.put(string, documentHandler);
        }
        return documentHandler;
    }
}

