/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serialize;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Vector;
import org.apache.xml.serialize.ElementState;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.Serializer;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Notation;
import org.xml.sax.AttributeList;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.misc.DeclHandler;
import org.xml.sax.misc.LexicalHandler;

abstract class BaseSerializer
extends Serializer
implements DocumentHandler,
LexicalHandler,
DTDHandler,
DeclHandler {
    private int _lastPrintable = 126;
    protected OutputFormat _format;
    private Writer _writer;
    private StringBuffer _line;
    private StringBuffer _text;
    private int _spaces;
    private int _thisIndent;
    private int _nextIndent;
    protected IOException _exception;
    private ElementState[] _elementStates = new ElementState[5];
    private int _elementStateCount;
    private Vector _preRoot;
    protected boolean _started;
    private StringWriter _dtdWriter;
    private Writer _docWriter;

    protected BaseSerializer() {
        int n = 0;
        while (n < this._elementStates.length) {
            this._elementStates[n] = new ElementState();
            ++n;
        }
    }

    public synchronized void init(Writer writer, OutputFormat outputFormat) {
        if (outputFormat == null) {
            throw new NullPointerException("Argument 'format' is null.");
        }
        this._format = outputFormat;
        if (writer == null) {
            throw new NullPointerException("Argument 'format' is null.");
        }
        this._writer = new BufferedWriter(writer);
        this._lastPrintable = this._format.getLastPrintable();
        this._line = new StringBuffer(80);
        this._text = new StringBuffer(20);
        this._spaces = 0;
        this._nextIndent = 0;
        this._thisIndent = 0;
        this._exception = null;
        this._elementStateCount = 0;
        this._started = false;
        this._dtdWriter = null;
    }

    public synchronized void init(OutputStream outputStream, OutputFormat outputFormat) throws UnsupportedEncodingException {
        String string = outputFormat.getEncoding() == null ? "ASCII" : outputFormat.getEncoding();
        this.init(new OutputStreamWriter(outputStream, string), outputFormat);
    }

    public void serialize(Element element) throws IOException {
        try {
            this.startDocument();
        }
        catch (SAXException sAXException) {}
        this.serializeNode(element);
        this.flush();
        if (this._exception != null) {
            throw this._exception;
        }
    }

    public void serialize(Document document) throws IOException {
        try {
            this.startDocument();
        }
        catch (SAXException sAXException) {}
        this.serializeNode(document);
        this.serializePreRoot();
        this.flush();
        if (this._exception != null) {
            throw this._exception;
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        this.characters(new String(cArray, n, n2), false, false);
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) {
        this.content();
        if (this._format.getIndenting()) {
            this._thisIndent = 0;
            int n3 = n;
            while (n2-- > 0) {
                if (cArray[n3] == '\n' || cArray[n3] == '\r') {
                    this.breakLine();
                } else {
                    this._text.append(cArray[n3]);
                }
                ++n3;
            }
        }
    }

    public void processingInstruction(String string, String string2) {
        ElementState elementState = this.content();
        StringBuffer stringBuffer = new StringBuffer(40);
        int n = string.indexOf("?>");
        if (n >= 0) {
            stringBuffer.append("<?").append(string.substring(0, n));
        } else {
            stringBuffer.append("<?").append(string);
        }
        if (string2 != null) {
            stringBuffer.append(' ');
            n = string2.indexOf("?>");
            if (n >= 0) {
                stringBuffer.append(string2.substring(0, n));
            } else {
                stringBuffer.append(string2);
            }
        }
        stringBuffer.append("?>");
        if (elementState == null) {
            if (this._preRoot == null) {
                this._preRoot = new Vector();
            }
            this._preRoot.addElement(stringBuffer.toString());
            return;
        }
        this.indent();
        this.printText(stringBuffer, true);
        this.unindent();
    }

    public void comment(char[] cArray, int n, int n2) {
        this.comment(new String(cArray, n, n2));
    }

    public void comment(String string) {
        ElementState elementState = this.content();
        StringBuffer stringBuffer = new StringBuffer(40);
        int n = string.indexOf("-->");
        if (n >= 0) {
            stringBuffer.append("<!--").append(string.substring(0, n)).append("-->");
        } else {
            stringBuffer.append("<!--").append(string).append("-->");
        }
        if (elementState == null) {
            if (this._preRoot == null) {
                this._preRoot = new Vector();
            }
            this._preRoot.addElement(stringBuffer.toString());
            return;
        }
        this.indent();
        this.printText(stringBuffer, false);
        this.unindent();
    }

    public void startCDATA() {
        ElementState elementState = this.getElementState();
        if (elementState != null) {
            elementState.cdata = true;
        }
    }

    public void endCDATA() {
        ElementState elementState = this.getElementState();
        if (elementState != null) {
            elementState.cdata = false;
        }
    }

    public void endDocument() throws SAXException {
        this.serializePreRoot();
        this.flush();
        if (this._exception != null) {
            throw new SAXException(this._exception);
        }
    }

    public void startEntity(String string) {
    }

    public void endEntity(String string) {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDTD(String string, String string2, String string3) {
        this.enterDTD();
        this._format.setDoctype(string2, string3);
    }

    public void endDTD() {
    }

    public void elementDecl(String string, String string2) {
        this.enterDTD();
        this.printText("<!ELEMENT " + string + " " + string2 + ">");
        if (this._format.getIndenting()) {
            this.breakLine();
        }
    }

    public void attributeDecl(String string, String string2, String string3, String string4, String string5) {
        this.enterDTD();
        StringBuffer stringBuffer = new StringBuffer(40);
        stringBuffer.append("<!ATTLIST ").append(string).append(' ');
        stringBuffer.append(string2).append(' ').append(string3);
        if (string4 != null) {
            stringBuffer.append(' ').append(string4);
        }
        if (string5 != null) {
            stringBuffer.append(" \"").append(this.escape(string5)).append('\"');
        }
        stringBuffer.append('>');
        this.printText(stringBuffer.toString());
        if (this._format.getIndenting()) {
            this.breakLine();
        }
    }

    public void internalEntityDecl(String string, String string2) {
        this.enterDTD();
        this.printText("<!ENTITY " + string + " \"" + this.escape(string2) + "\">");
        if (this._format.getIndenting()) {
            this.breakLine();
        }
    }

    public void externalEntityDecl(String string, String string2, String string3) {
        this.enterDTD();
        this.unparsedEntityDecl(string, string2, string3, null);
    }

    public void unparsedEntityDecl(String string, String string2, String string3, String string4) {
        this.enterDTD();
        if (string2 != null) {
            this.printText("<!ENTITY " + string + " SYSTEM ");
            this.printDoctypeURL(string3);
        } else {
            this.printText("<!ENTITY " + string + " PUBLIC ");
            this.printDoctypeURL(string2);
            this.printText(" ");
            this.printDoctypeURL(string3);
        }
        if (string4 != null) {
            this.printText(" NDATA " + string4);
        }
        this.printText(">");
        if (this._format.getIndenting()) {
            this.breakLine();
        }
    }

    public void notationDecl(String string, String string2, String string3) {
        this.enterDTD();
        if (string2 != null) {
            this.printText("<!NOTATION " + string + " PUBLIC ");
            this.printDoctypeURL(string2);
            if (string3 != null) {
                this.printText("  ");
                this.printDoctypeURL(string3);
            }
        } else {
            this.printText("<!NOTATION " + string + " SYSTEM ");
            this.printDoctypeURL(string3);
        }
        this.printText(">");
        if (this._format.getIndenting()) {
            this.breakLine();
        }
    }

    protected void enterDTD() {
        if (this._dtdWriter == null) {
            this._line.append((Object)this._text);
            this._text = new StringBuffer(20);
            this.flushLine();
            this._dtdWriter = new StringWriter();
            this._docWriter = this._writer;
            this._writer = this._dtdWriter;
        }
    }

    protected String leaveDTD() {
        if (this._writer == this._dtdWriter) {
            this._line.append((Object)this._text);
            this._text = new StringBuffer(20);
            this.flushLine();
            this._writer = this._docWriter;
            return this._dtdWriter.toString();
        }
        return null;
    }

    protected void serializeNode(Node node) {
        switch (node.getNodeType()) {
            case 3: {
                this.characters(node.getNodeValue(), false, false);
                return;
            }
            case 4: {
                this.characters(node.getNodeValue(), true, false);
                return;
            }
            case 8: {
                this.comment(node.getNodeValue());
                return;
            }
            case 5: {
                this.content();
                this.printText(String.valueOf('&') + node.getNodeName() + ';');
                return;
            }
            case 7: {
                this.processingInstruction(node.getNodeName(), node.getNodeValue());
                return;
            }
            case 1: {
                this.serializeElement((Element)node);
                return;
            }
            case 9: {
                DocumentType documentType = ((Document)node).getDoctype();
                if (documentType != null) {
                    int n;
                    this.startDTD(documentType.getName(), null, null);
                    NamedNodeMap namedNodeMap = documentType.getEntities();
                    if (namedNodeMap != null) {
                        n = 0;
                        while (n < namedNodeMap.getLength()) {
                            Entity entity = (Entity)namedNodeMap.item(n);
                            this.unparsedEntityDecl(entity.getNodeName(), entity.getPublicId(), entity.getSystemId(), entity.getNotationName());
                            ++n;
                        }
                    }
                    if ((namedNodeMap = documentType.getNotations()) != null) {
                        n = 0;
                        while (n < namedNodeMap.getLength()) {
                            Notation notation = (Notation)namedNodeMap.item(n);
                            this.notationDecl(notation.getNodeName(), notation.getPublicId(), notation.getSystemId());
                            ++n;
                        }
                    }
                    this.endDTD();
                }
            }
            case 11: {
                Node node2 = node.getFirstChild();
                while (node2 != null) {
                    this.serializeNode(node2);
                    node2 = node2.getNextSibling();
                }
                return;
            }
        }
    }

    protected ElementState content() {
        ElementState elementState = this.getElementState();
        if (elementState != null) {
            if (elementState.empty) {
                this.printText(">");
                elementState.empty = false;
            }
            elementState.afterElement = false;
        }
        return elementState;
    }

    protected void characters(String string, boolean bl, boolean bl2) {
        ElementState elementState = this.content();
        bl = elementState.cdata;
        if (elementState != null) {
            bl = bl || elementState.cdata;
            boolean bl3 = bl2 = bl2 || elementState.unescaped;
        }
        if (bl) {
            StringBuffer stringBuffer = new StringBuffer(string.length());
            int n = string.indexOf("]]>");
            while (n >= 0) {
                stringBuffer.append("<![CDATA[").append(string.substring(0, n + 2)).append("]]>");
                string = string.substring(n + 2);
                n = string.indexOf("]]>");
            }
            stringBuffer.append("<![CDATA[").append(string).append("]]>");
            int n2 = this._nextIndent;
            this._nextIndent = 0;
            this.printText(stringBuffer, true);
            this._nextIndent = n2;
            return;
        }
        if (bl2) {
            int n = this._nextIndent;
            this._nextIndent = 0;
            this.printText(string, true);
            this._nextIndent = n;
            return;
        }
        if (elementState != null && elementState.preserveSpace) {
            int n = this._nextIndent;
            this._nextIndent = 0;
            this.printText(this.escape(string), true);
            this._nextIndent = n;
            return;
        }
        this.printText(this.escape(string), false);
    }

    protected abstract String getEntityRef(char var1);

    protected abstract void serializeElement(Element var1);

    protected void serializePreRoot() {
        if (this._preRoot != null) {
            int n = 0;
            while (n < this._preRoot.size()) {
                this.printText((String)this._preRoot.elementAt(n), true);
                this.breakLine();
                ++n;
            }
            this._preRoot.removeAllElements();
        }
    }

    protected final void printText(String string) {
        this._text.append(string);
    }

    protected final void printText(char[] cArray, int n, int n2) {
        this._text.append(cArray, n, n2);
    }

    protected final void printText(String string, boolean bl) {
        if (bl) {
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                if (c == '\n' || c == '\r') {
                    this.breakLine();
                } else {
                    this._text.append(c);
                }
                ++n;
            }
            return;
        }
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == ' ' || c == '\f' || c == '\t' || c == '\n' || c == '\r') {
                this.printSpace();
            } else {
                this._text.append(c);
            }
            ++n;
        }
    }

    protected final void printText(StringBuffer stringBuffer, boolean bl) {
        if (bl) {
            int n = 0;
            while (n < stringBuffer.length()) {
                char c = stringBuffer.charAt(n);
                if (c == '\n' || c == '\r') {
                    this.breakLine();
                } else {
                    this._text.append(c);
                }
                ++n;
            }
            return;
        }
        int n = 0;
        while (n < stringBuffer.length()) {
            char c = stringBuffer.charAt(n);
            if (c == ' ' || c == '\f' || c == '\t' || c == '\n' || c == '\r') {
                this.printSpace();
            } else {
                this._text.append(c);
            }
            ++n;
        }
    }

    protected final void printSpace() {
        if (this._text.length() > 0) {
            block5: {
                if (this._format.getLineWidth() > 0 && this._thisIndent + this._line.length() + this._spaces + this._text.length() > this._format.getLineWidth()) {
                    this.flushLine();
                    try {
                        this._writer.write(this._format.getLineSeparator());
                    }
                    catch (IOException iOException) {
                        if (this._exception != null) break block5;
                        this._exception = iOException;
                    }
                }
            }
            while (this._spaces > 0) {
                this._line.append(' ');
                --this._spaces;
            }
            this._line.append((Object)this._text);
            this._text = new StringBuffer(20);
        }
        ++this._spaces;
    }

    protected final void breakLine() {
        if (this._text.length() > 0) {
            while (this._spaces > 0) {
                this._line.append(' ');
                --this._spaces;
            }
            this._line.append((Object)this._text);
            this._text = new StringBuffer(20);
        }
        this.flushLine();
        try {
            this._writer.write(this._format.getLineSeparator());
            return;
        }
        catch (IOException iOException) {
            if (this._exception == null) {
                this._exception = iOException;
            }
            return;
        }
    }

    private void flushLine() {
        block6: {
            if (this._line.length() > 0) {
                try {
                    if (this._format.getIndenting()) {
                        int n = this._thisIndent;
                        if (2 * n > this._format.getLineWidth() && this._format.getLineWidth() > 0) {
                            n = this._format.getLineWidth() / 2;
                        }
                        while (n > 0) {
                            this._writer.write(32);
                            --n;
                        }
                    }
                    this._thisIndent = this._nextIndent;
                    this._spaces = 0;
                    this._writer.write(this._line.toString());
                    this._line = new StringBuffer(40);
                    return;
                }
                catch (IOException iOException) {
                    if (this._exception != null) break block6;
                    this._exception = iOException;
                    return;
                }
            }
        }
    }

    public void flush() {
        this.breakLine();
        try {
            this._writer.flush();
            return;
        }
        catch (IOException iOException) {
            if (this._exception == null) {
                this._exception = iOException;
            }
            return;
        }
    }

    protected void indent() {
        this._nextIndent += this._format.getIndent();
    }

    protected void unindent() {
        this._nextIndent -= this._format.getIndent();
        if (this._nextIndent < 0) {
            this._nextIndent = 0;
        }
        if (this._line.length() + this._spaces + this._text.length() == 0) {
            this._thisIndent = this._nextIndent;
        }
    }

    protected void printDoctypeURL(String string) {
        this._text.append('\"');
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) == '\"' || string.charAt(n) < ' ' || string.charAt(n) > '\u007f') {
                this._text.append("%").append(Integer.toHexString(string.charAt(n)));
            } else {
                this._text.append(string.charAt(n));
            }
            ++n;
        }
        this._text.append('\"');
    }

    protected String escape(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c < ' ' && c != '\t' && c != '\n' && c != '\r' || c > this._lastPrintable || c == '\u00f7') {
                stringBuffer.append("&#").append(Integer.toString(c)).append(';');
            } else {
                String string2 = this.getEntityRef(c);
                if (string2 == null) {
                    stringBuffer.append(c);
                } else {
                    stringBuffer.append('&').append(string2).append(';');
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    protected ElementState getElementState() {
        if (this._elementStateCount == 0) {
            return null;
        }
        return this._elementStates[this._elementStateCount - 1];
    }

    protected ElementState enterElementState(String string, boolean bl) {
        if (this._elementStateCount == this._elementStates.length) {
            ElementState[] elementStateArray = new ElementState[this._elementStates.length + 5];
            System.arraycopy(this._elementStates, 0, elementStateArray, 0, this._elementStates.length);
            this._elementStates = elementStateArray;
            int n = this._elementStateCount;
            while (n < this._elementStates.length) {
                this._elementStates[n] = new ElementState();
                ++n;
            }
        }
        ElementState elementState = this._elementStates[this._elementStateCount];
        elementState.tagName = string;
        elementState.preserveSpace = bl;
        elementState.empty = true;
        elementState.afterElement = false;
        ++this._elementStateCount;
        return elementState;
    }

    protected ElementState leaveElementState() {
        if (this._elementStateCount > 1) {
            --this._elementStateCount;
            return this._elementStates[this._elementStateCount - 1];
        }
        if (this._elementStateCount == 1) {
            --this._elementStateCount;
            return null;
        }
        return null;
    }

    public abstract void startDocument() throws SAXException;

    public abstract void startElement(String var1, AttributeList var2) throws SAXException;

    public abstract void endElement(String var1) throws SAXException;
}

