/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serialize;

import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class OutputFormat {
    private String _method;
    private String _version;
    private int _indent;
    private String _encoding = "UTF8";
    private String _mediaType;
    private String _doctypeSystem;
    private String _doctypePublic;
    private boolean _omitXmlDeclaration = false;
    private boolean _standalone = false;
    private String[] _cdataElements;
    private String[] _nonEscapingElements;
    private String _lineSeparator = "\n";
    private int _lineWidth = 72;
    private boolean _preserve = false;
    public static final int DEFAULT_INDENT = 4;
    public static final String DEFAULT_ENCODING = "UTF8";
    public static final int DEFAULT_LINE_WIDTH = 72;
    public static final String METHOD_XML = "xml";
    public static final String METHOD_HTML = "html";
    public static final String METHOD_XHTML = "xhtml";
    public static final String METHOD_TEXT = "text";
    public static final String LINE_SEPARATOR_UNIX = "\n";
    public static final String LINE_SEPARATOR_WIN = "\r\n";
    public static final String LINE_SEPARATOR_MAC = "\r";
    public static final String LINE_SEPARATOR_WEB = "\n";
    public static final String DOCTYPE_HTML_PUBLIC = "-//W3C//DTD HTML 4.0//EN";
    public static final String DOCTYPE_HTML_SYSTEM = "http://www.w3.org/TR/WD-html-in-xml/DTD/xhtml1-strict.dtd";
    public static final String DOCTYPE_XHTML_PUBLIC = "-//W3C//DTD XHTML 1.0 Strict//EN";
    public static final String DOCTYPE_XHTML_SYSTEM = "http://www.w3.org/TR/WD-html-in-xml/DTD/xhtml1-strict.dtd";

    public OutputFormat() {
    }

    public OutputFormat(String string, String string2, boolean bl) {
        this.setMethod(string);
        this.setEncoding(string2);
        this.setIndenting(bl);
    }

    public OutputFormat(Document document) {
        this.setMethod(OutputFormat.whichMethod(document));
        this.setDoctype(OutputFormat.whichDoctypePublic(document), OutputFormat.whichDoctypeSystem(document));
        this.setMediaType(OutputFormat.whichMediaType(this.getMethod()));
    }

    public OutputFormat(Document document, String string, boolean bl) {
        this(document);
        this.setEncoding(string);
        this.setIndenting(bl);
    }

    public String getMethod() {
        return this._method;
    }

    public void setMethod(String string) {
        this._method = string;
    }

    public String getVersion() {
        return this._version;
    }

    public void setVersion(String string) {
        this._version = string;
    }

    public int getIndent() {
        return this._indent;
    }

    public boolean getIndenting() {
        return this._indent > 0;
    }

    public void setIndent(int n) {
        if (n < 0) {
            this._indent = 0;
            return;
        }
        this._indent = n;
    }

    public void setIndenting(boolean bl) {
        if (bl) {
            this._indent = 4;
            this._lineWidth = 72;
            return;
        }
        this._indent = 0;
        this._lineWidth = 0;
    }

    public String getEncoding() {
        return this._encoding;
    }

    public void setEncoding(String string) {
        this._encoding = string;
    }

    public String getMediaType() {
        return this._mediaType;
    }

    public void setMediaType(String string) {
        this._mediaType = string;
    }

    public void setDoctype(String string, String string2) {
        this._doctypePublic = string;
        this._doctypeSystem = string2;
    }

    public String getDoctypePublic() {
        return this._doctypePublic;
    }

    public String getDoctypeSystem() {
        return this._doctypeSystem;
    }

    public boolean getOmitXMLDeclaration() {
        return this._omitXmlDeclaration;
    }

    public void setOmitXMLDeclaration(boolean bl) {
        this._omitXmlDeclaration = bl;
    }

    public boolean getStandalone() {
        return this._standalone;
    }

    public void setStandalone(boolean bl) {
        this._standalone = bl;
    }

    public String[] getCDataElements() {
        return this._cdataElements;
    }

    public boolean isCDataElement(String string) {
        if (this._cdataElements == null) {
            return false;
        }
        int n = 0;
        while (n < this._cdataElements.length) {
            if (this._cdataElements[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void setCDataElements(String[] stringArray) {
        this._cdataElements = stringArray;
    }

    public String[] getNonEscapingElements() {
        return this._nonEscapingElements;
    }

    public boolean isNonEscapingElement(String string) {
        if (this._nonEscapingElements == null) {
            return false;
        }
        int n = 0;
        while (n < this._nonEscapingElements.length) {
            if (this._nonEscapingElements[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void setNonEscapingElements(String[] stringArray) {
        this._nonEscapingElements = stringArray;
    }

    public String getLineSeparator() {
        return this._lineSeparator;
    }

    public void setLineSeparator(String string) {
        if (string == null) {
            this._lineSeparator = "\n";
            return;
        }
        this._lineSeparator = string;
    }

    public boolean getPreserveSpace() {
        return this._preserve;
    }

    public void setPreserveSpace(boolean bl) {
        this._preserve = bl;
    }

    public int getLineWidth() {
        return this._lineWidth;
    }

    public void setLineWidth(int n) {
        if (n <= 0) {
            this._lineWidth = 0;
            return;
        }
        this._lineWidth = n;
    }

    public char getLastPrintable() {
        if (this.getEncoding() != null && this.getEncoding().equalsIgnoreCase("ASCII")) {
            return '\u00ff';
        }
        return '\uffff';
    }

    public static String whichMethod(Document document) {
        Node node = document.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1) {
                if (node.getNodeName().equalsIgnoreCase(METHOD_HTML)) {
                    return METHOD_HTML;
                }
                return METHOD_XML;
            }
            if (node.getNodeType() == 3) {
                String string = node.getNodeValue();
                int n = 0;
                while (n < string.length()) {
                    if (string.charAt(n) != ' ' && string.charAt(n) != '\n' && string.charAt(n) != '\t' && string.charAt(n) != '\r') {
                        return METHOD_XML;
                    }
                    ++n;
                }
            }
            node = node.getNextSibling();
        }
        return METHOD_XML;
    }

    public static String whichDoctypePublic(Document document) {
        return null;
    }

    public static String whichDoctypeSystem(Document document) {
        return null;
    }

    public static String whichMediaType(String string) {
        if (string.equalsIgnoreCase(METHOD_XML)) {
            return "text/xml";
        }
        if (string.equalsIgnoreCase(METHOD_HTML)) {
            return "text/html";
        }
        if (string.equalsIgnoreCase(METHOD_TEXT)) {
            return "text/plain";
        }
        return null;
    }
}

